/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import proper.engine.Engine;
import proper.engine.Weka;
import proper.util.Stopwatch;
import proper.util.Strings;
import proper.util.WekaHelper;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.Experiment;
import weka.experiment.InstancesResultListener;
import weka.experiment.PropertyNode;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;

public class WekaExperimenter
extends Engine {
    public WekaExperimenter() {
        this.setParameter("classifier", "weka.classifiers.trees.J48");
        this.setParameter("additional", "");
        this.setParameter("input", "tmp/input.arff");
        this.setParameter("output", "tmp/output.arff");
        this.setParameter("runs", "10");
        this.setParameter("folds", "10");
    }

    private void printClassifier() {
        this.println("\nClassifier\n==========\n");
        Weka engine = new Weka();
        this.addListener(engine);
        engine.setParameter("classifier", this.getStringParameter("classifier"));
        engine.setParameter("additional", this.getStringParameter("additional"));
        engine.setParameter("type", "output");
        engine.setParameter("train", this.getStringParameter("input"));
        engine.setParameter("folds", this.getStringParameter("folds"));
        ((Engine)engine).execute();
    }

    private int determineRuns() {
        this.print("Determining Runs... ");
        int result = new Integer(this.getStringParameter("runs"));
        if (this.getStringParameter("type") != null && this.getStringParameter("type").equals("loo")) {
            result = 1;
        }
        this.println(result);
        return result;
    }

    private int determineFolds() {
        this.print("Determining Folds... ");
        if (this.getStringParameter("type") != null && this.getStringParameter("type").equals("loo")) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.getStringParameter("input")));
                Instances inst = new Instances((Reader)reader);
                if (inst.classIndex() == -1) {
                    inst.setClassIndex(inst.numAttributes() - 1);
                }
                this.setParameter("folds", Integer.toString(inst.numInstances()));
                reader.close();
            }
            catch (Exception e) {
                this.println(e);
            }
        }
        int result = new Integer(this.getStringParameter("folds"));
        this.println(result);
        return result;
    }

    @Override
    public boolean execute() {
        Classifier[] cArray;
        super.execute();
        int runs = this.determineRuns();
        int folds = this.determineFolds();
        this.printClassifier();
        this.println("\nExperimenter\n============\n");
        Experiment exp = new Experiment();
        exp.setPropertyArray((Object)new Classifier[0]);
        exp.setUsePropertyIterator(true);
        exp.setRunLower(1);
        exp.setRunUpper(runs);
        exp.setNotes("");
        exp.setAdvanceDataSetFirst(true);
        ClassifierSplitEvaluator se = new ClassifierSplitEvaluator();
        Classifier sec = se.getClassifier();
        CrossValidationResultProducer cvrp = new CrossValidationResultProducer();
        cvrp.setNumFolds(folds);
        cvrp.setSplitEvaluator((SplitEvaluator)se);
        PropertyNode[] propertyPath = new PropertyNode[2];
        try {
            propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", CrossValidationResultProducer.class), CrossValidationResultProducer.class);
            propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
        exp.setResultProducer((ResultProducer)cvrp);
        exp.setPropertyPath(propertyPath);
        exp.getDatasets().addElement(new File(this.getStringParameter("input")));
        try {
            cArray = new Classifier[]{WekaHelper.getClassifierInstance(this.getStringParameter("classifier"))};
            exp.setPropertyArray((Object)cArray);
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
        String[] adds = Strings.breakUp(this.getStringParameter("additional"));
        WekaHelper.setOptions((Object)cArray[0], adds);
        InstancesResultListener irl = new InstancesResultListener();
        irl.setOutputFile(new File(this.getStringParameter("output")));
        exp.setResultListener((ResultListener)irl);
        this.println("\nStarting experiment...\n");
        Stopwatch watchOverall = new Stopwatch();
        watchOverall.start();
        Stopwatch watch = new Stopwatch();
        try {
            exp.initialize();
            while (exp.hasMoreIterations()) {
                watch.start();
                this.print(String.valueOf(exp.getCurrentRunNumber()) + ". " + exp.getDatasets().elementAt(exp.getCurrentDatasetNumber()) + "... ");
                exp.nextIteration();
                this.println(String.valueOf(watch.getSeconds()) + "s");
            }
            exp.postProcess();
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
        this.println("\nOverall time: " + watchOverall.getSeconds() + "s");
        this.println("\nResult can be found in: " + this.getStringParameter("output"));
        return true;
    }
}

