/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import proper.app.DatabaseApplication;
import proper.database.Connector;
import proper.database.JoinTreeNode;
import proper.database.RelationDiscoverer;

public class Relations
extends DatabaseApplication {
    private int maxDepth;

    @Override
    protected void defaultParameters() {
        super.defaultParameters();
        this.maxDepth = 1;
    }

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("table", "the table to discover the relations for", true, "<name>", false);
        this.addDefinition("exclude_tables", "tables you want to exclude from the discovering", true, "<name[,name...]>", true);
        this.addDefinition("max_depth", "defines the maximal depth the search for relations does, -1 means unlimited\ndefault is: " + this.maxDepth, true, "<int>", true);
        this.addDefinition("use_foreign_keys", "uses foreign key relations to determine relations between tables rather \nthan matching column names", false, "", true);
    }

    @Override
    public void printDescription() {
        System.out.println("Displays the relations in a database, starting from one table.");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        Connector conn = new Connector(this.cl.getValue("driver"), this.cl.getValue("url"), this.cl.getValue("database"), this.cl.getValue("user"), this.cl.getValue("password"));
        conn.setLimit(this.cl.getValue("sql_limit"));
        this.addListener(conn);
        RelationDiscoverer discoverer = new RelationDiscoverer(conn);
        discoverer.setTable(this.cl.getValue("table"));
        discoverer.setExcludes(this.cl.getValue("exclude_tables"));
        discoverer.setMaxDepth(Integer.parseInt(this.fixAdditionalArg(this.cl.getValue("max_depth", Integer.toString(this.maxDepth)))));
        discoverer.setUseForeignKeys(this.cl.exists("use_foreign_keys"));
        JoinTreeNode root = discoverer.discover();
        this.println();
        this.println("Database : " + this.cl.getValue("database"));
        this.println("Table    : " + this.cl.getValue("table"));
        this.println("Relations:\n");
        this.println(root.toString(true));
        this.println("as String:\n" + root.toTreeString(true) + "\n");
        this.println("Undiscovered Tables:");
        this.println(discoverer.leftOverTables(root));
        conn.disconnect();
        return true;
    }

    public static void main(String[] args) throws Exception {
        Relations app = new Relations();
        app.run(args);
    }
}

