/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.basic.subsumption;

import ida.ilp.basic.Clause;
import ida.ilp.basic.Constant;
import ida.ilp.basic.Literal;
import ida.ilp.basic.LogicUtils;
import ida.ilp.basic.Term;
import ida.ilp.basic.subsumption.SubsumptionUtils;
import ida.utils.Combinatorics;
import ida.utils.IntegerFunction;
import ida.utils.Sugar;
import ida.utils.VectorUtils;
import ida.utils.collections.IntegerSet;
import ida.utils.collections.MultiMap;
import ida.utils.collections.ValueToIndex;
import ida.utils.collections.VectorSet;
import ida.utils.random.CustomRandomGenerator;
import ida.utils.tuples.Pair;
import ida.utils.tuples.Triple;
import ida.utils.tuples.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;

public class SubsumptionEngineJ2 {
    private int lowArity = 5;
    private ValueToIndex<String> predicatesToIntegers = new ValueToIndex();
    private Random random = new Random();
    private boolean learnVariableOrder = true;
    private int exploredNodesInCurrentRestart = 0;
    private int currentCutoff = Integer.MAX_VALUE;
    private int maxRestarts = Integer.MAX_VALUE;
    private int forcedVariable = -1;
    public static final int THETA = 1;
    public static final int OBJECT_IDENTITY = 2;
    public static final int SELECTIVE_OBJECT_IDENTITY = 3;
    private int subsumptionMode = 1;
    private int forwardCheckingFrom = 1;
    private int arcConsistencyFrom = 6;
    private int[] firstVariableOrder;
    private int[] lastVariableOrder;
    private IntegerFunction restartSequence = new IntegerFunction.ConstantFunction(Integer.MAX_VALUE);
    private boolean solvedWithoutSearch = false;
    private int numberOfLastRestart = -1;
    private long timeout = Long.MAX_VALUE;

    public Pair<Term[], List<Term[]>> allSolutions(Clause c, Clause e) {
        return this.allSolutions(c, e, Integer.MAX_VALUE);
    }

    public Pair<Term[], List<Term[]>> allSolutions(Clause c, Clause e, int maxCount) {
        return this.allSolutions(new ClauseC(c), new ClauseE(e), maxCount);
    }

    public Pair<Term[], List<Term[]>> allSolutions(ClauseC c, ClauseE e) {
        return this.allSolutions(c, e, Integer.MAX_VALUE);
    }

    public Pair<Term[], List<Term[]>> allSolutions(ClauseC c, ClauseE e, int maxCount) {
        long m1 = System.currentTimeMillis();
        if (!this.initialUnsatCheck(c, e) || !c.initialize(e)) {
            this.solvedWithoutSearch = true;
            Term[] template = new Term[c.containedIn.length];
            for (int i = 0; i < template.length; ++i) {
                template[i] = (Term)c.variablesToIntegers.indexToValue(i);
            }
            return new Pair<Term[], List<Term[]>>(template, new ArrayList(1));
        }
        ArrayList<Term[]> solutions = new ArrayList<Term[]>();
        int[] variableOrder = this.variableOrder(c, e, false);
        Term[] template = new Term[variableOrder.length];
        for (int i = 0; i < variableOrder.length; ++i) {
            template[i] = (Term)c.variablesToIntegers.indexToValue(i);
        }
        this.solvedWithoutSearch = false;
        long m2 = System.currentTimeMillis();
        this.solveAll(c, e, 0, variableOrder, new HashSet<Integer>(), template, solutions, maxCount);
        long m3 = System.currentTimeMillis();
        return new Pair<Term[], List<Term[]>>(template, solutions);
    }

    private Boolean solveAll(ClauseC c, ClauseE e, int varIndex, int[] variableOrder, Set<Integer> oiSet, Term[] template, List<Term[]> solutions, int maxCount) {
        if (varIndex == variableOrder.length) {
            Term[] solution = new Term[variableOrder.length];
            for (int i = 0; i < variableOrder.length; ++i) {
                solution[i] = e.termsToIntegers.indexToValue(c.groundedValues[i]);
            }
            solutions.add(solution);
            return Boolean.TRUE;
        }
        int[] valueOrder = this.valueOrder(c, e, variableOrder[varIndex], 1);
        for (int i = 0; i < valueOrder.length; ++i) {
            if (this.subsumptionMode == 2 && oiSet.contains(valueOrder[i]) || this.subsumptionMode == 3 && !template[varIndex].name().startsWith("_") && oiSet.contains(valueOrder[i])) continue;
            IntegerSet[] oldDomains = c.oldDomains();
            if (c.groundFC(variableOrder[varIndex], valueOrder[i], e)) {
                if (solutions.size() >= maxCount) {
                    return Boolean.TRUE;
                }
                if (this.subsumptionMode == 2) {
                    oiSet.add(valueOrder[i]);
                } else if (this.subsumptionMode == 3 && !template[varIndex].name().startsWith("_")) {
                    oiSet.add(valueOrder[i]);
                }
                this.solveAll(c, e, varIndex + 1, variableOrder, oiSet, template, solutions, maxCount);
                if (this.subsumptionMode == 2) {
                    oiSet.remove(valueOrder[i]);
                } else if (this.subsumptionMode == 3 && !template[varIndex].name().startsWith("_")) {
                    oiSet.remove(valueOrder[i]);
                }
            }
            c.unground(variableOrder[varIndex]);
            c.restoreDomains(oldDomains);
        }
        return Boolean.FALSE;
    }

    public Boolean solveWithResumer1(Clause c, Clause e) {
        return this.solveWithResumer(new ClauseC(c), new ClauseE(e), 1);
    }

    public Boolean solveWithResumer2(Clause c, Clause e) {
        return this.solveWithResumer(new ClauseC(c), new ClauseE(e), 2);
    }

    public Boolean solveWithResumer3(Clause c, Clause e) {
        return this.solveWithResumer(new DecomposedClauseC(c), new ClauseE(e), 3);
    }

    public Boolean solveWithResumer1(ClauseC c, ClauseE e) {
        return this.solveWithResumer(c, e, 1);
    }

    public Boolean solveWithResumer2(ClauseC c, ClauseE e) {
        return this.solveWithResumer(c, e, 2);
    }

    public Boolean solveWithResumer(Clause c, Clause e, int resumerType) {
        if (resumerType == 3) {
            return this.solveWithResumer(new DecomposedClauseC(c), new ClauseE(e), resumerType);
        }
        return this.solveWithResumer(new ClauseC(c), new ClauseE(e), resumerType);
    }

    public Boolean solveWithResumer(ClauseStructure cs, ClauseE e, int resumerVersion) {
        if (resumerVersion == 3) {
            throw new UnsupportedOperationException();
        }
        this.numberOfLastRestart = 0;
        if (!this.initialUnsatCheck(cs, e)) {
            this.solvedWithoutSearch = true;
            return Boolean.FALSE;
        }
        ClauseC c = null;
        c = resumerVersion <= 2 ? (ClauseC)cs : ((DecomposedClauseC)cs).clauseC;
        Boolean success = null;
        IntegerSet[] oldDomains = null;
        int restart = 1;
        boolean ac = false;
        long deadline = Long.MAX_VALUE;
        if (this.timeout != Long.MAX_VALUE) {
            deadline = System.currentTimeMillis() + this.timeout;
        }
        if (!cs.initialize(e)) {
            this.solvedWithoutSearch = true;
            this.numberOfLastRestart = restart;
            return Boolean.FALSE;
        }
        if (c.literals.length == 0) {
            this.solvedWithoutSearch = true;
            return Boolean.TRUE;
        }
        do {
            this.exploredNodesInCurrentRestart = 0;
            this.currentCutoff = this.restartSequence.f(restart) + 2 * c.variableDomains.length;
            int[] variableOrder = resumerVersion > 1 && restart % 2 == 0 && this.forcedVariable != -1 ? this.variableOrder(c, e, this.forcedVariable, true) : this.variableOrder(c, e, true);
            Arrays.fill(c.groundedValues, -1);
            if (oldDomains != null) {
                c.restoreDomains(oldDomains);
            }
            if (!ac && restart >= this.getArcConsistencyFrom()) {
                if (!this.arcConsistencyOnProjection(c, e)) {
                    this.numberOfLastRestart = restart;
                    return false;
                }
                ac = true;
                oldDomains = c.oldDomains();
            }
            Term[] template = new Term[variableOrder.length];
            if (this.subsumptionMode == 3) {
                for (int i = 0; i < variableOrder.length; ++i) {
                    template[i] = (Term)c.variablesToIntegers.indexToValue(i);
                }
            }
            if (!(cs instanceof ClauseC)) continue;
            success = this.solveR(c, e, 0, variableOrder, restart, new HashSet<Integer>(), template, deadline);
        } while (success == null && restart++ < this.maxRestarts && System.currentTimeMillis() < deadline);
        this.solvedWithoutSearch = false;
        if (success == null) {
            this.firstVariableOrder = null;
        }
        this.numberOfLastRestart = restart;
        return success;
    }

    public void setRestartSequence(IntegerFunction f) {
        this.restartSequence = f;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private boolean initialUnsatCheck(ClauseStructure c, ClauseE e) {
        return c.predicates().isSubsetOf(e.predicates);
    }

    private Boolean solveR(ClauseC c, ClauseE e, int varIndex, int[] variableOrder, int restart, Set<Integer> oiSet, Term[] template, long deadline) {
        if (varIndex == variableOrder.length) {
            return Boolean.TRUE;
        }
        if (this.exploredNodesInCurrentRestart++ >= this.currentCutoff || this.exploredNodesInCurrentRestart % 100 == 0 && System.currentTimeMillis() >= deadline) {
            return null;
        }
        int[] valueOrder = this.valueOrder(c, e, variableOrder[varIndex], restart);
        for (int i = 0; i < valueOrder.length; ++i) {
            IntegerSet[] oldDomains = c.oldDomains();
            if (this.subsumptionMode == 2 && oiSet.contains(valueOrder[i]) || this.subsumptionMode == 3 && !template[varIndex].name().startsWith("_") && oiSet.contains(valueOrder[i])) continue;
            if (restart < this.getForwardCheckingFrom() && c.ground(variableOrder[varIndex], valueOrder[i], e) || restart >= this.getForwardCheckingFrom() && c.groundFC(variableOrder[varIndex], valueOrder[i], e)) {
                if (this.subsumptionMode == 2) {
                    oiSet.add(valueOrder[i]);
                } else if (this.subsumptionMode == 3 && !template[varIndex].name().startsWith("_")) {
                    oiSet.add(valueOrder[i]);
                }
                Boolean success = this.solveR(c, e, varIndex + 1, variableOrder, restart, oiSet, template, deadline);
                if (success == null) {
                    return null;
                }
                if (success.booleanValue()) {
                    return true;
                }
                if (this.subsumptionMode == 2) {
                    oiSet.remove(valueOrder[i]);
                } else if (this.subsumptionMode == 3 && !template[varIndex].name().startsWith("_")) {
                    oiSet.remove(valueOrder[i]);
                }
            } else {
                this.forcedVariable = variableOrder[varIndex];
            }
            c.unground(variableOrder[varIndex]);
            c.restoreDomains(oldDomains);
        }
        return Boolean.FALSE;
    }

    private int[] valueOrderForReduction(ClauseC c, ClauseE e, int variable, int restart) {
        int[] valueOrder = this.valueOrder(c, e, variable, restart);
        String strVar = ((Term)c.variablesToIntegers.indexToValue(variable)).name();
        for (int i = 0; i < valueOrder.length; ++i) {
            String strTerm = e.termsToIntegers.indexToValue(valueOrder[i]).name();
            if (!strVar.equals(strTerm)) continue;
            VectorUtils.swap(valueOrder, 0, i);
            break;
        }
        return valueOrder;
    }

    private int[] valueOrder(ClauseC c, ClauseE e, int variable, int restart) {
        if (c.groundedValues[variable] == -1) {
            int[] array = null;
            if (restart == 1) {
                array = c.variableDomains[variable].values();
            } else {
                array = VectorUtils.copyArray(c.variableDomains[variable].values());
                VectorUtils.shuffle(array, this.random);
            }
            return array;
        }
        return new int[]{c.groundedValues[variable]};
    }

    public Clause reduce(Clause clause) {
        Boolean success = null;
        long deadline = Long.MAX_VALUE;
        if (this.timeout != Long.MAX_VALUE) {
            deadline = System.currentTimeMillis() + this.timeout;
        }
        do {
            int[] variableOrder;
            ArrayList<Clause> clauseList = new ArrayList<Clause>();
            ClauseC c = new ClauseC(LogicUtils.variabilizeClause(clause));
            ClauseE e = new ClauseE(LogicUtils.constantizeClause(clause));
            c.initialize(e);
            int restart = 1;
            IntegerSet[] oldDomains = null;
            boolean ac = false;
            do {
                Arrays.fill(c.groundedValues, -1);
                if (oldDomains != null) {
                    c.restoreDomains(oldDomains);
                }
                if (!ac && restart >= this.getArcConsistencyFrom()) {
                    this.arcConsistencyOnProjection(c, e);
                    ac = true;
                    oldDomains = c.oldDomains();
                }
                variableOrder = this.variableOrder(c, e, false);
                this.exploredNodesInCurrentRestart = 0;
                this.currentCutoff = this.restartSequence.f(restart) + 2 * clause.variables().size();
            } while ((success = this.oneReduction(c, e, 0, variableOrder, new HashSet<Integer>(), clauseList, restart, deadline)) == null && restart++ < this.maxRestarts && System.currentTimeMillis() < deadline);
            if (success != Boolean.TRUE) continue;
            clause = (Clause)clauseList.get(0);
        } while (success != null && success.booleanValue() && System.currentTimeMillis() < deadline);
        return LogicUtils.variabilizeClause(clause);
    }

    private Boolean oneReduction(ClauseC c, ClauseE e, int varIndex, int[] variableOrder, Set<Integer> oiSet, List<Clause> solutions, int restart, long deadline) {
        if (varIndex == variableOrder.length) {
            Term[] solution = new Term[variableOrder.length];
            for (int i = 0; i < variableOrder.length; ++i) {
                solution[i] = e.termsToIntegers.indexToValue(c.groundedValues[variableOrder[i]]);
            }
            HashMap<Term, Term> substitution = new HashMap<Term, Term>();
            int i = 0;
            for (int vi : variableOrder) {
                Term var = (Term)c.variablesToIntegers.indexToValue(vi);
                substitution.put(var, solution[i]);
                ++i;
            }
            Clause clause = LogicUtils.substitute(c.toOriginalClause(), substitution);
            if (clause.countLiterals() < c.toOriginalClause().countLiterals()) {
                solutions.add(clause);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.exploredNodesInCurrentRestart++ >= this.currentCutoff || this.exploredNodesInCurrentRestart % 100 == 0 && System.currentTimeMillis() >= deadline) {
            return null;
        }
        int[] valueOrder = this.valueOrderForReduction(c, e, variableOrder[varIndex], 1);
        for (int i = 0; i < valueOrder.length; ++i) {
            IntegerSet[] oldDomains = c.oldDomains();
            if (c.groundFC(variableOrder[varIndex], valueOrder[i], e)) {
                Boolean succ = this.oneReduction(c, e, varIndex + 1, variableOrder, oiSet, solutions, restart, deadline);
                if (succ == null) {
                    return null;
                }
                if (succ.booleanValue()) {
                    return Boolean.TRUE;
                }
            }
            c.unground(variableOrder[varIndex]);
            c.restoreDomains(oldDomains);
        }
        return Boolean.FALSE;
    }

    private int[] variableOrder(ClauseC c, ClauseE e, boolean ignoreSingletons) {
        return this.variableOrder(c, e, -1, ignoreSingletons);
    }

    private int[] variableOrder(ClauseC c, ClauseE e, int fv, boolean ignoreSingletons) {
        if (this.learnVariableOrder && this.firstVariableOrder != null) {
            int[] ret = this.firstVariableOrder;
            this.firstVariableOrder = null;
            this.lastVariableOrder = ret;
            return ret;
        }
        int[] predicateCounts = new int[this.predicatesToIntegers.size()];
        for (int i = 0; i < e.literals.length; i += e.literals[i + 1] + 2) {
            int n = e.literals[i];
            predicateCounts[n] = predicateCounts[n] + 1;
        }
        ArrayList<Integer> variableOrder = new ArrayList<Integer>();
        double[] weights = new double[c.containedIn.length];
        int index = 0;
        for (IntegerSet containedIn : c.containedIn) {
            weights[index] = containedIn.size();
            int n = index;
            weights[n] = weights[n] / (double)c.variableDomains[index].size();
            ++index;
        }
        double[] heuristic1 = new double[c.containedIn.length];
        if (fv == -1) {
            CustomRandomGenerator crg = new CustomRandomGenerator(weights, this.random);
            variableOrder.add(crg.nextInt());
        } else {
            variableOrder.add(fv);
        }
        heuristic1[((Integer)variableOrder.get((int)0)).intValue()] = -1.0;
        for (int ci : c.containedIn[(Integer)variableOrder.get(0)].values()) {
            for (int i = 0; i < c.literals[ci + 1]; ++i) {
                if (heuristic1[c.literals[ci + 3 + i]] == -1.0) continue;
                int n = c.literals[ci + 3 + i];
                heuristic1[n] = heuristic1[n] + 1.0 * weights[c.literals[ci + 3 + i]];
            }
        }
        for (int i = 1; i < heuristic1.length; ++i) {
            int selected = this.maxIndexWithTieBreaking(heuristic1);
            heuristic1[selected] = -1.0;
            if (!ignoreSingletons || c.occurences[selected] > 1) {
                variableOrder.add(selected);
            }
            for (int ci : c.containedIn[selected].values()) {
                for (int j = 0; j < c.literals[ci + 1]; ++j) {
                    if (heuristic1[c.literals[ci + 3 + j]] == -1.0) continue;
                    int n = c.literals[ci + 3 + j];
                    heuristic1[n] = heuristic1[n] + 1.0 * weights[c.literals[ci + 3 + j]] / (double)predicateCounts[c.literals[ci]];
                }
            }
        }
        this.lastVariableOrder = VectorUtils.toIntegerArray(variableOrder);
        return this.lastVariableOrder;
    }

    public int[] getLastVariableOrder() {
        return this.lastVariableOrder;
    }

    public void setFirstVariableOrder(int[] order) {
        this.firstVariableOrder = order;
    }

    private int maxIndexWithTieBreaking(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        int maxIndex = 0;
        int index = 0;
        int countOfEqualValues = 0;
        int[] equal = new int[values.length];
        for (double value : values) {
            if (value > max) {
                max = value;
                maxIndex = index;
                countOfEqualValues = 0;
            } else if (value == max) {
                if (countOfEqualValues == 0) {
                    equal[countOfEqualValues] = maxIndex;
                    ++countOfEqualValues;
                }
                equal[countOfEqualValues] = index;
                ++countOfEqualValues;
            }
            ++index;
        }
        if (countOfEqualValues > 0) {
            return equal[this.random.nextInt(countOfEqualValues)];
        }
        return maxIndex;
    }

    public void setSubsumptionMode(int subsumptionMode) {
        this.subsumptionMode = subsumptionMode;
    }

    public boolean solvedWithoutSearch() {
        return this.solvedWithoutSearch;
    }

    public void setMaxRestarts(int maxRestarts) {
        this.maxRestarts = maxRestarts;
    }

    public void setForwardCheckingFrom(int forwardCheckingFrom) {
        this.forwardCheckingFrom = forwardCheckingFrom;
    }

    private boolean arcConsistencyOnProjection(ClauseC clauseC, ClauseE clauseE) {
        Stack<Triple<Integer, Integer, Integer>> stack = new Stack<Triple<Integer, Integer, Integer>>();
        HashMap<Integer, Set> domains = new HashMap<Integer, Set>();
        HashSet<Triple<Integer, Integer, Integer>> pairs = new HashSet<Triple<Integer, Integer, Integer>>();
        for (int i = 0; i < clauseC.literals.length; i += clauseC.literals[i + 1] + 3) {
            if (clauseC.literals[i + 1] <= 1) continue;
            for (int j = 0; j < clauseC.literals[i + 1]; ++j) {
                for (int k = 0; k < clauseC.literals[i + 1]; ++k) {
                    if (clauseC.literals[i + 3 + j] == clauseC.literals[i + 3 + k]) continue;
                    Triple<Integer, Integer, Integer> p1 = new Triple<Integer, Integer, Integer>(clauseC.literals[i + 3 + j], clauseC.literals[i + 3 + k], i);
                    if (!pairs.contains(p1)) {
                        stack.push(p1);
                        pairs.add(p1);
                    }
                    if (domains.containsKey(clauseC.literals[i + 3 + j])) continue;
                    domains.put(clauseC.literals[i + 3 + j], clauseC.variableDomains[clauseC.literals[i + 3 + j]].toSet());
                }
            }
        }
        while (!stack.isEmpty()) {
            Triple triple = (Triple)stack.pop();
            pairs.remove(triple);
            int oldSize = ((Set)domains.get(triple.r)).size();
            Set filteredDomain = clauseC.revise((Set)domains.get(triple.r), (Integer)triple.r, (Set)domains.get(triple.s), (Integer)triple.s, clauseE, (Integer)triple.t);
            if (filteredDomain.size() >= oldSize) continue;
            if (filteredDomain.isEmpty()) {
                return false;
            }
            for (int neighbour : clauseC.neighbours[(Integer)triple.r].values()) {
                if (neighbour == (Integer)triple.r) continue;
                for (int neighbLit : clauseC.containedIn[neighbour].values()) {
                    Triple<Integer, Integer, Integer> newTriple = new Triple<Integer, Integer, Integer>(neighbour, (Integer)triple.r, neighbLit);
                    if (pairs.contains(newTriple)) continue;
                    stack.push(newTriple);
                    pairs.add(newTriple);
                }
            }
            domains.put((Integer)triple.r, filteredDomain);
        }
        for (Map.Entry entry : domains.entrySet()) {
            clauseC.variableDomains[((Integer)entry.getKey()).intValue()] = IntegerSet.createIntegerSet((Set)entry.getValue());
        }
        return true;
    }

    public int getArcConsistencyFrom() {
        return this.arcConsistencyFrom;
    }

    public void setArcConsistencyFrom(int arcConsistencyFrom) {
        this.arcConsistencyFrom = arcConsistencyFrom;
    }

    public int getForwardCheckingFrom() {
        return this.forwardCheckingFrom;
    }

    public int getNoOfRestarts() {
        return this.numberOfLastRestart - 1;
    }

    public ClauseC createCluaseC(Clause c) {
        return new ClauseC(c);
    }

    public ClauseE createClauseE(Clause e) {
        return new ClauseE(e);
    }

    public void setRandomSeed(long seed) {
        this.random = new Random(seed);
    }

    public void setWhatIsLowArity(int lowArity) {
        this.lowArity = lowArity;
    }

    private static class LowArityLiterals {
        private VectorSet set = new VectorSet();
        private int maxArity;

        public LowArityLiterals(int[] literals, int[] indices, int maxArity) {
            this.maxArity = maxArity;
            for (int i : indices) {
                this.add(literals, i);
            }
        }

        public LowArityLiterals(int[] literals, int maxArity) {
            this.maxArity = maxArity;
            for (int i = 0; i < literals.length; i += literals[i + 1] + 2) {
                this.add(literals, i);
            }
        }

        public void add(int[] literals, int index) {
            int arity = literals[index + 1];
            if (arity <= this.maxArity) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int j = 0; j < arity; ++j) {
                    list.add(j);
                }
                List subsequences = Combinatorics.allSubsequences(list);
                for (Tuple t : subsequences) {
                    int[] literal = new int[arity + 2];
                    Arrays.fill(literal, -this.maxArity - 2);
                    literal[0] = literals[index];
                    literal[1] = literals[index + 1];
                    for (int k = 0; k < t.size(); ++k) {
                        literal[((Integer)t.get((int)k)).intValue() + 2] = literals[index + 2 + (Integer)t.get(k)];
                    }
                    this.set.add(literal);
                }
            }
        }

        public boolean match(int[] cliterals, int[] grounding, int index) {
            int[] cliteral = new int[cliterals[index + 1] + 2];
            cliteral[0] = cliterals[index];
            cliteral[1] = cliterals[index + 1];
            int i = index + 3;
            int j = 0;
            while (i < index + cliterals[index + 1] + 3) {
                cliteral[j + 2] = grounding[cliterals[i]] == -1 ? -this.maxArity - 2 : grounding[cliterals[i]];
                ++i;
                ++j;
            }
            return this.set.contains(cliteral);
        }
    }

    private static class HighArityLiterals {
        private Map<Triple<Integer, Integer, Integer>, Integer> lower;
        private Map<Triple<Integer, Integer, Integer>, Integer> upper;
        private int[] literals;
        private int maxArity;

        public HighArityLiterals(int[] lits, int maxArity) {
            int j;
            int i;
            this.maxArity = maxArity;
            ArrayList<Integer> tempLiterals = new ArrayList<Integer>();
            MultiMap<Triple<Integer, Integer, Integer>, Integer> bag = new MultiMap<Triple<Integer, Integer, Integer>, Integer>();
            for (i = 0; i < lits.length; i += lits[i + 1] + 2) {
                if (lits[i + 1] <= this.maxArity) continue;
                for (j = 0; j < lits[i + 1] + 2; ++j) {
                    tempLiterals.add(lits[i + j]);
                }
            }
            this.literals = VectorUtils.toIntegerArray(tempLiterals);
            for (i = 0; i < this.literals.length; i += this.literals[i + 1] + 2) {
                for (j = 0; j < this.literals[i + 1]; ++j) {
                    bag.put(new Triple<Integer, Integer, Integer>(this.literals[i], j, this.literals[i + 2 + j]), i);
                }
            }
            this.lower = new HashMap<Triple<Integer, Integer, Integer>, Integer>();
            this.upper = new HashMap<Triple<Integer, Integer, Integer>, Integer>();
            for (Map.Entry entry : bag.entrySet()) {
                this.lower.put((Triple<Integer, Integer, Integer>)entry.getKey(), (Integer)Sugar.findBest(entry.getValue(), new Sugar.MyComparator<Integer>(){

                    @Override
                    public boolean isABetterThanB(Integer a, Integer b) {
                        return a < b;
                    }
                }));
                this.upper.put((Triple<Integer, Integer, Integer>)entry.getKey(), (Integer)Sugar.findBest(entry.getValue(), new Sugar.MyComparator<Integer>(){

                    @Override
                    public boolean isABetterThanB(Integer a, Integer b) {
                        return a >= b;
                    }
                }));
            }
        }

        public boolean match(int[] cliterals, int[] grounding, int index) {
            int lowerBound = 0;
            int upperBound = this.literals.length;
            int predicate = cliterals[index];
            int[] cliteral = new int[cliterals[index + 1] + 2];
            cliteral[0] = cliterals[index];
            cliteral[1] = cliterals[index + 1];
            Triple<Integer, Integer, Integer> t = new Triple<Integer, Integer, Integer>(predicate, 0, 0);
            int i = index + 3;
            int j = 0;
            while (i < index + cliterals[index + 1] + 3) {
                if (grounding[cliterals[i]] == -1) {
                    cliteral[j + 2] = -this.maxArity - 2;
                } else {
                    Integer fromUpper;
                    cliteral[j + 2] = grounding[cliterals[i]];
                    t.s = j;
                    t.t = grounding[cliterals[i]];
                    Integer fromLower = this.lower.get(t);
                    if (fromLower == null || (fromUpper = this.upper.get(t)) == null) {
                        return false;
                    }
                    lowerBound = Math.max(lowerBound, fromLower);
                    upperBound = Math.min(upperBound, fromUpper);
                }
                ++i;
                ++j;
            }
            int iters = 0;
            block1: for (int i2 = lowerBound; i2 <= upperBound; i2 += this.literals[i2 + 1] + 2) {
                ++iters;
                for (int j2 = 0; j2 < cliteral.length; ++j2) {
                    if (cliteral[j2] > -1 && this.literals[i2 + j2] != cliteral[j2]) continue block1;
                }
                return true;
            }
            return false;
        }
    }

    public class ClauseE {
        protected ValueToIndex<Term> termsToIntegers = new ValueToIndex();
        protected Map<Pair<Integer, Integer>, IntegerSet> variableDomains = new HashMap<Pair<Integer, Integer>, IntegerSet>();
        protected int[] literals;
        private IntegerSet predicates;
        protected IntegerSet[] domainsByPredicates;
        private LowArityLiterals lal;
        private HighArityLiterals hal;

        public ClauseE(Clause c) {
            MultiMap<Integer, Integer> integerMultiMap = new MultiMap<Integer, Integer>();
            HashSet<Integer> predicates = new HashSet<Integer>();
            int literalIndex = 0;
            for (Literal literal : c.literals()) {
                integerMultiMap.put(SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(literal.predicate()), literalIndex);
                literalIndex += 2 + literal.arity();
                predicates.add(SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(literal.predicate()));
            }
            this.predicates = IntegerSet.createIntegerSet(predicates);
            this.domainsByPredicates = new IntegerSet[SubsumptionEngineJ2.this.predicatesToIntegers.size()];
            for (Map.Entry entry : integerMultiMap.entrySet()) {
                this.domainsByPredicates[((Integer)entry.getKey()).intValue()] = IntegerSet.createIntegerSet((Set)entry.getValue());
            }
            this.literals = new int[literalIndex];
            HashMap<Literal, Integer> intLitMap = new HashMap<Literal, Integer>();
            HashMap<Integer, Literal> hashMap = new HashMap<Integer, Literal>();
            int index = 0;
            MultiMap<Pair<Integer, Integer>, Integer> varDomains = new MultiMap<Pair<Integer, Integer>, Integer>();
            for (Literal literal : c.literals()) {
                this.literals[index] = SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(literal.predicate());
                this.literals[index + 1] = literal.arity();
                intLitMap.put(literal, index);
                hashMap.put(index, literal);
                index += 2;
                for (int j = 0; j < literal.arity(); ++j) {
                    this.literals[index + j] = this.termsToIntegers.valueToIndex(literal.get(j));
                    varDomains.put(new Pair<Integer, Integer>(this.literals[index - 2], j), this.literals[index + j]);
                }
                index += literal.arity();
            }
            for (Map.Entry entry : varDomains.entrySet()) {
                this.variableDomains.put((Pair<Integer, Integer>)entry.getKey(), IntegerSet.createIntegerSet((Set)entry.getValue()));
            }
            this.lal = new LowArityLiterals(this.literals, SubsumptionEngineJ2.this.lowArity);
            this.hal = new HighArityLiterals(this.literals, SubsumptionEngineJ2.this.lowArity);
        }

        public boolean checkLiteral(int[] cliterals, int[] grounding, int index) {
            if (cliterals[index + 1] <= SubsumptionEngineJ2.this.lowArity) {
                return this.lal.match(cliterals, grounding, index);
            }
            return this.hal.match(cliterals, grounding, index);
        }

        public String literalToString(int literal) {
            StringBuilder sb = new StringBuilder();
            sb.append((String)SubsumptionEngineJ2.this.predicatesToIntegers.indexToValue(this.literals[literal]));
            sb.append("(");
            for (int i = 0; i < this.literals[literal + 1]; ++i) {
                sb.append(this.termsToIntegers.indexToValue(this.literals[literal + 2 + i]));
                if (i >= this.literals[literal + 1] - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public class ClauseC
    implements ClauseStructure {
        protected int[] literals;
        private IntegerSet predicates;
        protected IntegerSet[] variableDomains;
        protected int[] groundedValues;
        private int[] occurences;
        private IntegerSet[] containedIn;
        private IntegerSet[] neighbours;
        private ValueToIndex<Term> variablesToIntegers = new ValueToIndex();

        protected ClauseC() {
        }

        public ClauseC(Clause c) {
            MultiMap<Integer, Integer> integerMultiMap = new MultiMap<Integer, Integer>();
            ValueToIndex<Literal> vti = new ValueToIndex<Literal>();
            HashSet<Integer> predicateSet = new HashSet<Integer>();
            int literalsArrayLength = 0;
            for (Literal l : c.literals()) {
                int intLiteral = vti.valueToIndex(l);
                integerMultiMap.put(SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(l.predicate()), intLiteral);
                literalsArrayLength += 3 + l.arity();
                predicateSet.add(SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(l.predicate()));
            }
            this.predicates = IntegerSet.createIntegerSet(predicateSet);
            this.literals = new int[literalsArrayLength];
            HashMap<Literal, Integer> intLitMap = new HashMap<Literal, Integer>();
            HashMap<Integer, Literal> litIntMap = new HashMap<Integer, Literal>();
            int index = 0;
            int literalIndex = 0;
            for (Literal l : c.literals()) {
                this.literals[index] = SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(l.predicate());
                this.literals[index + 1] = l.arity();
                this.literals[index + 2] = literalIndex;
                intLitMap.put(l, index);
                litIntMap.put(index, l);
                index += 3;
                for (int i = 0; i < l.arity(); ++i) {
                    this.literals[index + i] = this.variablesToIntegers.valueToIndex(l.get(i));
                }
                index += l.arity();
                ++literalIndex;
            }
            this.containedIn = new IntegerSet[this.variablesToIntegers.size()];
            this.occurences = new int[this.variablesToIntegers.size()];
            MultiMap containedInBag = new MultiMap();
            for (Literal literal : c.literals()) {
                for (int i = 0; i < literal.arity(); ++i) {
                    containedInBag.put(this.variablesToIntegers.valueToIndex(literal.get(i)), intLitMap.get(literal));
                    int n = this.variablesToIntegers.valueToIndex(literal.get(i));
                    this.occurences[n] = this.occurences[n] + 1;
                }
            }
            for (Map.Entry entry : containedInBag.entrySet()) {
                int term = (Integer)entry.getKey();
                this.containedIn[term] = IntegerSet.createIntegerSet((Set)entry.getValue());
            }
            this.neighbours = new IntegerSet[this.containedIn.length];
            for (int i = 0; i < this.containedIn.length; ++i) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (int literalsIndex : this.containedIn[i].values()) {
                    for (int j = literalsIndex + 3; j < literalsIndex + 3 + this.literals[literalsIndex + 1]; ++j) {
                        if (this.literals[j] == i) continue;
                        hashSet.add(this.literals[j]);
                    }
                }
                this.neighbours[i] = IntegerSet.createIntegerSet(hashSet);
            }
            this.variableDomains = new IntegerSet[c.variables().size()];
            this.groundedValues = new int[c.variables().size()];
            Arrays.fill(this.groundedValues, -1);
        }

        @Override
        public boolean initialize(ClauseE e) {
            Arrays.fill(this.variableDomains, null);
            for (int i = 0; i < this.variableDomains.length; ++i) {
                for (int ciLit : this.containedIn[i].values()) {
                    for (int j = 0; j < this.literals[ciLit + 1]; ++j) {
                        if (this.literals[ciLit + j + 3] != i) continue;
                        this.variableDomains[i] = this.variableDomains[i] == null ? e.variableDomains.get(new Pair<Integer, Integer>(this.literals[ciLit], j)) : IntegerSet.intersection(e.variableDomains.get(new Pair<Integer, Integer>(this.literals[ciLit], j)), this.variableDomains[i]);
                    }
                }
                if (!this.variableDomains[i].isEmpty()) continue;
                return false;
            }
            long m2 = System.currentTimeMillis();
            Arrays.fill(this.groundedValues, -1);
            return true;
        }

        protected boolean ground(int variable, int value, ClauseE e) {
            this.groundedValues[variable] = value;
            for (int ciLit : this.containedIn[variable].values()) {
                if (e.checkLiteral(this.literals, this.groundedValues, ciLit)) continue;
                return false;
            }
            return true;
        }

        protected boolean groundFC(int variable, int value, ClauseE e) {
            if (!this.ground(variable, value, e)) {
                return false;
            }
            block0: for (int neighb : this.neighbours[variable].values()) {
                if (this.groundedValues[neighb] != -1 || this.containedIn[neighb].size() <= 1) continue;
                for (int val : this.variableDomains[neighb].values()) {
                    boolean succ = this.ground(neighb, val, e);
                    this.unground(neighb);
                    if (succ) continue block0;
                }
                return false;
            }
            return true;
        }

        private Set<Integer> revise(Set<Integer> domain1, int var1, Set<Integer> domain2, int var2, ClauseE e, int literal) {
            LinkedHashSet<Integer> filtered = new LinkedHashSet<Integer>();
            if (this.groundedValues[var1] == -1 && this.groundedValues[var2] == -1) {
                for (Integer d1 : domain1) {
                    this.groundedValues[var1] = d1;
                    for (Integer d2 : domain2) {
                        this.groundedValues[var2] = d2;
                        if (e.checkLiteral(this.literals, this.groundedValues, literal)) {
                            filtered.add(d1);
                            this.unground(var2);
                            break;
                        }
                        this.unground(var2);
                    }
                    this.unground(var1);
                }
            } else if (this.groundedValues[var1] > -1) {
                filtered.add(this.groundedValues[var1]);
            } else if (this.groundedValues[var1] == -1 && this.groundedValues[var2] > -1) {
                for (Integer d1 : domain1) {
                    this.groundedValues[var1] = d1;
                    if (e.checkLiteral(this.literals, this.groundedValues, literal)) {
                        filtered.add(d1);
                    }
                    this.unground(var1);
                }
            } else {
                return domain1;
            }
            return filtered;
        }

        protected void restoreDomains(IntegerSet[] oldDomains) {
            this.variableDomains = oldDomains;
        }

        protected IntegerSet[] oldDomains() {
            IntegerSet[] oldDoms = new IntegerSet[this.variableDomains.length];
            System.arraycopy(this.variableDomains, 0, oldDoms, 0, oldDoms.length);
            return oldDoms;
        }

        protected void unground(int variable) {
            this.groundedValues[variable] = -1;
        }

        public String toString() {
            return this.toClause().toString();
        }

        public Clause toOriginalClause() {
            ArrayList<Literal> lits = new ArrayList<Literal>();
            for (int i = 0; i < this.literals.length; i += this.literals[i + 1] + 3) {
                Literal l = new Literal((String)SubsumptionEngineJ2.this.predicatesToIntegers.indexToValue(this.literals[i]), this.literals[i + 1]);
                for (int j = 0; j < this.literals[i + 1]; ++j) {
                    l.set(this.variablesToIntegers.indexToValue(this.literals[i + 3 + j]), j);
                }
                lits.add(l);
            }
            return new Clause(lits);
        }

        public Clause toClause() {
            ArrayList<Literal> lits = new ArrayList<Literal>();
            for (int i = 0; i < this.literals.length; i += this.literals[i + 1] + 3) {
                Literal l = new Literal((String)SubsumptionEngineJ2.this.predicatesToIntegers.indexToValue(this.literals[i]), this.literals[i + 1]);
                for (int j = 0; j < this.literals[i + 1]; ++j) {
                    if (this.groundedValues[this.literals[i + 3 + j]] != -1) {
                        l.set((Term)Constant.construct(String.valueOf(this.groundedValues[this.literals[i + 3 + j]])), j);
                        continue;
                    }
                    l.set(this.variablesToIntegers.indexToValue(this.literals[i + 3 + j]), j);
                }
                lits.add(l);
            }
            return new Clause(lits);
        }

        @Override
        public IntegerSet predicates() {
            return this.predicates;
        }

        public Pair<Term[], Term[]> getVariableAssignment(ClauseE example) {
            Term[] template = new Term[this.groundedValues.length];
            Term[] assignment = new Term[this.groundedValues.length];
            for (int i = 0; i < template.length; ++i) {
                template[i] = this.variablesToIntegers.indexToValue(i);
                assignment[i] = example.termsToIntegers.indexToValue(this.groundedValues[i]);
            }
            return new Pair<Term[], Term[]>(template, assignment);
        }
    }

    public class DecomposedClauseC
    implements ClauseStructure {
        protected ClauseC clauseC;
        private IntegerSet predicates;
        protected List<Pair<Literal, Literal>> joins = new ArrayList<Pair<Literal, Literal>>();
        private MultiMap<Integer, Pair<int[], HighArityLiterals>> specialLiterals = new MultiMap();
        private Set<Term> termsInCyclicCore;
        private Set<Literal> connectingLiterals;

        public DecomposedClauseC(Clause c) {
            HashSet<Integer> preds = new HashSet<Integer>();
            for (String str : c.predicates()) {
                preds.add(SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(str));
            }
            this.predicates = IntegerSet.createIntegerSet(preds);
            Pair<Clause, List<Pair<Literal, Literal>>> pair = SubsumptionUtils.gyoDecomposition(c);
            this.clauseC = new ClauseC((Clause)pair.r);
            this.termsInCyclicCore = Sugar.setFromCollections(((Clause)pair.r).terms());
            this.joins.addAll((Collection)pair.s);
            this.connectingLiterals = new HashSet<Literal>();
            HashSet<Object> literalsInAcyclicComponents = new HashSet<Object>();
            for (Pair pair2 : (List)pair.s) {
                literalsInAcyclicComponents.add(pair2.r);
                if (pair2.s == null) continue;
                literalsInAcyclicComponents.add(pair2.s);
            }
            block2: for (Literal literal : literalsInAcyclicComponents) {
                for (int i = 0; i < literal.arity(); ++i) {
                    if (!this.termsInCyclicCore.contains(literal.get(i))) continue;
                    this.connectingLiterals.add(literal);
                    continue block2;
                }
            }
            System.out.println("joins: " + this.joins);
        }

        public ClauseC cyclicPart() {
            return this.clauseC;
        }

        @Override
        public boolean initialize(ClauseE example) {
            this.specialLiterals.clear();
            if (!this.clauseC.initialize(example)) {
                return false;
            }
            long m1 = System.currentTimeMillis();
            Map<Literal, IntegerSet> domains = this.acyclicArcConsistency(this.joins, example);
            long m2 = System.currentTimeMillis();
            if (domains == null) {
                return false;
            }
            for (Literal cutLiteral : this.connectingLiterals) {
                int j;
                int i;
                List commonTerms = Sugar.listFromCollections(Sugar.intersection(cutLiteral.terms(), this.termsInCyclicCore));
                int newArity = commonTerms.size();
                int predicate = SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(cutLiteral.predicate());
                int[] domain = new int[domains.get(cutLiteral).size() * (newArity + 2)];
                int[] values = domains.get(cutLiteral).values();
                int[] lookup = new int[commonTerms.size()];
                block1: for (i = 0; i < commonTerms.size(); ++i) {
                    Term t = (Term)commonTerms.get(i);
                    for (j = 0; j < cutLiteral.arity(); ++j) {
                        if (t != cutLiteral.get(j)) continue;
                        lookup[i] = j;
                        continue block1;
                    }
                }
                for (i = 0; i < values.length; ++i) {
                    int val = values[i];
                    domain[i * (newArity + 2)] = predicate;
                    domain[i * (newArity + 2) + 1] = newArity;
                    for (j = 0; j < commonTerms.size(); ++j) {
                        domain[i * (newArity + 2) + 2 + j] = example.literals[val + 2 + lookup[j]];
                    }
                }
                HighArityLiterals hal = new HighArityLiterals(domain, -1);
                int[] specialLiteral = new int[cutLiteral.arity() + 3];
                specialLiteral[0] = SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(cutLiteral.predicate());
                specialLiteral[1] = newArity;
                specialLiteral[2] = -1;
                Pair<int[], HighArityLiterals> pair = new Pair<int[], HighArityLiterals>(specialLiteral, hal);
                for (int i2 = 0; i2 < newArity; ++i2) {
                    Term t = (Term)commonTerms.get(i2);
                    specialLiteral[i2 + 3] = this.clauseC.variablesToIntegers.valueToIndex(t);
                    this.specialLiterals.put(this.clauseC.variablesToIntegers.valueToIndex(t), pair);
                }
            }
            long m3 = System.currentTimeMillis();
            return true;
        }

        public boolean ground(int variable, int value, ClauseE e) {
            if (!this.clauseC.ground(variable, value, e)) {
                return false;
            }
            if (this.specialLiterals.size() > 0 && this.specialLiterals.containsKey(variable)) {
                for (Pair<int[], HighArityLiterals> pair : this.specialLiterals.get(variable)) {
                    HighArityLiterals hal = (HighArityLiterals)pair.s;
                    int[] specialLiteral = (int[])pair.r;
                    if (hal.match(specialLiteral, this.clauseC.groundedValues, 0)) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean groundFC(int variable, int value, ClauseE e) {
            if (!this.ground(variable, value, e)) {
                return false;
            }
            block0: for (int neighb : this.clauseC.neighbours[variable].values()) {
                if (this.clauseC.groundedValues[neighb] != -1 || this.clauseC.containedIn[neighb].size() <= 1) continue;
                for (int val : this.clauseC.variableDomains[neighb].values()) {
                    boolean succ = this.ground(neighb, val, e);
                    this.clauseC.unground(neighb);
                    if (succ) continue block0;
                }
                return false;
            }
            return true;
        }

        private Map<Literal, IntegerSet> acyclicArcConsistency(List<Pair<Literal, Literal>> joinTree, ClauseE example) {
            Literal child;
            int i;
            Object domain;
            HashMap<Literal, IntegerSet> domains = new HashMap<Literal, IntegerSet>();
            LinkedHashSet<Object> literals = new LinkedHashSet<Object>();
            for (Pair<Literal, Literal> pair : joinTree) {
                literals.add(pair.r);
                if (pair.s == null) continue;
                literals.add(pair.s);
            }
            for (Literal literal : literals) {
                IntegerSet rawDomain = example.domainsByPredicates[SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(literal.predicate())];
                int domainIndex = 0;
                domain = new int[rawDomain.size()];
                block2: for (int eLit : rawDomain.values()) {
                    for (int i2 = 0; i2 < literal.arity(); ++i2) {
                        for (int j = 0; j < literal.arity(); ++j) {
                            if (i2 != j && literal.get(i2).equals(literal.get(j)) && example.literals[eLit + 2 + i2] != example.literals[eLit + 2 + j]) continue block2;
                        }
                    }
                    domain[domainIndex++] = eLit;
                }
                if (domainIndex == 0) {
                    return null;
                }
                domains.put(literal, IntegerSet.createIntegerSet(VectorUtils.copyArray((int[])domain, 0, domainIndex)));
            }
            for (i = 0; i < joinTree.size(); ++i) {
                Pair<Literal, Literal> pair = joinTree.get(i);
                child = (Literal)pair.r;
                Literal parent = (Literal)pair.s;
                if (parent == null) continue;
                domain = this.semijoin(parent, child, (IntegerSet)domains.get(parent), (IntegerSet)domains.get(child), example);
                if (((IntegerSet)domain).isEmpty()) {
                    return null;
                }
                domains.put(parent, (IntegerSet)domain);
            }
            for (i = joinTree.size() - 1; i >= 0; --i) {
                Pair<Literal, Literal> pair = joinTree.get(i);
                child = (Literal)pair.r;
                Literal parent = (Literal)pair.s;
                if (parent == null) continue;
                domain = this.semijoin(child, parent, (IntegerSet)domains.get(child), (IntegerSet)domains.get(parent), example);
                if (((IntegerSet)domain).isEmpty()) {
                    return null;
                }
                domains.put(child, (IntegerSet)domain);
            }
            return domains;
        }

        private IntegerSet semijoin(Literal literalToBeFiltered, Literal otherLiteral, IntegerSet toBeFiltered, IntegerSet other, ClauseE example) {
            List commonTerms = Sugar.listFromCollections(Sugar.intersection(literalToBeFiltered.terms(), otherLiteral.terms()));
            int[] termIndices1 = new int[commonTerms.size()];
            int[] termIndices2 = new int[commonTerms.size()];
            block0: for (int i = 0; i < commonTerms.size(); ++i) {
                int j;
                for (j = 0; j < literalToBeFiltered.arity(); ++j) {
                    if (!((Term)commonTerms.get(i)).equals(literalToBeFiltered.get(j))) continue;
                    termIndices1[i] = j;
                    break;
                }
                for (j = 0; j < otherLiteral.arity(); ++j) {
                    if (!((Term)commonTerms.get(i)).equals(otherLiteral.get(j))) continue;
                    termIndices2[i] = j;
                    continue block0;
                }
            }
            int retIndex = 0;
            int[] retVal = new int[toBeFiltered.size()];
            block3: for (int tbfLit : toBeFiltered.values()) {
                block4: for (int oLit : other.values()) {
                    for (int i = 0; i < termIndices1.length; ++i) {
                        if (example.literals[tbfLit + 2 + termIndices1[i]] != example.literals[oLit + 2 + termIndices2[i]]) continue block4;
                    }
                    retVal[retIndex++] = tbfLit;
                    continue block3;
                }
            }
            return IntegerSet.createIntegerSet(VectorUtils.copyArray(retVal, 0, retIndex));
        }

        @Override
        public IntegerSet predicates() {
            return this.predicates;
        }
    }

    public static interface ClauseStructure {
        public boolean initialize(ClauseE var1);

        public IntegerSet predicates();
    }
}

