/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.basic;

import ida.ilp.basic.Clause;
import ida.ilp.basic.Constant;
import ida.ilp.basic.Function;
import ida.ilp.basic.Literal;
import ida.ilp.basic.ParserUtils;
import ida.ilp.basic.PrologList;
import ida.ilp.basic.Term;
import ida.ilp.basic.Variable;
import ida.utils.Sugar;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LogicUtils {
    private LogicUtils() {
    }

    public static Variable freshVariable(Clause c) {
        return LogicUtils.freshVariable(c.variables());
    }

    public static Variable freshVariable(Set<Variable> variables) {
        int index = 0;
        Variable var = null;
        while (variables.contains(var = Variable.construct("V" + index++))) {
        }
        return var;
    }

    public static Clause clauseFromFunctionsList(PrologList pl) {
        HashSet<Literal> literals = new HashSet<Literal>();
        for (int i = 0; i < pl.countItems(); ++i) {
            Function f = (Function)pl.get(i);
            literals.add(f.toLiteral());
        }
        return new Clause(literals);
    }

    public static Clause substitute(Clause c, Term a, Term b) {
        return LogicUtils.substitute(c, new Term[]{a}, new Term[]{b});
    }

    public static Clause substitute(Clause c, Term[] a, Term[] b) {
        HashMap<Term, Term> substitution = new HashMap<Term, Term>();
        for (int i = 0; i < a.length; ++i) {
            substitution.put(a[i], b[i]);
        }
        return LogicUtils.substitute(c, substitution);
    }

    public static Clause substitute(Clause c, Map<Term, Term> substitution) {
        HashSet<Literal> literals = new HashSet<Literal>();
        for (Literal l : c.literals()) {
            Literal cl = l.copy();
            for (int j = 0; j < l.arity(); ++j) {
                if (!substitution.containsKey(l.get(j))) continue;
                cl.set(substitution.get(l.get(j)), j);
            }
            literals.add(cl);
        }
        c = new Clause(literals);
        return c;
    }

    public static Literal substitute(Literal l, Term[] source, Term[] image) {
        HashMap<Term, Term> substitution = new HashMap<Term, Term>();
        for (int i = 0; i < source.length; ++i) {
            substitution.put(source[i], image[i]);
        }
        return LogicUtils.substitute(l, substitution);
    }

    public static Literal substitute(Literal l, Map<Term, Term> substitution) {
        Literal newLiteral = new Literal(l.predicate(), l.arity());
        for (int i = 0; i < l.arity(); ++i) {
            newLiteral.set(substitution.get(l.get(i)), i);
        }
        return newLiteral;
    }

    public static Term unquote(Term term) {
        String name = term.name();
        if (name.length() > 0 && name.charAt(0) == '\'' && name.charAt(name.length() - 1) == '\'') {
            name = name.substring(1, name.length() - 1);
        }
        return (Term)ParserUtils.parseTerm((char[])name.toCharArray(), (int)0, (char)')', new HashMap<String, Variable>(), new HashMap<String, Constant>()).r;
    }

    public static String niceVariableName(int id) {
        if (id <= 25) {
            return String.valueOf((char)(65 + id));
        }
        return String.valueOf((char)(65 + id % 25)) + id / 25;
    }

    public static Clause variabilizeClause(Clause c) {
        LinkedHashSet<Literal> predicates = new LinkedHashSet<Literal>();
        for (Literal pred : c.literals()) {
            Literal newPred = new Literal(pred.predicate(), pred.arity());
            for (int i = 0; i < pred.arity(); ++i) {
                newPred.set((Term)Variable.construct(Sugar.firstCharacterToUpperCase(pred.get(i).name())), i);
            }
            predicates.add(newPred);
        }
        return new Clause(predicates);
    }

    public static Clause constantizeClause(Clause c) {
        LinkedHashSet<Literal> predicates = new LinkedHashSet<Literal>();
        for (Literal l : c.literals()) {
            Literal newPred = new Literal(l.predicate(), l.arity());
            for (int i = 0; i < l.arity(); ++i) {
                newPred.set((Term)Constant.construct(Sugar.firstCharacterToLowerCase(l.get(i).name())), i);
            }
            predicates.add(newPred);
        }
        return new Clause(predicates);
    }

    public static List<String> freshPredicateNames(Clause c, int count) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (int i = 0; i < Integer.MAX_VALUE && retVal.size() != count; ++i) {
            String pred = "pred_" + i;
            if (!c.getLiteralsByPredicate(pred).isEmpty()) continue;
            retVal.add("pred" + i);
        }
        return retVal;
    }

    public static boolean isGround(Clause c) {
        return c.variables().isEmpty();
    }

    public static Pair<Clause, Clause> standardizeApart(Clause a, Clause b) {
        Pair<Clause, Clause> retVal = new Pair<Clause, Clause>();
        int i = 0;
        for (Clause c : LogicUtils.standardizeApart(Sugar.list(a, b))) {
            if (i == 0) {
                retVal.r = c;
            } else {
                retVal.s = c;
            }
            ++i;
        }
        return retVal;
    }

    public static Collection<Clause> standardizeApart(Collection<Clause> clauses) {
        ArrayList<Clause> retVal = new ArrayList<Clause>();
        HashMap vars = new HashMap();
        HashSet<Variable> allVariables = new HashSet<Variable>();
        for (Clause c : clauses) {
            for (Variable v : c.variables()) {
                allVariables.add(v);
            }
        }
        int i = 0;
        for (Clause c : clauses) {
            HashSet<Literal> literals = new HashSet<Literal>();
            Pair<Variable, Integer> queryPair = new Pair<Variable, Integer>();
            for (Literal l : c.literals()) {
                Literal newLiteral = new Literal(l.predicate(), l.arity());
                for (int j = 0; j < l.arity(); ++j) {
                    if (l.get(j) instanceof Variable) {
                        queryPair.set((Variable)l.get(j), i);
                        Variable var = null;
                        var = (Variable)vars.get(queryPair);
                        if (var == null) {
                            Pair insertPair = new Pair(queryPair.r, queryPair.s);
                            var = LogicUtils.freshVariable(allVariables);
                            allVariables.add(var);
                            vars.put(insertPair, var);
                        }
                        newLiteral.set((Term)var, j);
                        continue;
                    }
                    newLiteral.set(l.get(j), j);
                }
                literals.add(newLiteral);
            }
            retVal.add(new Clause(literals));
            ++i;
        }
        return retVal;
    }
}

