/*
 * Decompiled with CFR 0.152.
 */
package model.inference.hc;

import data.aggregate.selection.SelectionWithFilters;
import data.catalog.Catalog;
import data.condition.FilterFeature;
import data.feature.AggregateFeature;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import model.ModelOptions;
import model.NodeSplit;
import model.criterion.cancel.CancelCriterion;
import model.inference.SplitFinder;
import model.inference.hc.AggregateBase;
import util.Couple;

public class OneRandomRestartHillClimbing {
    private ModelOptions opts;
    private Random rt;
    private int numIterationsWithoutImp;
    private double depthInit = 0.25;
    private HashMap<SimpleFeature, Double> depths;
    private double weight;
    private AggregateBase ab;
    private AggregateFeature aggregate;
    private ArrayList<SimpleFeature> allFeatures;
    private ArrayList<SimpleFeature> presentFeatures;
    private ArrayList<SimpleFeature> absentFeatures;
    ArrayList<NodeSplit> bestSplits;

    public OneRandomRestartHillClimbing(ModelOptions opt, Random gr, AggregateBase abb, ArrayList<SimpleFeature> feats, Instances insts, Catalog cat, ArrayList<CancelCriterion> cancels) {
        this.opts = opt;
        this.rt = gr;
        this.ab = abb;
        this.allFeatures = new ArrayList<SimpleFeature>(feats);
        this.presentFeatures = new ArrayList();
        this.absentFeatures = new ArrayList();
        this.bestSplits = new ArrayList();
        this.depths = new HashMap();
        this.numIterationsWithoutImp = 0;
        this.weight = 0.0;
        this.aggregate = new AggregateFeature(this.ab, new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList())), cat, true, this.allFeatures, this.rt);
        this.evaluateAggregate(this.aggregate, insts, cat, true, cancels);
        for (FilterFeature ff : this.aggregate.getObjectSelection().getSelections().get(0).getFilters()) {
            this.presentFeatures.add((SimpleFeature)ff.getFeature());
        }
        for (SimpleFeature sf : this.allFeatures) {
            boolean isPresent;
            if (sf.getTypeOut().getKind() == 1) {
                this.depths.put(sf, this.depthInit);
            }
            if (isPresent = this.presentFeatures.contains(sf)) continue;
            this.absentFeatures.add(sf);
        }
    }

    public boolean oneStep(Instances insts, Catalog cat, ArrayList<CancelCriterion> cancels) {
        AggregateFeature toTry;
        boolean improved = false;
        ArrayList<Value> ids = new ArrayList<Value>();
        for (Instance inst : insts) {
            ids.add(inst.getId());
        }
        AggregateFeature copyAgg = this.aggregate.clone();
        for (SimpleFeature sf : this.absentFeatures) {
            if (sf.getTypeOut().getKind() == 0) {
                int i = 0;
                while (i < (sf.getTypeOut().getValues().size() < 4 ? 1 : 5)) {
                    AggregateFeature toTry2 = copyAgg.clone();
                    toTry2.addCondition(cat, sf, new ArrayList<Value>(sf.getTypeOut().getValues()), this.rt);
                    boolean imp = this.evaluateAggregate(toTry2, insts, cat, true, cancels);
                    improved = improved || imp;
                    ++i;
                }
                continue;
            }
            if (sf.getTypeOut().getKind() != 1) continue;
            SelectionWithFilters swfCurrent = copyAgg.getObjectSelection().getSelections().get(0).clone();
            TreeSet possibleValues = new TreeSet(ids.stream().flatMap(v -> swfCurrent.select((Value)v, cat)).map(sid -> sf.result((Value)sid, cat)).filter(val -> val.getStringValue() != null).collect(Collectors.toSet()));
            int i = 0;
            while (i < 5) {
                toTry = copyAgg.clone();
                toTry.addCondition(cat, sf, new ArrayList<Value>(possibleValues), this.rt);
                boolean imp = this.evaluateAggregate(toTry, insts, cat, true, cancels);
                improved = improved || imp;
                ++i;
            }
        }
        boolean canDecrDepth = false;
        for (SimpleFeature sf : this.presentFeatures) {
            TreeSet<Value> possibleValues;
            if (sf.getTypeOut().getKind() == 0) {
                for (Value val2 : sf.getTypeOut().getValues()) {
                    toTry = copyAgg.clone();
                    toTry.applyMove(cat, ids, sf, val2);
                    boolean imp = this.evaluateAggregate(toTry, insts, cat, true, cancels);
                    boolean bl = improved = improved || imp;
                }
                continue;
            }
            if (sf.getTypeOut().getKind() != 1) continue;
            SelectionWithFilters swfClone = copyAgg.getObjectSelection().getSelections().get(0).clone();
            FilterFeature toRemove = null;
            for (FilterFeature ff : swfClone.getFilters()) {
                if (!ff.getFeature().equals(sf)) continue;
                toRemove = ff;
                break;
            }
            if (toRemove != null) {
                swfClone.getFilters().remove(toRemove);
            }
            if ((possibleValues = new TreeSet<Value>(ids.stream().flatMap(v -> swfClone.select((Value)v, cat)).map(sid -> sf.result((Value)sid, cat)).filter(val -> val.getStringValue() != null).collect(Collectors.toSet()))).isEmpty()) continue;
            int absDepth = (int)Math.ceil((double)possibleValues.size() * this.depths.get(sf));
            canDecrDepth = canDecrDepth || absDepth != 1;
            ArrayList<AggregateFeature> localNeighbors = copyAgg.neighbors(possibleValues, sf, absDepth);
            int count = 0;
            for (AggregateFeature toTry3 : localNeighbors) {
                boolean imp = this.evaluateAggregate(toTry3, insts, cat, count > 0, cancels);
                ++count;
                boolean bl = improved = improved || imp;
            }
        }
        this.presentFeatures.clear();
        this.absentFeatures.clear();
        for (FilterFeature ff : this.aggregate.getObjectSelection().getSelections().get(0).getFilters()) {
            this.presentFeatures.add((SimpleFeature)ff.getFeature());
        }
        for (SimpleFeature sf : this.allFeatures) {
            boolean isPresent = this.presentFeatures.contains(sf);
            if (isPresent) continue;
            this.absentFeatures.add(sf);
            this.depths.put(sf, this.depthInit);
        }
        boolean res = true;
        if (!improved) {
            boolean decrDepth = false;
            for (SimpleFeature sf : this.presentFeatures) {
                if (!canDecrDepth || sf.getTypeOut().getKind() != 1) continue;
                decrDepth = true;
                this.depths.put(sf, this.depths.get(sf) / 2.0);
            }
            if (!decrDepth) {
                res = false;
                ++this.numIterationsWithoutImp;
            }
        }
        return res;
    }

    protected boolean evaluateAggregate(AggregateFeature aggFeat, Instances insts, Catalog cat, boolean strict, ArrayList<CancelCriterion> cancels) {
        boolean res = false;
        if (aggFeat.getAggregateFunction().getKindOut() == 0) {
            HashMap<Value, Instances> decomposition = new HashMap<Value, Instances>();
            Instances mainNoValue = new Instances();
            insts.stream().map(inst -> new Couple<Instance, Value>((Instance)inst, aggFeat.result(inst.getId(), cat))).forEach(coup -> {
                Instance inst = (Instance)coup.getLeft();
                Value val = (Value)coup.getRight();
                if (val.getStringValue() == null) {
                    mainNoValue.add(inst);
                } else {
                    if (!decomposition.containsKey(val)) {
                        decomposition.put(val, new Instances());
                    }
                    ((Instances)decomposition.get(val)).add(inst);
                }
            });
            NodeSplit bs = null;
            if (this.opts.mode.equals("classification")) {
                bs = SplitFinder.inferNominalSplitOnNominalTarget(aggFeat, decomposition, mainNoValue, this.opts.complexity);
            } else if (this.opts.mode.equals("regression")) {
                bs = SplitFinder.inferNominalSplitOnNumericTarget(aggFeat, decomposition, mainNoValue, this.opts.complexity);
            }
            res = this.updateBestSplits(bs, strict, cancels);
            if (res) {
                this.aggregate = aggFeat.clone();
                if (bs.getScore() > this.weight) {
                    this.weight = bs.getScore();
                    this.numIterationsWithoutImp = -1;
                }
            }
        } else if (aggFeat.getAggregateFunction().getKindOut() == 1) {
            TreeMap<Value, Instances> groups = new TreeMap<Value, Instances>();
            Instances noValue = new Instances();
            insts.stream().map(inst -> new Couple<Instance, Value>((Instance)inst, aggFeat.result(inst.getId(), cat))).forEach(coup -> {
                Instance inst = (Instance)coup.getLeft();
                Value val = (Value)coup.getRight();
                if (val.getStringValue() == null) {
                    noValue.add(inst);
                } else {
                    if (!groups.containsKey(val)) {
                        groups.put(val, new Instances());
                    }
                    ((Instances)groups.get(val)).add(inst);
                }
            });
            NodeSplit bs = null;
            if (this.opts.mode.equals("classification")) {
                bs = SplitFinder.inferNumericSplitOnNominalTarget(aggFeat, groups, noValue, this.opts.complexity);
            } else if (this.opts.mode.equals("regression")) {
                bs = SplitFinder.inferNumericSplitOnNumericTarget(aggFeat, groups, noValue, this.opts.complexity);
            }
            res = this.updateBestSplits(bs, strict, cancels);
            if (res) {
                this.aggregate = aggFeat.clone();
                if (bs.getScore() > this.weight) {
                    this.weight = bs.getScore();
                    this.numIterationsWithoutImp = -1;
                }
            }
        }
        return res;
    }

    protected boolean updateBestSplits(NodeSplit ns, boolean strict, ArrayList<CancelCriterion> cancels) {
        boolean res = false;
        if (ns != null) {
            boolean cancelNow = false;
            for (CancelCriterion cancel : cancels) {
                boolean bl = cancelNow = cancelNow || cancel.cancelCriterion(ns);
            }
            if (!cancelNow) {
                double score = ns.getScore();
                if (this.bestSplits.isEmpty() || !this.bestSplits.isEmpty() && score >= this.bestSplits.get(0).getScore()) {
                    if (this.bestSplits.isEmpty() || !this.bestSplits.isEmpty() && (score > this.bestSplits.get(0).getScore() || !strict)) {
                        res = true;
                        this.bestSplits.clear();
                    }
                    this.bestSplits.add(ns);
                }
            }
        }
        return res;
    }

    public int getNumIterationsWithoutImp() {
        return this.numIterationsWithoutImp;
    }

    public double weight() {
        return this.weight;
    }

    public ArrayList<NodeSplit> getBestSplits() {
        return this.bestSplits;
    }

    public AggregateBase getAggregateBase() {
        return this.ab;
    }

    public void reInit(Instances insts, Catalog cat, ArrayList<CancelCriterion> cancels) {
        this.bestSplits.clear();
        this.depths.clear();
        this.numIterationsWithoutImp = 0;
        this.aggregate = new AggregateFeature(this.ab, new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList())), cat, true, this.allFeatures, this.rt);
        this.evaluateAggregate(this.aggregate, insts, cat, true, cancels);
        this.presentFeatures.clear();
        this.absentFeatures.clear();
        for (FilterFeature ff : this.aggregate.getObjectSelection().getSelections().get(0).getFilters()) {
            this.presentFeatures.add((SimpleFeature)ff.getFeature());
        }
        for (SimpleFeature sf : this.allFeatures) {
            boolean isPresent;
            if (sf.getTypeOut().getKind() == 1) {
                this.depths.put(sf, this.depthInit);
            }
            if (isPresent = this.presentFeatures.contains(sf)) continue;
            this.absentFeatures.add(sf);
        }
    }
}

