/*
 * Decompiled with CFR 0.152.
 */
package data.value;

public class Value
implements Cloneable,
Comparable<Value> {
    protected String str;
    protected Double num;
    protected Double weight;

    public Value() {
        this.str = null;
        this.weight = 1.0;
    }

    public Value(String v) {
        this.num = null;
        this.str = v;
        this.weight = 1.0;
    }

    public Value(Double d) {
        this.num = d;
        this.str = d.toString();
        this.weight = 1.0;
    }

    public Value(String v, Double w) {
        this.num = null;
        this.str = v;
        this.weight = w;
    }

    public Value(Double d, Double w) {
        this.num = d;
        this.str = d.toString();
        this.weight = w;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            Value val = (Value)obj;
            if (this.num != null && val.getNumericValue() != null) {
                return this.num.equals(val.getNumericValue());
            }
            return this.str.equals(val.getStringValue());
        }
        return this == obj;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    @Override
    public int compareTo(Value val) {
        if (this.num != null && val.getNumericValue() != null) {
            double expected = this.num;
            double actual = val.getNumericValue();
            long expectedBits = Double.doubleToLongBits(expected) < 0L ? Long.MIN_VALUE - Double.doubleToLongBits(expected) : Double.doubleToLongBits(expected);
            long actualBits = Double.doubleToLongBits(actual) < 0L ? Long.MIN_VALUE - Double.doubleToLongBits(actual) : Double.doubleToLongBits(actual);
            long difference = Math.abs(actualBits - expectedBits);
            if (!Double.isNaN(expected) && !Double.isNaN(actual) && difference <= 5L) {
                return 0;
            }
            return this.num.compareTo(val.getNumericValue());
        }
        return this.str.compareTo(val.getStringValue());
    }

    public String getStringValue() {
        return this.str;
    }

    public Double getNumericValue() {
        return this.num;
    }

    public Double getWeight() {
        return this.weight;
    }

    public Value clone() {
        return new Value(this.str);
    }

    public String toString() {
        return this.str == null ? "null" : this.str.toString();
    }
}

