BUYER_USER_TYPE = "B"
SELLER_USER_TYPE = "S"
FINANCIER_USER_TYPE = "F"
ALL_USER_TYPE = "A"

USER_TYPES = (
    (BUYER_USER_TYPE, "Buyer"),
    (SELLER_USER_TYPE, "Seller"),
    (FINANCIER_USER_TYPE, "Financier"),
    (ALL_USER_TYPE, "All"),
)

USER_TYPES_MAP = {
    BUYER_USER_TYPE: "Buyer",
    SELLER_USER_TYPE: "Seller",
    FINANCIER_USER_TYPE: "Financier",
    ALL_USER_TYPE: "All",
}

DRAFT_INVOICE_STATUS = "D"
NEW_INVOICE_STATUS = "N"
BUYER_VALIDATED_INVOICE_STATUS = "BV"
VALIDATED_INVOICE_STATUS = "V"
COMPLETED_INVOICE_STATUS = "C"
CLOSED_INVOICE_STATUS = "X"
FUNDED_INVOICE_STATUS = "F"
REJECTED_INVOICE_STATUS = "R"
WITHDRAWN_INVOICE_STATUS = "W"
AMEND_INVOICE_STATUS = "A"
AWAITING_PAYMENT_INVOICE_STATUS = "AP"
OVERDUE_INVOICE_STATUS = "O"

INVOICE_STATUSES = (
    (DRAFT_INVOICE_STATUS, "Draft"),
    (NEW_INVOICE_STATUS, "New"),
    (BUYER_VALIDATED_INVOICE_STATUS, "Validated by Buyer"),
    (VALIDATED_INVOICE_STATUS, "Validated"),
    (COMPLETED_INVOICE_STATUS, "Repaid"),
    (CLOSED_INVOICE_STATUS, "Closed"),
    (FUNDED_INVOICE_STATUS, "Funded"),
    (REJECTED_INVOICE_STATUS, "Rejected"),
    (WITHDRAWN_INVOICE_STATUS, "Withdrawn"),
    (AMEND_INVOICE_STATUS, "For Amendment"),
    (AWAITING_PAYMENT_INVOICE_STATUS, "Awaiting Payment"),
    (OVERDUE_INVOICE_STATUS, "Overdue"),
)

FAILED_TXN_STATUS = "F"
SUCCESS_TXN_STATUS = "S"
PENDING_TXN_STATUS = "P"
REVERSED_TXN_STATUS = "R"

TXN_STATUSES = (
    (FAILED_TXN_STATUS, "Failed"),
    (SUCCESS_TXN_STATUS, "Successful"),
    (PENDING_TXN_STATUS, "Pending"),
    (REVERSED_TXN_STATUS, "Reversed"),
)

FIXED_LIQUIFY_FEE = "F"
PERCENTAGE_LIQUIFY_FEE = "P"

LIQUIFY_FEE_TYPES = (
    (FIXED_LIQUIFY_FEE, "Fixed"),
    (FIXED_LIQUIFY_FEE, "Percentage"),
)

PENDING_CONTRACT_STATUS = "P"
ACCEPTED_CONTRACT_STATUS = "A"
MODIFY_CONTRACT_STATUS = "M"
VERIFIED_CONTRACT_STATUS = "V"
REJECTED_CONTRACT_STATUS = "R"
CONTRACT_STATUSES = (
    (PENDING_CONTRACT_STATUS, "Pending"),
    (ACCEPTED_CONTRACT_STATUS, "Accepted"),
    (MODIFY_CONTRACT_STATUS, "Modify"),
    (VERIFIED_CONTRACT_STATUS, "Verified"),
    (REJECTED_CONTRACT_STATUS, "Rejected"),
)
PHONE_CONTRACT_ACCEPTANCE = "P"
MAIL_CONTRACT_ACCEPTANCE = "M"
DASHBOARD_CONTRACT_ACCEPTANCE = "D"
CONTRACT_ACCEPTANCE_CHANNELS = (
    (PHONE_CONTRACT_ACCEPTANCE, "Phone"),
    (MAIL_CONTRACT_ACCEPTANCE, "Mail"),
    (DASHBOARD_CONTRACT_ACCEPTANCE, "Dashboard"),
)

NEW_INVOICE_NOTIF_TYPE = 'NI'
INVOICE_WITHDRAWN_NOTIF_TYPE = 'IW'
INVOICE_REPAID_NOTIF_TYPE = 'IR'
INVOICE_FUNDED_NOTIF_TYPE = 'IF'
INVOICE_AWAITING_PAYMENT_NOTIF_TYPE = 'IA'
INVOICE_VALIDATED_NOTIF_TYPE = 'IV'
INVOICE_OVERDUE_NOTIF_TYPE = 'IO'
INVOICE_REJECTED_NOTIF_TYPE = 'IX'
AMEND_INVOICE_NOTIF_TYPE = 'MI'
CONTRACT_CONFIRMED_NOTIF_TYPE = 'CC'
MODIFY_CONTRACT_NOTIF_TYPE = 'CM'
NEW_CONTRACT_NOTIF_TYPE = 'NC'
NOTIFICATION_TYPES = (
    (NEW_INVOICE_NOTIF_TYPE, 'New Invoice'),
    (INVOICE_WITHDRAWN_NOTIF_TYPE, 'Invoice Withdrawn'),
    (INVOICE_REPAID_NOTIF_TYPE, 'Invoice Repaid'),
    (INVOICE_FUNDED_NOTIF_TYPE, 'Invoice Funded'),
    (INVOICE_OVERDUE_NOTIF_TYPE, 'Invoice Overdue'),
    (AMEND_INVOICE_NOTIF_TYPE, 'Amend Invoice'),
    (INVOICE_AWAITING_PAYMENT_NOTIF_TYPE, 'Invoice Awaiting Payment'),
    (INVOICE_VALIDATED_NOTIF_TYPE, 'Invoice Validated'),
    (CONTRACT_CONFIRMED_NOTIF_TYPE, 'Contract Confirmed'),
    (MODIFY_CONTRACT_NOTIF_TYPE, 'Modify Contract'),
    (NEW_CONTRACT_NOTIF_TYPE, 'New Contract'),
)

REJECTED_PROFILE_STATUS = "R"
APPROVED_PROFILE_STATUS = "A"
PENDING_PROFILE_STATUS = "P"

PROFILE_REQUEST_STATUSES = (
    (REJECTED_PROFILE_STATUS, "Rejected"),
    (APPROVED_PROFILE_STATUS, "Approved"),
    (PENDING_PROFILE_STATUS, "Pending"),
)
