# Generated by Django 4.2.4 on 2023-08-17 13:04

import core_models.app.models.company
from django.conf import settings
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('app', '0023_alter_company_unique_together_country_oecd_and_more'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='profileapplication',
            name='export_countries',
        ),
        migrations.RemoveField(
            model_name='profileapplication',
            name='largest_buyers',
        ),
        migrations.AddField(
            model_name='profileapplication',
            name='non_oecd_buyers',
            field=django.contrib.postgres.fields.ArrayField(base_field=django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), size=2), blank=True, null=True, size=None),
        ),
        migrations.AddField(
            model_name='profileapplication',
            name='oecd_buyers',
            field=django.contrib.postgres.fields.ArrayField(base_field=django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), size=2), default=[], size=None),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='user',
            name='change_password',
            field=models.BooleanField(default=False),
        ),
        migrations.CreateModel(
            name='ContractInformation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('deleted', models.BooleanField(default=False)),
                ('deleted_by_id', models.UUIDField(blank=True, editable=False, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('length_of_relationship', models.CharField(max_length=100)),
                ('type_of_product', models.CharField(max_length=100)),
                ('total_volume_of_invoices', models.IntegerField(default=0)),
                ('total_value_of_invoices', models.DecimalField(decimal_places=2, default=0, max_digits=30)),
                ('invoices_amount_paid', models.DecimalField(decimal_places=2, default=0, max_digits=30)),
                ('total_deductions', models.DecimalField(decimal_places=2, default=0, max_digits=30)),
                ('contract', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='information', to='app.contract')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CompanyIncorporation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('deleted', models.BooleanField(default=False)),
                ('deleted_by_id', models.UUIDField(blank=True, editable=False, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('website', models.URLField()),
                ('external_auditors', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), size=None)),
                ('directors', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), size=None)),
                ('team_chart', models.FileField(upload_to=core_models.app.models.company.team_chart_upload_to)),
                ('parent_company', models.CharField(help_text='Full Legal Corporate Name of Parent Company', max_length=255)),
                ('trading_entity', models.CharField(help_text='Full legal Corporate Name of Trading Entity (if different)', max_length=255)),
                ('company', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='incorporation_information', to='app.company')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CommercialInformation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('deleted', models.BooleanField(default=False)),
                ('deleted_by_id', models.UUIDField(blank=True, editable=False, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('annual_export_vs_domestic', models.FloatField(help_text='What percentage of the business’s annual sales/turnover is from exports versus domestic sales?')),
                ('monthly_exports', models.DecimalField(decimal_places=2, help_text='What is the value of your exports monthly?', max_digits=30)),
                ('financing_payment_terms', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=100), blank=True, help_text='What are the main types of financing your company uses (e.g unsecured loans..etc) and what are the payment terms?', null=True, size=None)),
                ('finance_providers', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=100), blank=True, help_text='Who are your current predominant finance providers?', null=True, size=None)),
                ('avg_interest_rate', models.FloatField(default=0, help_text='What is the current avg. interest rate that your company pays for short-term debt (how much are you currently paying in interest)?')),
                ('monthly_finance_needed', models.DecimalField(decimal_places=2, default=0, help_text='How much financing do you need on a monthly basis?', max_digits=30)),
                ('accounting_software', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=100), help_text='Does your company use any accounting software? If so, what is the name of the software and provider?', size=None)),
                ('receivables_and_payables', models.FileField(help_text='Monthly Receivables & Payables Aging book for last 12 months', upload_to=core_models.app.models.company.receivables_and_payables_upload_to)),
                ('sales_ledger', models.FileField(help_text='Current Open Sales Ledger', upload_to=core_models.app.models.company.receivables_and_payables_upload_to)),
                ('credit_notes', models.FileField(help_text='Credit Notes/Discounts/Rebates Register', upload_to=core_models.app.models.company.receivables_and_payables_upload_to)),
                ('company', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='commercial_information', to='app.company')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('major_currency', models.ForeignKey(help_text='In what currency is the majority of your sales denominated in?', on_delete=django.db.models.deletion.DO_NOTHING, to='app.currency')),
            ],
            options={
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
    ]
