# Generated by Django 4.2.1 on 2023-07-04 13:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_quill.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('app', '0015_company_city'),
    ]

    operations = [
        migrations.CreateModel(
            name='Sector',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('deleted', models.BooleanField(default=False)),
                ('deleted_by_id', models.UUIDField(blank=True, editable=False, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='company',
            name='industry',
        ),
        migrations.AddField(
            model_name='configuration',
            name='rpa',
            field=django_quill.fields.QuillField(blank=True, help_text='Use {seller_first_name}, {seller_last_name}, {seller_company_name}, {seller_address}, {buyer_first_name}, {buyer_last_name}, {buyer_company_name}, {buyer_address}, {financier_first_name}, {financier_last_name}, {financier_company_name}, {financier_address}, {current_day}, {current_month}, {current_year}, {discount_percent}, {discount_amount}, {invoice_amount}, ', null=True),
        ),
        migrations.CreateModel(
            name='UserConfiguration',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('deleted', models.BooleanField(default=False)),
                ('deleted_by_id', models.UUIDField(blank=True, editable=False, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('maturity', models.IntegerField(default=0)),
                ('discount_range', models.JSONField(default=[1, 50])),
                ('countries', models.ManyToManyField(blank=True, null=True, to='app.country')),
                ('sectors', models.ManyToManyField(blank=True, null=True, to='app.sector')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='config', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='company',
            name='sector',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.sector'),
        ),
    ]
