# Generated by Django 4.2 on 2023-04-28 12:13

import core_models.app.models.company
import core_models.app.models.contract
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('cities_light', '0011_alter_city_country_alter_city_region_and_more'),
        ('app', '0007_remove_invoice_paid_invoice_status_invoice_subtotal_and_more'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='contract',
            options={},
        ),
        migrations.AddField(
            model_name='contract',
            name='status',
            field=models.CharField(choices=[('P', 'Pending'), ('A', 'Accepted'), ('M', 'Modify'), ('V', 'Verified')], default='P', max_length=1),
        ),
        migrations.AddField(
            model_name='invoice',
            name='base_rate',
            field=models.FloatField(default=0),
        ),
        migrations.AddField(
            model_name='invoice',
            name='buyer_amount',
            field=models.DecimalField(decimal_places=2, default=0, max_digits=30),
        ),
        migrations.AddField(
            model_name='invoice',
            name='buyer_risk_percentage',
            field=models.FloatField(default=0),
        ),
        migrations.AddField(
            model_name='invoice',
            name='discount',
            field=models.DecimalField(decimal_places=2, default=1, max_digits=30),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='invoice',
            name='discount_rate',
            field=models.FloatField(default=0, editable=False),
        ),
        migrations.AddField(
            model_name='invoice',
            name='draft',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='invoice',
            name='financier_amount',
            field=models.DecimalField(decimal_places=2, default=0, max_digits=30),
        ),
        migrations.AddField(
            model_name='invoice',
            name='liquify_fee',
            field=models.DecimalField(decimal_places=2, default=0, max_digits=30),
        ),
        migrations.AddField(
            model_name='invoice',
            name='seller_risk_percentage',
            field=models.FloatField(default=0),
        ),
        migrations.AlterField(
            model_name='company',
            name='address_line1',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='company',
            name='name',
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name='company',
            name='postcode',
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name='company',
            name='registration_number',
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name='contract',
            name='buyer_accepted_via',
            field=models.CharField(blank=True, choices=[('P', 'Phone'), ('M', 'Mail'), ('D', 'Dashboard')], max_length=1, null=True),
        ),
        migrations.AlterField(
            model_name='contract',
            name='document',
            field=models.FileField(default='', upload_to=core_models.app.models.contract.contract_upload_to),
            preserve_default=False,
        ),
        migrations.AlterUniqueTogether(
            name='company',
            unique_together={('registration_number', 'country')},
        ),
        migrations.AlterUniqueTogether(
            name='contract',
            unique_together={('seller', 'buyer')},
        ),
        migrations.CreateModel(
            name='ContractStatusLog',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('deleted', models.BooleanField(default=False)),
                ('deleted_by_id', models.UUIDField(blank=True, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('P', 'Pending'), ('A', 'Accepted'), ('M', 'Modify'), ('V', 'Verified')], max_length=1)),
                ('reason', models.TextField(blank=True, null=True)),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.contract')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractDocument',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('deleted', models.BooleanField(default=False)),
                ('deleted_by_id', models.UUIDField(blank=True, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('file', models.FileField(upload_to=core_models.app.models.contract.doc_upload_to)),
                ('name', models.CharField(max_length=255)),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.contract')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Contract Document',
                'verbose_name_plural': 'Contract Documents',
            },
        ),
        migrations.CreateModel(
            name='Configuration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('liquify_fee', models.DecimalField(decimal_places=2, max_digits=15)),
                ('liquify_fee_type', models.CharField(choices=[('F', 'Fixed'), ('F', 'Percentage')], max_length=1)),
                ('last_updated_on', models.DateTimeField(auto_now=True)),
                ('last_updated_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='CompanyDocument',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('deleted', models.BooleanField(default=False)),
                ('deleted_by_id', models.UUIDField(blank=True, null=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('file', models.FileField(upload_to=core_models.app.models.company.doc_upload_to)),
                ('name', models.CharField(max_length=255)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.company')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Company Document',
                'verbose_name_plural': 'Company Documents',
            },
        ),
        migrations.RemoveField(
            model_name='contract',
            name='accepted',
        ),
    ]
