# -*- coding: utf-8 -*-

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from .services.auto_suggestion_service import AutoSuggestionServiceClient
from .services.question_service import QuestionServiceClient
from .types.annotated_string import AnnotatedString
from .types.auto_suggestion_service import SuggestQueriesRequest
from .types.auto_suggestion_service import SuggestQueriesResponse
from .types.auto_suggestion_service import Suggestion
from .types.auto_suggestion_service import SuggestionInfo
from .types.auto_suggestion_service import SuggestionType
from .types.question import BigQueryJob
from .types.question import DataQuery
from .types.question import DebugFlags
from .types.question import ExecutionInfo
from .types.question import HumanReadable
from .types.question import InterpretEntity
from .types.question import InterpretError
from .types.question import Interpretation
from .types.question import InterpretationStructure
from .types.question import Question
from .types.question_service import CreateQuestionRequest
from .types.question_service import ExecuteQuestionRequest
from .types.question_service import GetQuestionRequest
from .types.question_service import GetUserFeedbackRequest
from .types.question_service import UpdateUserFeedbackRequest
from .types.user_feedback import UserFeedback


__all__ = (
    "AnnotatedString",
    "AutoSuggestionServiceClient",
    "BigQueryJob",
    "CreateQuestionRequest",
    "DataQuery",
    "DebugFlags",
    "ExecuteQuestionRequest",
    "ExecutionInfo",
    "GetQuestionRequest",
    "GetUserFeedbackRequest",
    "HumanReadable",
    "InterpretEntity",
    "InterpretError",
    "Interpretation",
    "InterpretationStructure",
    "Question",
    "SuggestQueriesRequest",
    "SuggestQueriesResponse",
    "Suggestion",
    "SuggestionInfo",
    "SuggestionType",
    "UpdateUserFeedbackRequest",
    "UserFeedback",
    "QuestionServiceClient",
)
