"""MaxwellBloch

MaxwellBloch is a Python package for solving the coupled Maxwell-Bloch equations
describing the nonlinear propagation of near-resonant light through thermal
atomic vapours.
"""

import os 
import textwrap 
from setuptools import setup, find_packages 
import subprocess

DESCRIPTION = "A Python package for solving the Maxwell-Bloch equations."

LONG_DESCRIPTION = ("MaxwellBloch is a Python package for solving the coupled "
    "Maxwell-Bloch equations describing the nonlinear propagation of "
    "near-resonant light through thermal atomic vapours.")

def git_short_hash():
    """ Returns the short hash of the latest git commit as a string. """

    git_str = subprocess.check_output(['git', 'log', '-1',
        '--format=%h']).decode('UTF-8').strip()
    return git_str

version = "0.6.0"
# if "TRAVIS_TAG" in os.environ:
#     # Versions are of the pattern 'vX.Y.X'
#     version = os.environ.get("TRAVIS_TAG", "")[1:]
# elif "TRAVIS_COMMIT" in os.environ:
#     version = os.environ.get("TRAVIS_COMMIT", "")[:8]
# else:
#     version = git_short_hash()

def write_version_module(version_path='maxwellbloch/version.py'):
    """ Write a version module with the current version."""

    # Remove if already exists
    if os.path.exists(version_path):
        os.remove(version_path)

    version_str = textwrap.dedent("""\
        # This file is generated by setup.py
        VERSION = '{!s}'
        """.format(version))

    f = open(version_path, 'w')
    try:
        f.write(version_str)
    finally:
        f.close()

write_version_module()

setup(name='MaxwellBloch',
      version=version,
      description=DESCRIPTION,
      long_description=LONG_DESCRIPTION,
      url='http://github.com/tpogden/maxwellbloch',
      author='Thomas P Ogden',
      author_email='t@ogden.eu',
      license='MIT',
      packages=find_packages(),
      package_data={'maxwellbloch.tests': ['json/*.json']},
      install_requires=['qutip'],
      scripts=['bin/make-mp4-fixed-frame.py',
               'bin/make-mp4-fixed-frame-2-fields.py',
               'bin/make-gif-ffmpeg.sh'],
      zip_safe=False)
