# Copyright (c) 2018-2020, Vanessa Sochat All rights reserved.
# See the LICENSE in the main repository at:
#    https://www.github.com/openbases/openbases-python

# Badges (and color lookup)
# The color needs to follow a # that is converted to %23

CUSTOM_COLORS = {"submission":"green",
                 "spec": "%23660000", # matches schema.org
                 "experiment": "%23eaab1b",
                 "builder": "orange",
                 "openbases": "%232196f3",
                 "testing": "%23783589",
                 "data": "red",
                 "library": "%23ff69b4",
                 "resource": "blue",
                 "paper": "%231ab170",
                 "other": "lightgrey" }

BADGE_STYLES = ["plastic",
                "flat",
                "flat-square",
                "for-the-badge",
                "popout",
                "popout-square",
                "social"]


BADGE_LABELS = list(CUSTOM_COLORS.keys())

# https://img.shields.io/badge/<SUBJECT>-<STATUS>-<COLOR>.sv

BADGE_BASE = "https://img.shields.io/badge/%s-%s-%s.svg"
BADGE_COLORS = ['black',
                'dimgray',
                'dimgrey',
                'gray',
                'grey',
                'darkgray',
                'darkgrey',
                'silver',
                'lightgray',
                'lightgrey',
                'gainsboro',
                'whitesmoke',
                'white',
                'snow',
                'rosybrown',
                'lightcoral',
                'indianred',
                'brown',
                'firebrick',
                'maroon',
                'darkred',
                'red',
                'mistyrose',
                'salmon',
                'tomato',
                'darksalmon',
                'coral',
                'orangered',
                'lightsalmon',
                'sienna',
                'seashell',
                'chocolate',
                'saddlebrown',
                'sandybrown',
                'peachpuff',
                'peru',
                'linen',
                'bisque',
                'darkorange',
                'burlywood',
                'antiquewhite',
                'tan',
                'navajowhite',
                'blanchedalmond',
                'papayawhip',
                'moccasin',
                'orange',
                'wheat',
                'oldlace',
                'floralwhite',
                'darkgoldenrod',
                'goldenrod',
                'cornsilk',
                'gold',
                'lemonchiffon',
                'khaki',
                'palegoldenrod',
                'darkkhaki',
                'ivory',
                'beige',
                'lightyellow',
                'lightgoldenrodyellow',
                'olive',
                'yellow',
                'olivedrab',
                'yellowgreen',
                'darkolivegreen',
                'greenyellow',
                'chartreuse',
                'lawngreen',
                'honeydew',
                'darkseagreen',
                'palegreen',
                'lightgreen',
                'forestgreen',
                'limegreen',
                'darkgreen',
                'green',
                'lime',
                'seagreen',
                'mediumseagreen',
                'springgreen',
                'mintcream',
                'mediumspringgreen',
                'mediumaquamarine',
                'aquamarine',
                'turquoise',
                'lightseagreen',
                'mediumturquoise',
                'azure',
                'lightcyan',
                'paleturquoise',
                'darkslategray',
                'darkslategrey',
                'teal',
                'darkcyan',
                'aqua',
                'cyan',
                'darkturquoise',
                'cadetblue',
                'powderblue',
                'lightblue',
                'deepskyblue',
                'skyblue',
                'lightskyblue',
                'steelblue',
                'aliceblue',
                'dodgerblue',
                'lightslategray',
                'lightslategrey',
                'slategray',
                'slategrey',
                'lightsteelblue',
                'cornflowerblue',
                'royalblue',
                'ghostwhite',
                'lavender',
                'midnightblue',
                'navy',
                'darkblue',
                'mediumblue',
                'blue',
                'slateblue',
                'darkslateblue',
                'mediumslateblue',
                'mediumpurple',
                'rebeccapurple',
                'blueviolet',
                'indigo',
                'darkorchid',
                'darkviolet',
                'mediumorchid',
                'thistle',
                'plum',
                'violet',
                'purple',
                'darkmagenta',
                'fuchsia',
                'magenta',
                'orchid',
                'mediumvioletred',
                'deeppink',
                'hotpink',
                'lavenderblush',
                'palevioletred',
                'crimson',
                'pink',
                'lightpink']
