"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Api = exports.ApiProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const apigateway_generated_1 = require("./apigateway.generated");
Object.defineProperty(exports, "ApiProperty", { enumerable: true, get: function () { return apigateway_generated_1.RosApi; } });
/**
 * A ROS resource type:  `ALIYUN::ApiGateway::Api`
 */
class Api extends ros.Resource {
    /**
     * Create a new `ALIYUN::ApiGateway::Api`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosApi = new apigateway_generated_1.RosApi(this, id, {
            requestConfig: props.requestConfig,
            description: props.description,
            resultSample: props.resultSample,
            disableInternet: props.disableInternet,
            apiName: props.apiName,
            forceNonceCheck: props.forceNonceCheck,
            resultType: props.resultType === undefined || props.resultType === null ? 'JSON' : props.resultType,
            failResultSample: props.failResultSample,
            errorCodeSamples: props.errorCodeSamples,
            groupId: props.groupId,
            serviceParametersMap: props.serviceParametersMap,
            requestParameters: props.requestParameters,
            appCodeAuthType: props.appCodeAuthType,
            serviceConfig: props.serviceConfig,
            constParameters: props.constParameters,
            systemParameters: props.systemParameters,
            openIdConnectConfig: props.openIdConnectConfig,
            visibility: props.visibility,
            serviceParameters: props.serviceParameters,
            authType: props.authType,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosApi;
        this.attrApiId = rosApi.attrApiId;
    }
}
exports.Api = Api;
//# sourceMappingURL=data:application/json;base64,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