"""Script to download AURA-TES from its webpage."""

from esmvaltool.cmorizers.data.downloaders.wget import NASADownloader


def download_dataset(config, dataset, dataset_info, start_date, end_date,
                     overwrite):
    """Download dataset.

    Parameters
    ----------
    config : dict
        ESMValTool's user configuration
    dataset : str
        Name of the dataset
    dataset_info : dict
         Dataset information from the datasets.yml file
    start_date : datetime
        Start of the interval to download
    end_date : datetime
        End of the interval to download
    overwrite : bool
        Overwrite already downloaded files
    """
    downloader = NASADownloader(
        config=config,
        dataset=dataset,
        dataset_info=dataset_info,
        overwrite=overwrite,
    )
    for path in FILES:
        downloader.download_file(path)


SERVER = "https://l5ftl01.larc.nasa.gov/ops/tesl1l2l3/TES/TL3O3M."

FILES = f"""{SERVER}005/2018.01.17/TES-Aura_L3-O3-M2018m01_C01_F01_11.he5
{SERVER}005/2017.11.02/TES-Aura_L3-O3-M2017m11_C01_F01_11.he5
{SERVER}005/2017.10.23/TES-Aura_L3-O3-M2017m10_C01_F01_11.he5
{SERVER}005/2012.11.02/TES-Aura_L3-O3-M2012m11_C01_F01_11.he5
{SERVER}005/2012.10.18/TES-Aura_L3-O3-M2012m10_C01_F01_11.he5
{SERVER}005/2012.09.17/TES-Aura_L3-O3-M2012m09_C01_F01_11.he5
{SERVER}005/2012.04.25/TES-Aura_L3-O3-M2012m04_C01_F01_11.he5
{SERVER}005/2011.12.04/TES-Aura_L3-O3-M2011m12_C01_F01_11.he5
{SERVER}005/2011.11.14/TES-Aura_L3-O3-M2011m11_C01_F01_11.he5
{SERVER}005/2011.09.11/TES-Aura_L3-O3-M2011m09_C01_F01_11.he5
{SERVER}005/2011.07.01/TES-Aura_L3-O3-M2011m07_C01_F01_11.he5
{SERVER}005/2011.06.01/TES-Aura_L3-O3-M2011m06_C01_F01_11.he5
{SERVER}005/2011.05.15/TES-Aura_L3-O3-M2011m05_C01_F01_11.he5
{SERVER}005/2011.04.02/TES-Aura_L3-O3-M2011m04_C01_F01_11.he5
{SERVER}005/2011.03.01/TES-Aura_L3-O3-M2011m03_C01_F01_11.he5
{SERVER}005/2011.02.01/TES-Aura_L3-O3-M2011m02_C01_F01_11.he5
{SERVER}005/2011.01.02/TES-Aura_L3-O3-M2011m01_C01_F01_11.he5
{SERVER}005/2010.12.01/TES-Aura_L3-O3-M2010m12_C01_F01_11.he5
{SERVER}005/2010.11.01/TES-Aura_L3-O3-M2010m11_C01_F01_11.he5
{SERVER}005/2010.10.28/TES-Aura_L3-O3-M2010m10_C01_F01_11.he5
{SERVER}005/2010.09.02/TES-Aura_L3-O3-M2010m09_C01_F01_11.he5
{SERVER}005/2010.08.01/TES-Aura_L3-O3-M2010m08_C01_F01_11.he5
{SERVER}005/2010.07.02/TES-Aura_L3-O3-M2010m07_C01_F01_11.he5
{SERVER}005/2010.06.02/TES-Aura_L3-O3-M2010m06_C01_F01_11.he5
{SERVER}005/2010.05.01/TES-Aura_L3-O3-M2010m05_C01_F01_11.he5
{SERVER}005/2010.03.03/TES-Aura_L3-O3-M2010m03_F01_11.he5
{SERVER}005/2009.12.02/TES-Aura_L3-O3-M2009m12_F01_11.he5
{SERVER}005/2009.11.02/TES-Aura_L3-O3-M2009m11_F01_11.he5
{SERVER}005/2009.10.01/TES-Aura_L3-O3-M2009m10_F01_11.he5
{SERVER}005/2009.09.01/TES-Aura_L3-O3-M2009m09_F01_11.he5
{SERVER}005/2009.08.02/TES-Aura_L3-O3-M2009m08_F01_11.he5
{SERVER}005/2009.07.01/TES-Aura_L3-O3-M2009m07_F01_11.he5
{SERVER}005/2009.06.01/TES-Aura_L3-O3-M2009m06_F01_11.he5
{SERVER}005/2009.05.02/TES-Aura_L3-O3-M2009m05_F01_11.he5
{SERVER}005/2009.04.02/TES-Aura_L3-O3-M2009m04_F01_11.he5
{SERVER}005/2009.03.01/TES-Aura_L3-O3-M2009m03_F01_11.he5
{SERVER}005/2009.02.01/TES-Aura_L3-O3-M2009m02_F01_11.he5
{SERVER}005/2009.01.02/TES-Aura_L3-O3-M2009m01_F01_11.he5
{SERVER}005/2008.12.03/TES-Aura_L3-O3-M2008m12_F01_11.he5
{SERVER}005/2008.11.01/TES-Aura_L3-O3-M2008m11_F01_11.he5
{SERVER}005/2008.10.02/TES-Aura_L3-O3-M2008m10_F01_11.he5
{SERVER}005/2008.09.02/TES-Aura_L3-O3-M2008m09_F01_11.he5
{SERVER}005/2008.08.01/TES-Aura_L3-O3-M2008m08_F01_11.he5
{SERVER}005/2008.07.02/TES-Aura_L3-O3-M2008m07_F01_11.he5
{SERVER}005/2008.06.02/TES-Aura_L3-O3-M2008m06_F01_11.he5
{SERVER}005/2008.05.01/TES-Aura_L3-O3-M2008m05_F01_11.he5
{SERVER}005/2008.04.01/TES-Aura_L3-O3-M2008m04_F01_11.he5
{SERVER}005/2008.03.02/TES-Aura_L3-O3-M2008m03_F01_11.he5
{SERVER}005/2008.02.01/TES-Aura_L3-O3-M2008m02_F01_11.he5
{SERVER}005/2008.01.02/TES-Aura_L3-O3-M2008m01_F01_11.he5
{SERVER}005/2007.12.01/TES-Aura_L3-O3-M2007m12_F01_11.he5
{SERVER}005/2007.11.01/TES-Aura_L3-O3-M2007m11_F01_11.he5
{SERVER}005/2007.10.02/TES-Aura_L3-O3-M2007m10_F01_11.he5
{SERVER}005/2007.09.02/TES-Aura_L3-O3-M2007m09_F01_11.he5
{SERVER}005/2007.08.01/TES-Aura_L3-O3-M2007m08_F01_11.he5
{SERVER}005/2007.07.02/TES-Aura_L3-O3-M2007m07_F01_11.he5
{SERVER}005/2007.06.02/TES-Aura_L3-O3-M2007m06_F01_11.he5
{SERVER}005/2007.05.01/TES-Aura_L3-O3-M2007m05_F01_11.he5
{SERVER}005/2007.04.01/TES-Aura_L3-O3-M2007m04_F01_11.he5
{SERVER}005/2007.03.02/TES-Aura_L3-O3-M2007m03_F01_11.he5
{SERVER}005/2007.02.02/TES-Aura_L3-O3-M2007m02_F01_11.he5
{SERVER}005/2007.01.01/TES-Aura_L3-O3-M2007m01_F01_11.he5
{SERVER}005/2006.12.02/TES-Aura_L3-O3-M2006m12_F01_11.he5
{SERVER}005/2006.11.02/TES-Aura_L3-O3-M2006m11_F01_11.he5
{SERVER}005/2006.10.01/TES-Aura_L3-O3-M2006m10_F01_11.he5
{SERVER}005/2006.09.09/TES-Aura_L3-O3-M2006m09_F01_11.he5
{SERVER}005/2006.08.02/TES-Aura_L3-O3-M2006m08_F01_11.he5
{SERVER}005/2006.07.01/TES-Aura_L3-O3-M2006m07_F01_11.he5
{SERVER}005/2006.06.01/TES-Aura_L3-O3-M2006m06_F01_11.he5
{SERVER}005/2006.05.02/TES-Aura_L3-O3-M2006m05_F01_11.he5
{SERVER}005/2006.04.02/TES-Aura_L3-O3-M2006m04_F01_11.he5
{SERVER}005/2006.03.01/TES-Aura_L3-O3-M2006m03_F01_11.he5
{SERVER}005/2006.02.01/TES-Aura_L3-O3-M2006m02_F01_11.he5
{SERVER}005/2006.01.02/TES-Aura_L3-O3-M2006m01_F01_11.he5
{SERVER}005/2005.12.07/TES-Aura_L3-O3-M2005m12_F01_11.he5
{SERVER}005/2005.11.05/TES-Aura_L3-O3-M2005m11_F01_11.he5
{SERVER}005/2005.10.02/TES-Aura_L3-O3-M2005m10_F01_11.he5
{SERVER}005/2005.09.02/TES-Aura_L3-O3-M2005m09_F01_11.he5
{SERVER}005/2005.08.01/TES-Aura_L3-O3-M2005m08_F01_11.he5
{SERVER}005/2005.07.04/TES-Aura_L3-O3-M2005m07_F01_11.he5
{SERVER}005/2005.03.04/TES-Aura_L3-O3-M2005m03_F01_11.he5
{SERVER}005/2005.02.02/TES-Aura_L3-O3-M2005m02_F01_11.he5
{SERVER}005/2005.01.01/TES-Aura_L3-O3-M2005m01_F01_11.he5
{SERVER}005/2004.12.02/TES-Aura_L3-O3-M2004m12_F01_11.he5
{SERVER}005/2004.11.04/TES-Aura_L3-O3-M2004m11_F01_11.he5
{SERVER}005/2004.10.09/TES-Aura_L3-O3-M2004m10_F01_11.he5
{SERVER}005/2004.09.03/TES-Aura_L3-O3-M2004m09_F01_11.he5
{SERVER}004/2012.11.02/TES-Aura_L3-O3-M2012m11_C01_F01_10.he5
{SERVER}004/2012.10.18/TES-Aura_L3-O3-M2012m10_C01_F01_10.he5
{SERVER}004/2012.09.17/TES-Aura_L3-O3-M2012m09_C01_F01_10.he5
{SERVER}004/2012.04.25/TES-Aura_L3-O3-M2012m04_C01_F01_10.he5
{SERVER}004/2011.12.04/TES-Aura_L3-O3-M2011m12_C01_F01_10.he5
{SERVER}004/2011.11.14/TES-Aura_L3-O3-M2011m11_C01_F01_10.he5
{SERVER}004/2011.09.11/TES-Aura_L3-O3-M2011m09_C01_F01_10.he5
{SERVER}004/2011.07.01/TES-Aura_L3-O3-M2011m07_C01_F01_10.he5
{SERVER}004/2011.06.01/TES-Aura_L3-O3-M2011m06_C01_F01_10.he5
{SERVER}004/2011.05.15/TES-Aura_L3-O3-M2011m05_C01_F01_10.he5
{SERVER}004/2011.04.02/TES-Aura_L3-O3-M2011m04_C01_F01_10.he5
{SERVER}004/2011.03.01/TES-Aura_L3-O3-M2011m03_C01_F01_10.he5
{SERVER}004/2011.02.01/TES-Aura_L3-O3-M2011m02_C01_F01_10.he5
{SERVER}004/2011.01.02/TES-Aura_L3-O3-M2011m01_C01_F01_10.he5
{SERVER}004/2010.12.01/TES-Aura_L3-O3-M2010m12_C01_F01_10.he5
{SERVER}004/2010.11.01/TES-Aura_L3-O3-M2010m11_C01_F01_10.he5
{SERVER}004/2010.10.28/TES-Aura_L3-O3-M2010m10_C01_F01_10.he5
{SERVER}004/2010.09.02/TES-Aura_L3-O3-M2010m09_C01_F01_10.he5
{SERVER}004/2010.08.01/TES-Aura_L3-O3-M2010m08_C01_F01_10.he5
{SERVER}004/2010.07.02/TES-Aura_L3-O3-M2010m07_C01_F01_10.he5
{SERVER}004/2010.06.02/TES-Aura_L3-O3-M2010m06_C01_F01_10.he5
{SERVER}004/2010.05.01/TES-Aura_L3-O3-M2010m05_C01_F01_10.he5
{SERVER}004/2010.04.01/TES-Aura_L3-O3-M2010m04_F01_10.he5
{SERVER}004/2010.03.03/TES-Aura_L3-O3-M2010m03_F01_10.he5
{SERVER}004/2009.12.02/TES-Aura_L3-O3-M2009m12_F01_10.he5
{SERVER}004/2009.11.02/TES-Aura_L3-O3-M2009m11_F01_10.he5
{SERVER}004/2009.10.01/TES-Aura_L3-O3-M2009m10_F01_10.he5
{SERVER}004/2009.09.01/TES-Aura_L3-O3-M2009m09_F01_10.he5
{SERVER}004/2009.08.02/TES-Aura_L3-O3-M2009m08_F01_10.he5
{SERVER}004/2009.07.01/TES-Aura_L3-O3-M2009m07_F01_10.he5
{SERVER}004/2009.06.01/TES-Aura_L3-O3-M2009m06_F01_10.he5
{SERVER}004/2009.05.02/TES-Aura_L3-O3-M2009m05_F01_10.he5
{SERVER}004/2009.04.02/TES-Aura_L3-O3-M2009m04_F01_10.he5
{SERVER}004/2009.03.01/TES-Aura_L3-O3-M2009m03_F01_10.he5
{SERVER}004/2009.02.01/TES-Aura_L3-O3-M2009m02_F01_10.he5
{SERVER}004/2009.01.02/TES-Aura_L3-O3-M2009m01_F01_10.he5
{SERVER}004/2008.12.03/TES-Aura_L3-O3-M2008m12_F01_10.he5
{SERVER}004/2008.11.01/TES-Aura_L3-O3-M2008m11_F01_10.he5
{SERVER}004/2008.10.02/TES-Aura_L3-O3-M2008m10_F01_10.he5
{SERVER}004/2008.09.02/TES-Aura_L3-O3-M2008m09_F01_10.he5
{SERVER}004/2008.08.01/TES-Aura_L3-O3-M2008m08_F01_10.he5
{SERVER}004/2008.07.02/TES-Aura_L3-O3-M2008m07_F01_10.he5
{SERVER}004/2008.06.02/TES-Aura_L3-O3-M2008m06_F01_10.he5
{SERVER}004/2008.05.01/TES-Aura_L3-O3-M2008m05_F01_10.he5
{SERVER}004/2008.04.01/TES-Aura_L3-O3-M2008m04_F01_10.he5
{SERVER}004/2008.03.02/TES-Aura_L3-O3-M2008m03_F01_10.he5
{SERVER}004/2008.02.01/TES-Aura_L3-O3-M2008m02_F01_10.he5
{SERVER}004/2008.01.02/TES-Aura_L3-O3-M2008m01_F01_10.he5
{SERVER}004/2007.12.01/TES-Aura_L3-O3-M2007m12_F01_10.he5
{SERVER}004/2007.11.01/TES-Aura_L3-O3-M2007m11_F01_10.he5
{SERVER}004/2007.10.02/TES-Aura_L3-O3-M2007m10_F01_10.he5
{SERVER}004/2007.09.02/TES-Aura_L3-O3-M2007m09_F01_10.he5
{SERVER}004/2007.08.01/TES-Aura_L3-O3-M2007m08_F01_10.he5
{SERVER}004/2007.07.02/TES-Aura_L3-O3-M2007m07_F01_10.he5
{SERVER}004/2007.06.02/TES-Aura_L3-O3-M2007m06_F01_10.he5
{SERVER}004/2007.05.01/TES-Aura_L3-O3-M2007m05_F01_10.he5
{SERVER}004/2007.04.01/TES-Aura_L3-O3-M2007m04_F01_10.he5
{SERVER}004/2007.03.02/TES-Aura_L3-O3-M2007m03_F01_10.he5
{SERVER}004/2007.02.02/TES-Aura_L3-O3-M2007m02_F01_10.he5
{SERVER}004/2007.01.01/TES-Aura_L3-O3-M2007m01_F01_10.he5
{SERVER}004/2006.12.02/TES-Aura_L3-O3-M2006m12_F01_10.he5
{SERVER}004/2006.11.02/TES-Aura_L3-O3-M2006m11_F01_10.he5
{SERVER}004/2006.10.01/TES-Aura_L3-O3-M2006m10_F01_10.he5
{SERVER}004/2006.09.09/TES-Aura_L3-O3-M2006m09_F01_10.he5
{SERVER}004/2006.08.02/TES-Aura_L3-O3-M2006m08_F01_10.he5
{SERVER}004/2006.07.01/TES-Aura_L3-O3-M2006m07_F01_10.he5
{SERVER}004/2006.06.01/TES-Aura_L3-O3-M2006m06_F01_10.he5
{SERVER}004/2006.05.02/TES-Aura_L3-O3-M2006m05_F01_10.he5
{SERVER}004/2006.04.02/TES-Aura_L3-O3-M2006m04_F01_10.he5
{SERVER}004/2006.03.01/TES-Aura_L3-O3-M2006m03_F01_10.he5
{SERVER}004/2006.02.01/TES-Aura_L3-O3-M2006m02_F01_10.he5
{SERVER}004/2006.01.02/TES-Aura_L3-O3-M2006m01_F01_10.he5
{SERVER}004/2005.12.07/TES-Aura_L3-O3-M2005m12_F01_10.he5
{SERVER}004/2005.11.05/TES-Aura_L3-O3-M2005m11_F01_10.he5
{SERVER}004/2005.10.02/TES-Aura_L3-O3-M2005m10_F01_10.he5
{SERVER}004/2005.09.02/TES-Aura_L3-O3-M2005m09_F01_10.he5
{SERVER}004/2005.08.01/TES-Aura_L3-O3-M2005m08_F01_10.he5
{SERVER}004/2005.07.04/TES-Aura_L3-O3-M2005m07_F01_10.he5
{SERVER}004/2005.03.04/TES-Aura_L3-O3-M2005m03_F01_10.he5
{SERVER}004/2005.02.02/TES-Aura_L3-O3-M2005m02_F01_10.he5
{SERVER}004/2005.01.01/TES-Aura_L3-O3-M2005m01_F01_10.he5
{SERVER}004/2004.12.02/TES-Aura_L3-O3-M2004m12_F01_10.he5
{SERVER}004/2004.11.04/TES-Aura_L3-O3-M2004m11_F01_10.he5
{SERVER}004/2004.10.09/TES-Aura_L3-O3-M2004m10_F01_10.he5
{SERVER}004/2004.09.03/TES-Aura_L3-O3-M2004m09_F01_10.he5
{SERVER}004/2004.08.22/TES-Aura_L3-O3-M2004m08_F01_10.he5""".split('\n')
