from .metrics import (
    total_return,
    cagr,
    returns_table,
    rolling_cumulative_return,
    annualized_volatility,
    max_drawdown,
    ulcer_index,
    ulcer_performance_index,
    parametric_var,
    parametric_expected_shortfall,
    tail_ratio,
    sharpe_ratio,
    sortino_ratio,
    calmar_ratio,
    omega_ratio,
    information_ratio,
    capm_alpha_beta,
    skewness,
    kurtosis,
    variance_ratio,
    acf,
    pacf,
    fama_french_3factor,
    fama_french_5factor,
    cumulative_excess_return,
)

from .trade_stats import (
    hit_rate,
    average_win_loss,
    expectancy,
    profit_factor,
    trade_duration_distribution,
    turnover,
    trade_implementation_shortfall,
    cumulative_implementation_shortfall,
    slippage_stats,
    latency_stats,
)

__all__ = [
    "total_return",
    "cagr",
    "returns_table",
    "rolling_cumulative_return",
    "annualized_volatility",
    "max_drawdown",
    "ulcer_index",
    "ulcer_performance_index",
    "parametric_var",
    "parametric_expected_shortfall",
    "tail_ratio",
    "sharpe_ratio",
    "sortino_ratio",
    "calmar_ratio",
    "omega_ratio",
    "information_ratio",
    "capm_alpha_beta",
    "skewness",
    "kurtosis",
    "variance_ratio",
    "acf",
    "pacf",
    "fama_french_3factor",
    "fama_french_5factor",
    "cumulative_excess_return",
    "hit_rate",
    "average_win_loss",
    "expectancy",
    "profit_factor",
    "trade_duration_distribution",
    "turnover",
    "trade_implementation_shortfall",
    "cumulative_implementation_shortfall",
    "slippage_stats",
    "latency_stats",
]

try:  # pragma: no cover - optional plotting deps
    from .plots import (
        plot_equity_curve,
        plot_return_heatmap,
        plot_underwater,
        plot_rolling_volatility,
        plot_rolling_var,
        plot_rolling_sharpe,
        plot_rolling_sortino,
        plot_return_scatter,
        plot_cumulative_excess_return,
        plot_factor_exposures,
        plot_trade_return_hist,
        plot_return_by_holding_period,
        plot_exposure_ts,
        plot_cumulative_shortfall,
        plot_alpha_vs_return,
        plot_qq_returns,
        plot_rolling_skewness,
        plot_rolling_kurtosis,
    )

    __all__ += [
        "plot_equity_curve",
        "plot_return_heatmap",
        "plot_underwater",
        "plot_rolling_volatility",
        "plot_rolling_var",
        "plot_rolling_sharpe",
        "plot_rolling_sortino",
        "plot_return_scatter",
        "plot_cumulative_excess_return",
        "plot_factor_exposures",
        "plot_trade_return_hist",
        "plot_return_by_holding_period",
        "plot_exposure_ts",
        "plot_cumulative_shortfall",
        "plot_alpha_vs_return",
        "plot_qq_returns",
        "plot_rolling_skewness",
        "plot_rolling_kurtosis",
    ]
except Exception:  # pragma: no cover - matplotlib may be missing
    pass
