# Investment Strategies Library: algo-wars

`algo-wars` is Python library for Investment Strategies such as Volatility Modeling, Technical Analysis, and Portfolio Optimization. The goal of this library is to provides cues for strategies to investment or trade stock, bond, or cryptocurrency, based on the statistical machine learning and the deep reignforcement learning. Especialy, this library provides apprication of the Volatility model based on Conditional Generative Adversarial Networks(Conditional GANs) and Portfolio Selection based on Deep Q-Network.

Please do note that this library is currently in *BETA* Testing. Please use this library **at your own risk**.

## Installation

Install using pip:

```sh
pip install algo-wars
```

### Source code

The source code is currently hosted on GitHub.

- [accel-brain-code/Algorithm-Wars](https://github.com/accel-brain/accel-brain-code/tree/master/Algorithm-Wars)

### Python package index(PyPI)

Installers for the latest released version are available at the Python package index.

- [algo-wars : Python Package Index](https://pypi.org/pypi/algo-wars/)

### Dependencies

- [numpy](https://github.com/numpy/numpy): v1.13.3 or higher.
- [pandas](https://github.com/pandas-dev/pandas): v0.22.0 or higher.
- [accel-brain-base](https://github.com/accel-brain/accel-brain-code/tree/master/Accel-Brain-Base): v1.0.0 or higher.

#### Options

- [yfinance](https://github.com/ranaroussi/yfinance)
    * Only when using [algowars/extractablehistoricaldata/facade_yfinance.py](https://github.com/accel-brain/accel-brain-code/blob/master/Algorithm-Wars/algowars/extractablehistoricaldata/facade_yfinance.py).

<!--
## Documentation

Full documentation is available on [https://code.accel-brain.com/Algorithm-Wars/](https://code.accel-brain.com/Algorithm-Wars/) . This document contains information on functionally reusability, functional scalability and functional extensibility.
-->

## Description

The library is designing a complex of two deep architectures:

1. Generative Adversarial Networks(GAN) that enable the generation of pseudo-historical data.
2. Multi-agent Deep Reinforcement Learning(Multi-agent DRL) that addresses multiple investment strategies such as volatility minimization and Sharpe ratio maximization.

For convenience, we named this complex system *Adversarial Generative Deep Reinforcement Learning*.

Multi-agent DRL can acquire high generalization performance and domain adaptability by learning both the historical data generated by GAN and the true historical data. Multi-agent DRL develops a solution under two problem settings: volatility minimization and Sharpe ratio maximization. Multiple agents are assigned to each problem setting. Finally, the portfolio of agents with the highest cost performance is output as the winning portfolio.

This library uses Retrospective encoders from Zhang, K., et al. (2018) as generative models in designing GANs for modeling volatility. This model is also mentioned in [Automatic Summarization Library: pysummarization](https://github.com/accel-brain/accel-brain-code/tree/master/Automatic-Summarization). The loss/error function and network structure are designed according to Akcay, S., et al. (2018). As used in [Generative Adversarial Networks Library: pygan](https://github.com/accel-brain/accel-brain-code/tree/master/Generative-Adversarial-Networks), This model facilitates manifold learning by adding a re-encoder to the encoder-decoder network structure.

The Multi-agent DRL is designed as a Deep Q-network derived from the decentralized partially observable Markov decision process(Dec-POMDP) proposed by Egorov, M. (2016). This model is also mentioned in [Reinforcement Learning Library: pyqlearning](https://github.com/accel-brain/accel-brain-code/tree/master/Reinforcement-Learning).

### Setup master data of ticker symbols.

Before starting learning, it is necessary to prepare the master data of securities. Demo data is located in [masterdata/ticker_master_demo.csv](https://github.com/accel-brain/accel-brain-code/blob/master/Algorithm-Wars/masterdata/ticker_master_demo.csv). This master data is referred to during data preparation and learning.

The column definition is as follows.

- `ticker`: Ticker Symbol.
- `asset`: Asset type.
- `area`: If the asset has regionality, write a symbol such as the category.
    * If it's a US stock, for instance, write `US`.
- `detail`: It's just a space for notes. The system does not refer to this value.
- `asset_allocation`: Weight per asset. This value is referenced when calculating the portfolio percentage.
    * If you want to judge purely by the algorithm, write a constant here.
- `area_allocation`: Weight per area. This value is referenced when calculating the portfolio percentage.
    * If you want to judge purely by the algorithm, write a constant here.
- `expense_ratio`: ETF expense ratio. Write `0.0` for individual stocks and crypto assets.
- `yield`: Past annual yield.
- `commission`: Trading fees.
- `tax`: Tax rate on capital gains.

### Data Preparation

Historical data must be placed in the `logs / historical /` directory as a CSV file consisting of the following formats:

- `timestamp`: `YYYY-MM-DD`
- `open`: open.
- `high`: high.
- `low`: low.
- `close`: close.
- `adjusted_close`: adjusted close.
- `volume`: volume.

It is necessary to prepare one CSV file for each Ticker symbols. Also, the file name must be associated with the value in the `ticker` column in the security master data.

Historical data can be obtained from various REST (ful) APIs. This library already has a batch program for retrieving data from several APIs. For instance, 

```bash
python algowars/extractablehistoricaldata/facade_yfinance.py \
-v True \
-tmp ./masterdata/ticker_master_demo.csv
```

Learning and inference can be performed from the following batch programs.

```bash
python algowars/portfolio_dqn_controller.py \
-v True \
-sd 2013-06-24 -ed 2020-06-23 \
-gsd 2021-01-01 -ged 2021-04-27 \
-df 30 \
-an 3 \
-ep 300 \
-nan 3 \
-lrdqn 1e-04 -lr 1e-10 \
-in 500 \
-bs 20 \
-sl 10  \
-rpm 1.0 \
-rps 0.1 \
-gpp params/recursive_seq_2_seq_model_re_encoder_model.params \
-rpp params/recursive_seq_2_seq_model_model.params \
-dpp params/discriminative_model_model.params \
-dqnpp params/dqn_model.params \
-tmp masterdata/ticker_master_demo.csv \
-sc all \
-mm 120000 \
-mfm \
-ltsl 90
```

You can check the interface specifications of the batch program with the following command.

```bash
python algowars/portfolio_dqn_controller.py -h
```

A demonstration of visualizing the results of pseudo-historical data generation and portfolio optimization is demonstrated in the following notebook.

- [demo-portfolio-optimization.ipynb](https://github.com/accel-brain/accel-brain-code/blob/master/Algorithm-Wars/demo-portfolio-optimization.ipynb)

## References

- Akcay, S., Atapour-Abarghouei, A., & Breckon, T. P. (2018, December). Ganomaly: Semi-supervised anomaly detection via adversarial training. In Asian Conference on Computer Vision (pp. 622-637). Springer, Cham.
- Donahue, J., Krähenbühl, P., & Darrell, T. (2016). Adversarial feature learning. arXiv preprint arXiv:1605.09782.
- Makhzani, A., Shlens, J., Jaitly, N., Goodfellow, I., & Frey, B. (2015). Adversarial autoencoders. arXiv preprint arXiv:1511.05644.
- Salimans, T., Goodfellow, I., Zaremba, W., Cheung, V., Radford, A., & Chen, X. (2016). Improved techniques for training gans. In Advances in neural information processing systems (pp. 2234-2242).
- Schlegl, T., Seeböck, P., Waldstein, S. M., Schmidt-Erfurth, U., & Langs, G. (2017, June). Unsupervised anomaly detection with generative adversarial networks to guide marker discovery. In International conference on information processing in medical imaging (pp. 146-157). Springer, Cham.
- Yeh, R., Chen, C., Lim, T. Y., Hasegawa-Johnson, M., & Do, M. N. (2016). Semantic image inpainting with perceptual and contextual losses. arXiv preprint arXiv:1607.07539, 2(3).
- Zenati, H., Foo, C. S., Lecouat, B., Manek, G., & Chandrasekhar, V. R. (2018). Efficient gan-based anomaly detection. arXiv preprint arXiv:1802.06222.
- Zhang, K., Grauman, K., & Sha, F. (2018). Retrospective Encoders for Video Summarization. In Proceedings of the European Conference on Computer Vision (ECCV) (pp. 383-399).

## Author

- accel-brain

## Author URI

- https://accel-brain.co.jp/
- https://accel-brain.com/

## License

- GNU General Public License v2.0

