/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.internalframe;

import com.github.weisj.darklaf.components.border.DropShadowBorder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarkInternalFrameBorder
extends DropShadowBorder
implements UIResource {
    private final float activeOpacity = (float)UIManager.getInt("InternalFrame.activeShadowOpacity") / 100.0f;
    private final float inactiveOpacity = (float)UIManager.getInt("InternalFrame.inactiveShadowOpacity") / 100.0f;

    public DarkInternalFrameBorder() {
        int shadowSize = UIManager.getInt("InternalFrame.shadowSize");
        this.setShadowSize(shadowSize);
        this.setCornerSize(2 * shadowSize);
        this.setShadowOpacity(this.activeOpacity);
        this.setShadowColor(UIManager.getColor("InternalFrame.borderShadowColor"));
        this.setShowTopShadow(true);
        this.setShowBottomShadow(true);
        this.setShowLeftShadow(true);
        this.setShowRightShadow(true);
    }

    @Override
    public void paintBorder(Component c, Graphics graphics, int x, int y, int width, int height) {
        if (c instanceof JInternalFrame && ((JInternalFrame)c).isMaximum()) {
            return;
        }
        this.updateOpacity(c);
        super.paintBorder(c, graphics, x, y, width, height);
    }

    protected void updateOpacity(Component c) {
        if (c instanceof JInternalFrame && ((JInternalFrame)c).isSelected()) {
            this.setShadowOpacity(this.activeOpacity);
        } else {
            this.setShadowOpacity(this.inactiveOpacity);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (c instanceof JInternalFrame && ((JInternalFrame)c).isMaximum()) {
            return new InsetsUIResource(0, 0, 0, 0);
        }
        this.updateOpacity(c);
        return super.getBorderInsets(c);
    }
}

