/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.combobox;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.ui.WidgetPopupHelper;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

public class DarkComboPopup
extends BasicComboPopup {
    private final AdjustmentListener adjustmentListener = e -> {
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this.list);
        MouseEvent ev = new MouseEvent(this.list, 503, 0L, 0, p.x, p.y, 1, false, 0);
        for (MouseMotionListener ml : this.list.getMouseMotionListeners()) {
            if (ml == null) continue;
            ml.mouseMoved(ev);
        }
    };
    private boolean visible = false;
    private OverlayScrollPane overlayScrollPane;

    public DarkComboPopup(JComboBox<Object> combo) {
        super(combo);
    }

    @Override
    protected JList<Object> createList() {
        JList<Object> list = super.createList();
        list.putClientProperty("JList..isComboList", true);
        return list;
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        if (this.list.getModel().getSize() != 0) {
            int height = this.list.getUI().getCellBounds(this.list, (int)0, (int)0).height;
            this.overlayScrollPane.getVerticalScrollBar().setUnitIncrement(height);
        }
        this.visible = true;
        this.overlayScrollPane.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
        super.firePopupMenuWillBecomeVisible();
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        this.visible = false;
        this.overlayScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        super.firePopupMenuWillBecomeInvisible();
    }

    @Override
    protected void firePopupMenuCanceled() {
        this.visible = false;
        this.overlayScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        super.firePopupMenuCanceled();
    }

    @Override
    protected JScrollPane createScroller() {
        this.overlayScrollPane = new OverlayScrollPane(this.list, 20, 30);
        this.overlayScrollPane.getVerticalScrollBar().putClientProperty("JComponent.small", Boolean.TRUE);
        return this.overlayScrollPane.getScrollPane();
    }

    @Override
    protected void configureScroller() {
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.setBorder(null);
    }

    @Override
    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setOpaque(false);
        this.add(this.overlayScrollPane);
        this.setFocusable(false);
    }

    @Override
    public void show() {
        this.comboBox.firePopupMenuWillBecomeVisible();
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point location = this.getPopupLocation();
        this.show(this.comboBox, location.x, location.y);
    }

    protected void setListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    protected Point getPopupLocation() {
        this.scroller.setPreferredSize(null);
        Dimension dim = this.getPreferredSize();
        dim.height = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
        Dimension parentSize = this.comboBox.getSize();
        Insets ins = this.getInsets();
        parentSize.width -= ins.left + ins.right;
        dim.width -= ins.left + ins.right;
        Rectangle popupBounds = WidgetPopupHelper.getPopupBounds(this.comboBox, dim, parentSize);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }

    @Override
    protected void togglePopup() {
        if (this.comboBox.getItemCount() == 0) {
            return;
        }
        if (this.visible) {
            this.visible = false;
            this.hide();
        } else {
            this.visible = true;
            this.show();
        }
    }

    protected void reset() {
        if (this.visible) {
            this.hide();
        }
        this.visible = false;
    }
}

