/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.builder.BogusFrameOfReferenceProvider;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.PlotSvgComponent;
import jetbrains.datalore.plot.builder.SquareFrameOfReferenceProvider;
import jetbrains.datalore.plot.builder.TileFrameOfReferenceProvider;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.assemble.PlotAssemblerUtil;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.assemble.TypedScaleMap;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.LiveMapTileLayout;
import jetbrains.datalore.plot.builder.layout.PlotLayout;
import jetbrains.datalore.plot.builder.theme.Theme;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010(\u001a\u00020)J&\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0005H\u0002J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000201J\b\u00103\u001a\u00020\rH\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R*\u0010\u0016\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00065"}, d2={"Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "", "scaleByAes", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "layersByTile", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "(Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;Ljava/util/List;Ljetbrains/datalore/plot/builder/coord/CoordProvider;Ljetbrains/datalore/plot/builder/theme/Theme;)V", "containsLiveMap", "", "getContainsLiveMap", "()Z", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "getFacets", "()Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "setFacets", "(Ljetbrains/datalore/plot/builder/assemble/PlotFacets;)V", "guideOptionsMap", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "getGuideOptionsMap", "()Ljava/util/Map;", "setGuideOptionsMap", "(Ljava/util/Map;)V", "interactionsEnabled", "getLayersByTile", "()Ljava/util/List;", "legendsEnabled", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "createPlot", "Ljetbrains/datalore/plot/builder/PlotSvgComponent;", "fOrProvider", "Ljetbrains/datalore/plot/builder/TileFrameOfReferenceProvider;", "plotLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "legendBoxInfos", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "disableInteractions", "", "disableLegends", "hasLayers", "Companion", "plot-builder-portable"})
public final class PlotAssembler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TypedScaleMap scaleByAes;
    @NotNull
    private final List<List<GeomLayer>> layersByTile;
    @NotNull
    private final CoordProvider coordProvider;
    @NotNull
    private final Theme theme;
    private final boolean containsLiveMap;
    @NotNull
    private PlotFacets facets;
    @Nullable
    private String title;
    @NotNull
    private Map<Aes<?>, ? extends GuideOptions> guideOptionsMap;
    private boolean legendsEnabled;
    private boolean interactionsEnabled;

    /*
     * WARNING - void declaration
     */
    private PlotAssembler(TypedScaleMap scaleByAes2, List<? extends List<? extends GeomLayer>> layersByTile, CoordProvider coordProvider, Theme theme) {
        boolean bl;
        boolean bl2;
        block3: {
            void $this$any$iv;
            this.scaleByAes = scaleByAes2;
            this.layersByTile = layersByTile;
            this.coordProvider = coordProvider;
            this.theme = theme;
            Iterable iterable = CollectionsKt.flatten((Iterable)this.layersByTile);
            PlotAssembler plotAssembler = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GeomLayer p0 = (GeomLayer)element$iv;
                    boolean bl3 = false;
                    if (!p0.isLiveMap()) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        plotAssembler.containsLiveMap = bl = bl2;
        this.facets = PlotFacets.Companion.undefined();
        this.guideOptionsMap = new HashMap();
        this.legendsEnabled = true;
        this.interactionsEnabled = true;
    }

    @NotNull
    public final List<List<GeomLayer>> getLayersByTile() {
        return this.layersByTile;
    }

    public final boolean getContainsLiveMap() {
        return this.containsLiveMap;
    }

    @NotNull
    public final PlotFacets getFacets() {
        return this.facets;
    }

    public final void setFacets(@NotNull PlotFacets plotFacets) {
        Intrinsics.checkNotNullParameter((Object)plotFacets, (String)"<set-?>");
        this.facets = plotFacets;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    @NotNull
    public final Map<Aes<?>, GuideOptions> getGuideOptionsMap() {
        return this.guideOptionsMap;
    }

    public final void setGuideOptionsMap(@NotNull Map<Aes<?>, ? extends GuideOptions> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.guideOptionsMap = map2;
    }

    private final boolean hasLayers() {
        for (List<GeomLayer> tileLayers : this.layersByTile) {
            Collection collection = tileLayers;
            boolean bl = false;
            if (!(!collection.isEmpty())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final PlotSvgComponent createPlot() {
        PlotSvgComponent plotSvgComponent;
        List<LegendBoxInfo> legendsBoxInfos;
        boolean bl = this.hasLayers();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "No layers in plot";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List<LegendBoxInfo> list = legendsBoxInfos = this.legendsEnabled ? PlotAssemblerUtil.INSTANCE.createLegends(this.layersByTile, this.guideOptionsMap, this.theme.legend()) : CollectionsKt.emptyList();
        if (this.containsLiveMap) {
            PlotLayout plotLayout = PlotAssemblerUtil.INSTANCE.createPlotLayout(new LiveMapTileLayout(), this.facets, this.theme.facets());
            BogusFrameOfReferenceProvider fOrProvider = new BogusFrameOfReferenceProvider();
            plotSvgComponent = this.createPlot(fOrProvider, plotLayout, legendsBoxInfos);
        } else {
            boolean flipAxis = this.coordProvider.getFlipAxis();
            Pair<ClosedRange<Double>, ClosedRange<Double>> pair = PlotAssemblerUtil.INSTANCE.computePlotDryRunXYRanges(this.layersByTile);
            ClosedRange xAesRange = (ClosedRange)pair.component1();
            ClosedRange yAesRange = (ClosedRange)pair.component2();
            Pair<ClosedRange<Double>, ClosedRange<Double>> pair2 = this.coordProvider.adjustDomains((ClosedRange<Double>)(flipAxis ? yAesRange : xAesRange), (ClosedRange<Double>)(flipAxis ? xAesRange : yAesRange));
            ClosedRange hDomain = (ClosedRange)pair2.component1();
            ClosedRange vDomain = (ClosedRange)pair2.component2();
            boolean bl5 = flipAxis;
            Pair pair3 = bl5 ? TuplesKt.to((Object)Aes.Companion.getY(), (Object)Aes.Companion.getX()) : TuplesKt.to((Object)Aes.Companion.getX(), (Object)Aes.Companion.getY());
            Aes hAes = (Aes)pair3.component1();
            Aes vAes = (Aes)pair3.component2();
            SquareFrameOfReferenceProvider fOrProvider = new SquareFrameOfReferenceProvider(this.scaleByAes.get(hAes), this.scaleByAes.get(vAes), (ClosedRange<Double>)hDomain, (ClosedRange<Double>)vDomain, flipAxis, this.theme);
            PlotLayout plotLayout = PlotAssemblerUtil.INSTANCE.createPlotLayout(fOrProvider.createTileLayout(), this.facets, this.theme.facets());
            plotSvgComponent = this.createPlot(fOrProvider, plotLayout, legendsBoxInfos);
        }
        return plotSvgComponent;
    }

    private final PlotSvgComponent createPlot(TileFrameOfReferenceProvider fOrProvider, PlotLayout plotLayout, List<? extends LegendBoxInfo> legendBoxInfos) {
        return new PlotSvgComponent(this.title, this.layersByTile, plotLayout, fOrProvider, this.coordProvider, legendBoxInfos, this.interactionsEnabled, this.theme);
    }

    public final void disableLegends() {
        this.legendsEnabled = false;
    }

    public final void disableInteractions() {
        this.interactionsEnabled = false;
    }

    public /* synthetic */ PlotAssembler(TypedScaleMap scaleByAes2, List layersByTile, CoordProvider coordProvider, Theme theme, DefaultConstructorMarker $constructor_marker) {
        this(scaleByAes2, layersByTile, coordProvider, theme);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ,\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/assemble/PlotAssembler$Companion;", "", "()V", "multiTile", "Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "scaleByAes", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "layersByTile", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "singleTile", "plotLayers", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlotAssembler singleTile(@NotNull TypedScaleMap scaleByAes2, @NotNull List<? extends GeomLayer> plotLayers, @NotNull CoordProvider coordProvider, @NotNull Theme theme) {
            Intrinsics.checkNotNullParameter((Object)scaleByAes2, (String)"scaleByAes");
            Intrinsics.checkNotNullParameter(plotLayers, (String)"plotLayers");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            ArrayList<List<? extends GeomLayer>> layersByTile = new ArrayList<List<? extends GeomLayer>>();
            layersByTile.add(plotLayers);
            return this.multiTile(scaleByAes2, (List<? extends List<? extends GeomLayer>>)layersByTile, coordProvider, theme);
        }

        @NotNull
        public final PlotAssembler multiTile(@NotNull TypedScaleMap scaleByAes2, @NotNull List<? extends List<? extends GeomLayer>> layersByTile, @NotNull CoordProvider coordProvider, @NotNull Theme theme) {
            Intrinsics.checkNotNullParameter((Object)scaleByAes2, (String)"scaleByAes");
            Intrinsics.checkNotNullParameter(layersByTile, (String)"layersByTile");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Theme theme2 = layersByTile.size() > 1 ? theme.multiTile() : theme;
            return new PlotAssembler(scaleByAes2, layersByTile, coordProvider, theme2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

