/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.NullGeomTargetCollector;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.builder.assemble.ImmutableGeomContext;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J0\u0010\u0015\u001a\u00020\u00012&\u0010\u0015\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b0\tH\u0016J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0013H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\b\u001a$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder;", "Ljetbrains/datalore/plot/builder/assemble/ImmutableGeomContext$Builder;", "()V", "ctx", "Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder$MyGeomContext;", "(Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder$MyGeomContext;)V", "myAesBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "myAestheticMappers", "", "Ljetbrains/datalore/plot/base/Aes;", "Lkotlin/Function1;", "", "", "myAesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "myFlipped", "", "myGeomTargetCollector", "Ljetbrains/datalore/plot/base/interact/GeomTargetCollector;", "aesBounds", "aestheticMappers", "aesthetics", "build", "Ljetbrains/datalore/plot/builder/assemble/ImmutableGeomContext;", "flipped", "geomTargetCollector", "MyGeomContext", "plot-builder-portable"})
public final class GeomContextBuilder
implements ImmutableGeomContext.Builder {
    private boolean myFlipped;
    @Nullable
    private Aesthetics myAesthetics;
    @Nullable
    private Map<Aes<?>, ? extends Function1<? super Double, ? extends Object>> myAestheticMappers;
    @Nullable
    private DoubleRectangle myAesBounds;
    @NotNull
    private GeomTargetCollector myGeomTargetCollector = (GeomTargetCollector)new NullGeomTargetCollector();

    public GeomContextBuilder() {
    }

    private GeomContextBuilder(MyGeomContext ctx) {
        this.myFlipped = ctx.getFlipped();
        this.myAesthetics = ctx.getMyAesthetics();
        this.myAestheticMappers = ctx.getMyAestheticMappers();
        this.myAesBounds = ctx.getMyAesBounds();
        this.myGeomTargetCollector = ctx.getTargetCollector();
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder flipped(boolean flipped) {
        this.myFlipped = flipped;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder aesthetics(@NotNull Aesthetics aesthetics) {
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        this.myAesthetics = aesthetics;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder aestheticMappers(@NotNull Map<Aes<?>, ? extends Function1<? super Double, ? extends Object>> aestheticMappers) {
        Intrinsics.checkNotNullParameter(aestheticMappers, (String)"aestheticMappers");
        this.myAestheticMappers = aestheticMappers;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder aesBounds(@NotNull DoubleRectangle aesBounds) {
        Intrinsics.checkNotNullParameter((Object)aesBounds, (String)"aesBounds");
        this.myAesBounds = aesBounds;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder geomTargetCollector(@NotNull GeomTargetCollector geomTargetCollector) {
        Intrinsics.checkNotNullParameter((Object)geomTargetCollector, (String)"geomTargetCollector");
        this.myGeomTargetCollector = geomTargetCollector;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext build() {
        return new MyGeomContext(this);
    }

    public /* synthetic */ GeomContextBuilder(MyGeomContext ctx, DefaultConstructorMarker $constructor_marker) {
        this(ctx);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\nH\u0016J\u0016\u0010\u001e\u001a\u00020\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0016\u0010 \u001a\u00020\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR3\u0010\r\u001a$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0010\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder$MyGeomContext;", "Ljetbrains/datalore/plot/builder/assemble/ImmutableGeomContext;", "b", "Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder;", "(Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder;)V", "flipped", "", "getFlipped", "()Z", "myAesBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getMyAesBounds", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "myAestheticMappers", "", "Ljetbrains/datalore/plot/base/Aes;", "Lkotlin/Function1;", "", "", "getMyAestheticMappers", "()Ljava/util/Map;", "myAesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "getMyAesthetics", "()Ljetbrains/datalore/plot/base/Aesthetics;", "targetCollector", "Ljetbrains/datalore/plot/base/interact/GeomTargetCollector;", "getTargetCollector", "()Ljetbrains/datalore/plot/base/interact/GeomTargetCollector;", "getAesBounds", "getResolution", "aes", "getUnitResolution", "with", "Ljetbrains/datalore/plot/builder/assemble/ImmutableGeomContext$Builder;", "withTargetCollector", "Ljetbrains/datalore/plot/base/GeomContext;", "plot-builder-portable"})
    private static final class MyGeomContext
    implements ImmutableGeomContext {
        @Nullable
        private final Aesthetics myAesthetics;
        @Nullable
        private final Map<Aes<?>, Function1<Double, Object>> myAestheticMappers;
        @Nullable
        private final DoubleRectangle myAesBounds;
        private final boolean flipped;
        @NotNull
        private final GeomTargetCollector targetCollector;

        public MyGeomContext(@NotNull GeomContextBuilder b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.myAesthetics = b.myAesthetics;
            this.myAestheticMappers = b.myAestheticMappers;
            this.myAesBounds = b.myAesBounds;
            this.flipped = b.myFlipped;
            this.targetCollector = b.myGeomTargetCollector;
        }

        @Nullable
        public final Aesthetics getMyAesthetics() {
            return this.myAesthetics;
        }

        @Nullable
        public final Map<Aes<?>, Function1<Double, Object>> getMyAestheticMappers() {
            return this.myAestheticMappers;
        }

        @Nullable
        public final DoubleRectangle getMyAesBounds() {
            return this.myAesBounds;
        }

        public boolean getFlipped() {
            return this.flipped;
        }

        @NotNull
        public GeomTargetCollector getTargetCollector() {
            return this.targetCollector;
        }

        public double getResolution(@NotNull Aes<Double> aes) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            double resolution = 0.0;
            if (this.myAesthetics != null) {
                resolution = this.myAesthetics.resolution(aes, 0.0);
            }
            if (resolution <= 1.0E-50) {
                resolution = this.getUnitResolution(aes);
            }
            return resolution;
        }

        public double getUnitResolution(@NotNull Aes<Double> aes) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            Map<Aes<?>, Function1<Double, Object>> map2 = this.myAestheticMappers;
            Object object = map2 == null ? null : map2.get(aes);
            Function1 mapper2 = object == null ? Mappers.INSTANCE.getIDENTITY() : object;
            object = mapper2.invoke((Object)1.0);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            return (Double)object;
        }

        @NotNull
        public DoubleRectangle getAesBounds() {
            boolean bl = this.myAesBounds != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "GeomContext: aesthetics bounds are not defined.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return this.myAesBounds;
        }

        @NotNull
        public GeomContext withTargetCollector(@NotNull GeomTargetCollector targetCollector) {
            Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
            return this.with().geomTargetCollector(targetCollector).build();
        }

        @Override
        @NotNull
        public ImmutableGeomContext.Builder with() {
            return new GeomContextBuilder(this, null);
        }
    }
}

