/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.event.Event;
import jetbrains.datalore.base.gcommon.base.Throwables;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.logging.Logger;
import jetbrains.datalore.base.logging.PortableLogging;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.Colors;
import jetbrains.datalore.base.values.SomeFig;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.PlotSvgComponent;
import jetbrains.datalore.plot.builder.PlotTile;
import jetbrains.datalore.plot.builder.TileFrameOfReference;
import jetbrains.datalore.plot.builder.TileFrameOfReferenceProvider;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.event.MouseEventPeer;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.interact.PlotInteractor;
import jetbrains.datalore.plot.builder.interact.PlotTooltipBounds;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.LegendBoxesLayout;
import jetbrains.datalore.plot.builder.layout.LegendBoxesLayoutUtil;
import jetbrains.datalore.plot.builder.layout.LegendsBlockInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayout;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayoutUtil;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.presentation.Defaults;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import jetbrains.datalore.plot.builder.theme.PlotTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgRectElement;
import jetbrains.datalore.vis.svg.event.SvgEventHandler;
import jetbrains.datalore.vis.svg.event.SvgEventSpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 J2\u00020\u0001:\u0001JBY\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J0\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u000202H\u0014J\b\u0010<\u001a\u000202H\u0002J\b\u0010=\u001a\u000202H\u0002J$\u0010>\u001a\u0002022\u0006\u0010?\u001a\u0002072\u0006\u0010@\u001a\u00020A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010C\u001a\u0002022\u0006\u0010D\u001a\u00020E2\u0006\u0010B\u001a\u00020\u0003H\u0002J\u000e\u0010F\u001a\u0002022\u0006\u0010,\u001a\u00020+J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010H\u001a\u00020IH\u0002R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R(\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0005@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u00020+2\u0006\u0010\"\u001a\u00020+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Ljetbrains/datalore/plot/builder/PlotSvgComponent;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "title", "", "layersByTile", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "plotLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "frameOfReferenceProvider", "Ljetbrains/datalore/plot/builder/TileFrameOfReferenceProvider;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "legendBoxInfos", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "interactionsEnabled", "", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "(Ljava/lang/String;Ljava/util/List;Ljetbrains/datalore/plot/builder/layout/PlotLayout;Ljetbrains/datalore/plot/builder/TileFrameOfReferenceProvider;Ljetbrains/datalore/plot/builder/coord/CoordProvider;Ljava/util/List;ZLjetbrains/datalore/plot/builder/theme/Theme;)V", "axisTitleBottom", "axisTitleLeft", "containsLiveMap", "flippedAxis", "getFlippedAxis", "()Z", "getInteractionsEnabled", "value", "Ljetbrains/datalore/plot/builder/interact/PlotInteractor;", "interactor", "getInteractor", "()Ljetbrains/datalore/plot/builder/interact/PlotInteractor;", "setInteractor", "(Ljetbrains/datalore/plot/builder/interact/PlotInteractor;)V", "<set-?>", "Ljetbrains/datalore/base/values/SomeFig;", "liveMapFigures", "getLiveMapFigures$plot_builder_portable", "()Ljava/util/List;", "mouseEventPeer", "Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "getMouseEventPeer", "()Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plotSize", "getPlotSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getTheme", "()Ljetbrains/datalore/plot/builder/theme/Theme;", "addAxisTitle", "", "text", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "overallTileBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "overallGeomBounds", "axisTheme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "buildComponent", "buildPlot", "buildPlotComponents", "drawDebugRect", "r", "color", "Ljetbrains/datalore/base/values/Color;", "message", "onMouseMove", "e", "Ljetbrains/datalore/vis/svg/SvgElement;", "resize", "tileLayers", "tileIndex", "", "Companion", "plot-builder-portable"})
public final class PlotSvgComponent
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<List<GeomLayer>> layersByTile;
    @NotNull
    private PlotLayout plotLayout;
    @NotNull
    private final TileFrameOfReferenceProvider frameOfReferenceProvider;
    @NotNull
    private final CoordProvider coordProvider;
    @NotNull
    private final List<LegendBoxInfo> legendBoxInfos;
    private final boolean interactionsEnabled;
    @NotNull
    private final Theme theme;
    @Nullable
    private final String title;
    private final boolean flippedAxis;
    @NotNull
    private final MouseEventPeer mouseEventPeer;
    @Nullable
    private PlotInteractor interactor;
    @NotNull
    private List<? extends SomeFig> liveMapFigures;
    @NotNull
    private DoubleVector plotSize;
    @Nullable
    private final String axisTitleLeft;
    @Nullable
    private final String axisTitleBottom;
    private final boolean containsLiveMap;
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(PlotSvgComponent.class));
    private static final boolean DEBUG_DRAWING = false;

    /*
     * WARNING - void declaration
     */
    public PlotSvgComponent(@Nullable String title, @NotNull List<? extends List<? extends GeomLayer>> layersByTile, @NotNull PlotLayout plotLayout, @NotNull TileFrameOfReferenceProvider frameOfReferenceProvider, @NotNull CoordProvider coordProvider, @NotNull List<? extends LegendBoxInfo> legendBoxInfos, boolean interactionsEnabled, @NotNull Theme theme) {
        boolean bl;
        boolean bl2;
        block7: {
            void $this$any$iv;
            PlotSvgComponent plotSvgComponent;
            String string;
            Intrinsics.checkNotNullParameter(layersByTile, (String)"layersByTile");
            Intrinsics.checkNotNullParameter((Object)plotLayout, (String)"plotLayout");
            Intrinsics.checkNotNullParameter((Object)frameOfReferenceProvider, (String)"frameOfReferenceProvider");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter(legendBoxInfos, (String)"legendBoxInfos");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            this.layersByTile = layersByTile;
            this.plotLayout = plotLayout;
            this.frameOfReferenceProvider = frameOfReferenceProvider;
            this.coordProvider = coordProvider;
            this.legendBoxInfos = legendBoxInfos;
            this.interactionsEnabled = interactionsEnabled;
            this.theme = theme;
            PlotSvgComponent plotSvgComponent2 = this;
            Object object = title;
            if (object == null) {
                string = null;
            } else {
                String string2;
                void it;
                String string3 = object;
                boolean bl3 = false;
                boolean bl4 = false;
                String string4 = string3;
                plotSvgComponent = plotSvgComponent2;
                boolean bl5 = false;
                if (StringsKt.isBlank((CharSequence)((CharSequence)it))) {
                    string2 = null;
                } else {
                    void var15_19 = it;
                    boolean bl6 = false;
                    string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)var15_19))).toString();
                }
                String string5 = string2;
                plotSvgComponent2 = plotSvgComponent;
                string = string5;
            }
            plotSvgComponent2.title = string;
            this.flippedAxis = this.frameOfReferenceProvider.getFlipAxis();
            this.mouseEventPeer = new MouseEventPeer();
            this.liveMapFigures = CollectionsKt.emptyList();
            this.plotSize = Defaults.INSTANCE.getDEF_PLOT_SIZE();
            this.axisTitleLeft = this.frameOfReferenceProvider.getVAxisLabel();
            this.axisTitleBottom = this.frameOfReferenceProvider.getHAxisLabel();
            object = CollectionsKt.flatten((Iterable)this.layersByTile);
            plotSvgComponent = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GeomLayer p0 = (GeomLayer)element$iv;
                    boolean bl7 = false;
                    if (!p0.isLiveMap()) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
        }
        plotSvgComponent.containsLiveMap = bl = bl2;
    }

    public final boolean getInteractionsEnabled() {
        return this.interactionsEnabled;
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    public final boolean getFlippedAxis() {
        return this.flippedAxis;
    }

    @NotNull
    public final MouseEventPeer getMouseEventPeer() {
        return this.mouseEventPeer;
    }

    @Nullable
    public final PlotInteractor getInteractor() {
        return this.interactor;
    }

    public final void setInteractor(@Nullable PlotInteractor value) {
        boolean bl = this.interactor == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Can be intialize only once.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.interactor = value;
    }

    @NotNull
    public final List<SomeFig> getLiveMapFigures$plot_builder_portable() {
        return this.liveMapFigures;
    }

    @NotNull
    public final DoubleVector getPlotSize() {
        return this.plotSize;
    }

    private final List<GeomLayer> tileLayers(int tileIndex) {
        return this.layersByTile.get(tileIndex);
    }

    protected void buildComponent() {
        try {
            this.buildPlot();
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e, (Function0)buildComponent.1.INSTANCE);
            Throwable rootCause = Throwables.INSTANCE.getRootCause((Throwable)e);
            String[] stringArray = new String[]{Intrinsics.stringPlus((String)"Error building plot: ", (Object)Reflection.getOrCreateKotlinClass(rootCause.getClass()).getSimpleName()), rootCause.getMessage() != null ? '\'' + rootCause.getMessage() + '\'' : "<no message>"};
            String[] messages = stringArray;
            double y = this.plotSize.getY() / (double)2 - (double)8;
            String[] stringArray2 = messages;
            int n = 0;
            int n2 = stringArray2.length;
            while (n < n2) {
                String s = stringArray2[n];
                ++n;
                TextLabel errorLabel = new TextLabel(s);
                errorLabel.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
                errorLabel.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
                errorLabel.moveTo(this.plotSize.getX() / (double)2, y);
                this.getRootGroup().children().add((Object)errorLabel.getRootGroup());
                y += 16.0;
            }
        }
    }

    private final void buildPlot() {
        this.getRootGroup().addClass("plt-plot");
        this.buildPlotComponents();
        this.reg(new Registration(this){
            final /* synthetic */ PlotSvgComponent this$0;
            {
                this.this$0 = $receiver;
            }

            protected void doRemove() {
                PlotInteractor plotInteractor = this.this$0.getInteractor();
                if (plotInteractor != null) {
                    plotInteractor.dispose();
                }
                PlotSvgComponent.access$setLiveMapFigures$p(this.this$0, CollectionsKt.emptyList());
            }
        });
    }

    public final void resize(@NotNull DoubleVector plotSize) {
        Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
        if (plotSize.getX() <= 0.0 || plotSize.getY() <= 0.0) {
            return;
        }
        if (Intrinsics.areEqual((Object)plotSize, (Object)this.plotSize)) {
            return;
        }
        this.plotSize = plotSize;
        this.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void buildPlotComponents() {
        DoubleRectangle overallRect = new DoubleRectangle(DoubleVector.Companion.getZERO(), this.plotSize);
        PlotTheme plotTheme = this.theme.plot();
        if (plotTheme.showBackground()) {
            void $this$buildPlotComponents_u24lambda_u2d2;
            SvgRectElement svgRectElement = new SvgRectElement(overallRect);
            boolean bl = false;
            boolean bl2 = false;
            SvgRectElement svgRectElement2 = svgRectElement;
            PlotSvgComponent plotSvgComponent = this;
            boolean bl3 = false;
            $this$buildPlotComponents_u24lambda_u2d2.strokeColor().set((Object)plotTheme.backgroundColor());
            $this$buildPlotComponents_u24lambda_u2d2.strokeWidth().set((Object)plotTheme.backgroundStrokeWidth());
            $this$buildPlotComponents_u24lambda_u2d2.fillColor().set((Object)plotTheme.backgroundFill());
            if (this.containsLiveMap) {
                $this$buildPlotComponents_u24lambda_u2d2.fillOpacity().set((Object)0.0);
            } else if (Colors.INSTANCE.solid(plotTheme.backgroundFill())) {
                $this$buildPlotComponents_u24lambda_u2d2.fillOpacity().set((Object)0.99);
            }
            Unit unit = Unit.INSTANCE;
            plotSvgComponent.add((SvgNode)svgRectElement);
        }
        DoubleRectangle entirePlot = this.containsLiveMap ? PlotLayoutUtil.INSTANCE.liveMapBounds(overallRect) : overallRect;
        LegendTheme legendTheme = this.theme.legend();
        LegendsBlockInfo legendsBlockInfo = LegendBoxesLayoutUtil.INSTANCE.arrangeLegendBoxes(this.legendBoxInfos, legendTheme);
        boolean axisEnabled = !this.containsLiveMap;
        DoubleVector plotInnerSizeAvailable = PlotLayoutUtil.INSTANCE.subtractTitlesAndLegends(entirePlot.getDimension(), this.title, this.axisTitleLeft, this.axisTitleBottom, axisEnabled, legendsBlockInfo, this.theme);
        PlotLayoutInfo plotInfo = this.plotLayout.doLayout(plotInnerSizeAvailable, this.coordProvider);
        if (plotInfo.getTiles().isEmpty()) {
            return;
        }
        DoubleVector plotInnerSize = plotInfo.getSize();
        DoubleVector plotOuterSize = PlotLayoutUtil.INSTANCE.addTitlesAndLegends(plotInnerSize, this.title, this.axisTitleLeft, this.axisTitleBottom, axisEnabled, legendsBlockInfo, this.theme);
        PlotSvgComponent plotSvgComponent = this;
        boolean bl = false;
        boolean bl4 = false;
        PlotSvgComponent it22 = plotSvgComponent;
        boolean bl5 = false;
        DoubleVector delta = overallRect.getCenter().subtract(new DoubleRectangle(overallRect.getOrigin(), plotOuterSize).getCenter());
        double d = 0.0;
        double d2 = delta.getX();
        boolean bl6 = false;
        double d3 = Math.max(d, d2);
        d = 0.0;
        d2 = delta.getY();
        bl6 = false;
        DoubleVector deltaApplied = new DoubleVector(d3, Math.max(d, d2));
        DoubleVector plotOuterOrigin = overallRect.getOrigin().add(deltaApplied);
        DoubleRectangle plotOuterBounds = new DoubleRectangle(plotOuterOrigin, plotOuterSize);
        PlotSvgComponent plotSvgComponent2 = this;
        bl4 = false;
        boolean it22 = false;
        PlotSvgComponent it = plotSvgComponent2;
        boolean bl7 = false;
        DoubleVector titleSizeDelta = PlotLayoutUtil.INSTANCE.titleSizeDelta(this.title);
        DoubleRectangle plotOuterBoundsWithoutTitle = new DoubleRectangle(plotOuterBounds.getOrigin().add(titleSizeDelta), plotOuterBounds.getDimension().subtract(titleSizeDelta));
        DoubleVector plotInnerOrigin = plotOuterBoundsWithoutTitle.getOrigin().add(PlotLayoutUtil.INSTANCE.legendBlockLeftTopDelta(legendsBlockInfo, legendTheme)).add(PlotLayoutUtil.INSTANCE.axisTitleSizeDelta(this.axisTitleLeft, null, axisEnabled));
        DoubleRectangle geomAreaBounds = PlotLayoutUtil.INSTANCE.overallGeomBounds(plotInfo).add(plotInnerOrigin);
        DoubleVector tilesOrigin = plotInnerOrigin;
        for (TileLayoutInfo tileLayoutInfo : plotInfo.getTiles()) {
            int tileLayersIndex = tileLayoutInfo.getTrueIndex();
            TileFrameOfReference frameOfReference = this.frameOfReferenceProvider.createFrameOfReference(tileLayoutInfo, this.coordProvider, false);
            List<GeomLayer> tileLayers = this.tileLayers(tileLayersIndex);
            PlotTile tile2 = new PlotTile(tileLayers, tilesOrigin, tileLayoutInfo, this.theme, frameOfReference);
            DoubleVector plotOriginAbsolute = tilesOrigin.add(tileLayoutInfo.getPlotOrigin());
            tile2.moveTo(plotOriginAbsolute);
            this.add(tile2);
            deltaApplied = tile2.getLiveMapFigure();
            if (deltaApplied != null) {
                plotOuterOrigin = deltaApplied;
                boolean bl8 = false;
                boolean bl9 = false;
                DoubleVector $this$buildPlotComponents_u24lambda_u2d5 = plotOuterOrigin;
                boolean bl10 = false;
                this.liveMapFigures = CollectionsKt.plus((Collection)this.getLiveMapFigures$plot_builder_portable(), (Iterable)CollectionsKt.listOf((Object)$this$buildPlotComponents_u24lambda_u2d5));
            }
            DoubleRectangle geomBoundsAbsolute = tileLayoutInfo.getGeomBounds().add(plotOriginAbsolute);
            PlotTooltipBounds tooltipBounds = new PlotTooltipBounds(geomBoundsAbsolute, tile2.getGeomDrawingBounds().add(geomBoundsAbsolute.getOrigin()));
            PlotInteractor plotInteractor = this.interactor;
            if (plotInteractor == null) continue;
            plotInteractor.onTileAdded(geomBoundsAbsolute, tooltipBounds, tile2.getTargetLocators());
        }
        if (this.title != null) {
            TextLabel titleLabel = new TextLabel(this.title);
            titleLabel.addClassName("plt-plot-title");
            titleLabel.textColor().set((Object)this.theme.plot().titleColor());
            titleLabel.setHorizontalAnchor(TextLabel.HorizontalAnchor.LEFT);
            titleLabel.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
            DoubleVector titleSize = PlotLayoutUtil.INSTANCE.titleDimensions(this.title);
            DoubleRectangle titleBounds = new DoubleRectangle(geomAreaBounds.getLeft(), plotOuterBounds.getTop(), titleSize.getX(), titleSize.getY());
            titleLabel.moveTo(new DoubleVector(titleBounds.getLeft(), titleBounds.getCenter().getY()));
            this.add((SvgComponent)titleLabel);
        }
        DoubleRectangle overallTileBounds = PlotLayoutUtil.INSTANCE.overallTileBounds(plotInfo).add(plotInnerOrigin);
        if (axisEnabled) {
            if (this.axisTitleLeft != null) {
                this.addAxisTitle(this.axisTitleLeft, Orientation.LEFT, overallTileBounds, geomAreaBounds, this.theme.axisY(this.flippedAxis));
            }
            if (this.axisTitleBottom != null) {
                this.addAxisTitle(this.axisTitleBottom, Orientation.BOTTOM, overallTileBounds, geomAreaBounds, this.theme.axisX(this.flippedAxis));
            }
        }
        if (!legendTheme.position().isHidden()) {
            LegendsBlockInfo legendsBlockInfoLayouted = new LegendBoxesLayout(plotOuterBoundsWithoutTitle, geomAreaBounds, legendTheme).doLayout(legendsBlockInfo);
            for (LegendBoxesLayout.BoxWithLocation boxWithLocation : legendsBlockInfoLayouted.getBoxWithLocationList()) {
                LegendBox legendBox = boxWithLocation.getLegendBox().createLegendBox();
                legendBox.moveTo(boxWithLocation.getLocation());
                this.add(legendBox);
            }
        }
    }

    private final void addAxisTitle(String text, Orientation orientation, DoubleRectangle overallTileBounds, DoubleRectangle overallGeomBounds, AxisTheme axisTheme) {
        DoubleVector doubleVector;
        double d;
        TextLabel.VerticalAnchor verticalAnchor;
        DoubleRectangle doubleRectangle;
        Orientation orientation2 = orientation;
        int n = WhenMappings.$EnumSwitchMapping$0[orientation2.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                doubleRectangle = new DoubleRectangle(overallTileBounds.getLeft(), overallGeomBounds.getTop(), overallTileBounds.getWidth(), overallGeomBounds.getHeight());
                break;
            }
            case 3: 
            case 4: {
                doubleRectangle = new DoubleRectangle(overallGeomBounds.getLeft(), overallTileBounds.getTop(), overallGeomBounds.getWidth(), overallTileBounds.getHeight());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleRectangle referenceRect = doubleRectangle;
        TextLabel.HorizontalAnchor horizontalAnchor = TextLabel.HorizontalAnchor.MIDDLE;
        Orientation orientation3 = orientation;
        int n2 = WhenMappings.$EnumSwitchMapping$0[orientation3.ordinal()];
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                verticalAnchor = TextLabel.VerticalAnchor.BOTTOM;
                break;
            }
            case 4: {
                verticalAnchor = TextLabel.VerticalAnchor.TOP;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        TextLabel.VerticalAnchor verticalAnchor2 = verticalAnchor;
        Orientation orientation4 = orientation;
        int n3 = WhenMappings.$EnumSwitchMapping$0[orientation4.ordinal()];
        switch (n3) {
            case 1: {
                d = -90.0;
                break;
            }
            case 2: {
                d = -90.0;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        double rotation = d;
        Orientation orientation5 = orientation;
        int n4 = WhenMappings.$EnumSwitchMapping$0[orientation5.ordinal()];
        switch (n4) {
            case 1: {
                doubleVector = new DoubleVector(referenceRect.getLeft() - 6.0, referenceRect.getCenter().getY());
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(referenceRect.getRight() + 4.0, referenceRect.getCenter().getY());
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(referenceRect.getCenter().getX(), referenceRect.getTop() - 4.0);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(referenceRect.getCenter().getX(), referenceRect.getBottom() + 4.0);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleVector titleLocation = doubleVector;
        TextLabel titleLabel = new TextLabel(text);
        titleLabel.setHorizontalAnchor(horizontalAnchor);
        titleLabel.setVerticalAnchor(verticalAnchor2);
        titleLabel.textColor().set((Object)axisTheme.titleColor());
        titleLabel.moveTo(titleLocation);
        titleLabel.rotate(rotation);
        SvgGElement titleElement = titleLabel.getRootGroup();
        titleElement.addClass("plt-axis-title");
        SvgGElement parent = new SvgGElement();
        parent.addClass("plt-axis");
        parent.children().add((Object)titleElement);
        this.add((SvgNode)parent);
    }

    private final void drawDebugRect(DoubleRectangle r, Color color, String message) {
        SvgRectElement rect2 = new SvgRectElement(r);
        rect2.strokeColor().set((Object)color);
        rect2.strokeWidth().set((Object)1.0);
        rect2.fillOpacity().set((Object)0.0);
        String string = message;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String $this$drawDebugRect_u24lambda_u2d6 = string2;
            boolean bl3 = false;
            this.onMouseMove((SvgElement)rect2, message + ": " + r);
        }
        this.add((SvgNode)rect2);
    }

    static /* synthetic */ void drawDebugRect$default(PlotSvgComponent plotSvgComponent, DoubleRectangle doubleRectangle, Color color, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        plotSvgComponent.drawDebugRect(doubleRectangle, color, string);
    }

    private final void onMouseMove(SvgElement e, String message) {
        e.addEventHandler(SvgEventSpec.MOUSE_MOVE, (SvgEventHandler)new SvgEventHandler<Event>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
            }

            public void handle(@NotNull SvgNode node, @NotNull Event e) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.$message;
                boolean bl = false;
                System.out.println((Object)string);
            }
        });
    }

    public static final /* synthetic */ void access$setLiveMapFigures$p(PlotSvgComponent $this, List list) {
        $this.liveMapFigures = list;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/builder/PlotSvgComponent$Companion;", "", "()V", "DEBUG_DRAWING", "", "LOG", "Ljetbrains/datalore/base/logging/Logger;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            nArray[Orientation.LEFT.ordinal()] = 1;
            nArray[Orientation.RIGHT.ordinal()] = 2;
            nArray[Orientation.TOP.ordinal()] = 3;
            nArray[Orientation.BOTTOM.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

