/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter;

import com.blazemeter.jmeter.RandomCSVDataSetConfig;
import com.blazemeter.jmeter.TestRandomCSVAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.BrowseAction;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;

public class RandomCSVDataSetConfigGui
extends AbstractConfigGui {
    public static final String WIKIPAGE = "RandomCSVDataSetConfig";
    private JTextField filenameField;
    private JTextField fileEncodingField;
    private JTextField variableNamesField;
    private JTextField delimiterField;
    private JCheckBox isRandomOrderCheckBox;
    private JCheckBox isIgnoreFirstLineCheckBox;
    private JCheckBox isRewindOnTheEndCheckBox;
    private JCheckBox isIndependentListCheckBox;
    private JTextArea checkArea;

    public RandomCSVDataSetConfigGui() {
        this.initGui();
        this.initGuiValues();
    }

    private void initGui() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        Container topPanel = this.makeTitlePanel();
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)topPanel, (String)WIKIPAGE), "North");
        this.add(topPanel, "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        int row = 0;
        this.addToPanel(mainPanel, labelConstraints, 0, row, new JLabel("Filename: ", 4));
        this.filenameField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.filenameField);
        JButton browseButton = new JButton("Browse...");
        this.addToPanel(mainPanel, labelConstraints, 2, row, browseButton);
        GuiBuilderHelper.strechItemToComponent((JComponent)this.filenameField, (JComponent)browseButton);
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        browseButton.addActionListener((ActionListener)new BrowseAction(this.filenameField, false));
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("File encoding: ", 4));
        this.fileEncodingField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.fileEncodingField);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Delimiter (use '\\t' for tab): ", 4));
        this.delimiterField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.delimiterField);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Variable names (comma-delimited): ", 4));
        this.variableNamesField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, row, this.variableNamesField);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Random order: ", 4));
        this.isRandomOrderCheckBox = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, row, this.isRandomOrderCheckBox);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Rewind on end of list: ", 4));
        this.isRewindOnTheEndCheckBox = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, row, this.isRewindOnTheEndCheckBox);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("First line is CSV header: ", 4));
        this.isIgnoreFirstLineCheckBox = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, row, this.isIgnoreFirstLineCheckBox);
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, new JLabel("Independent list per thread: ", 4));
        this.isIndependentListCheckBox = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, row, this.isIndependentListCheckBox);
        editConstraints.insets = new Insets(4, 0, 0, 0);
        labelConstraints.insets = new Insets(4, 0, 0, 2);
        JButton checkButton = new JButton("Test CSV Reading");
        this.addToPanel(mainPanel, labelConstraints, 0, ++row, checkButton);
        labelConstraints.insets = new Insets(4, 0, 0, 0);
        this.checkArea = new JTextArea();
        this.addToPanel(mainPanel, editConstraints, 1, row, GuiBuilderHelper.getTextAreaScrollPaneContainer((JTextArea)this.checkArea, (int)10));
        checkButton.addActionListener(new TestRandomCSVAction(this));
        this.checkArea.setEditable(false);
        this.checkArea.setOpaque(false);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void initGuiValues() {
        this.filenameField.setText("");
        this.fileEncodingField.setText("UTF-8");
        this.delimiterField.setText(",");
        this.variableNamesField.setText("");
        this.isRandomOrderCheckBox.setSelected(true);
        this.isIgnoreFirstLineCheckBox.setSelected(false);
        this.isRewindOnTheEndCheckBox.setSelected(true);
        this.isIndependentListCheckBox.setSelected(false);
        this.checkArea.setText("");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    public String getLabelResource() {
        return "random_csv_data_set_config";
    }

    public String getStaticLabel() {
        return "bzm - Random CSV Data Set Config";
    }

    public TestElement createTestElement() {
        RandomCSVDataSetConfig element = new RandomCSVDataSetConfig();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        if (element instanceof RandomCSVDataSetConfig) {
            RandomCSVDataSetConfig randomCSV = (RandomCSVDataSetConfig)element;
            randomCSV.setFilename(this.filenameField.getText());
            randomCSV.setFileEncoding(this.fileEncodingField.getText());
            randomCSV.setDelimiter(this.delimiterField.getText());
            randomCSV.setVariableNames(this.variableNamesField.getText());
            randomCSV.setRandomOrder(this.isRandomOrderCheckBox.isSelected());
            randomCSV.setIgnoreFirstLine(this.isIgnoreFirstLineCheckBox.isSelected());
            randomCSV.setRewindOnTheEndOfList(this.isRewindOnTheEndCheckBox.isSelected());
            randomCSV.setIndependentListPerThread(this.isIndependentListCheckBox.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof RandomCSVDataSetConfig) {
            RandomCSVDataSetConfig randomCSV = (RandomCSVDataSetConfig)element;
            this.filenameField.setText(randomCSV.getFilename());
            this.fileEncodingField.setText(randomCSV.getFileEncoding());
            this.delimiterField.setText(randomCSV.getDelimiter());
            this.variableNamesField.setText(randomCSV.getVariableNames());
            this.isRandomOrderCheckBox.setSelected(randomCSV.isRandomOrder());
            this.isIgnoreFirstLineCheckBox.setSelected(randomCSV.isIgnoreFirstLine());
            this.isRewindOnTheEndCheckBox.setSelected(randomCSV.isRewindOnTheEndOfList());
            this.isIndependentListCheckBox.setSelected(randomCSV.isIndependentListPerThread());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.initGuiValues();
    }

    public JTextArea getCheckArea() {
        return this.checkArea;
    }
}

