/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.csv;

import com.blazemeter.csv.BufferedReaderExt;
import com.blazemeter.csv.RandomBufferedReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class RandomCSVReader {
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    private File file;
    private String encoding;
    private char delim;
    private boolean randomOrder;
    private boolean isRewindOnEndOfList;
    private ArrayList<Integer> offsets;
    private int curPos = 0;
    private final ThreadLocal<RandomBufferedReader> rbr = new ThreadLocal<RandomBufferedReader>(){

        @Override
        protected RandomBufferedReader initialValue() {
            try {
                return new RandomBufferedReader(RandomCSVReader.this.createReader(), new RandomAccessFile(RandomCSVReader.this.file, "r"), RandomCSVReader.this.encoding);
            }
            catch (IOException e) {
                LOGGER.error("Cannot create RandomBufferedReader", (Throwable)e);
                throw new RuntimeException("Cannot create RandomBufferedReader", e);
            }
        }
    };
    private Random random;
    private BufferedReader consistentReader;
    private String[] header;
    private boolean isSkipFirstLine;

    public RandomCSVReader(String filename, String encoding, String delim, boolean randomOrder, boolean hasVariableNames, boolean firstLineIsHeader, boolean isRewindOnEndOfList) {
        File f = new File(filename);
        this.file = f.isAbsolute() || f.exists() ? f : new File(FileServer.getFileServer().getBaseDir(), filename);
        this.encoding = encoding;
        this.delim = this.checkDelimiter(delim).charAt(0);
        this.isSkipFirstLine = firstLineIsHeader || !hasVariableNames;
        this.randomOrder = randomOrder;
        this.isRewindOnEndOfList = isRewindOnEndOfList;
        try {
            this.initOffsets();
            if (randomOrder) {
                this.initRandom();
            } else {
                this.initConsistentReader();
            }
            this.initHeader();
        }
        catch (IOException ex) {
            LOGGER.error("Cannot initialize RandomCSVReader, because of error: ", (Throwable)ex);
            throw new RuntimeException("Cannot initialize RandomCSVReader, because of error: " + ex.getMessage(), ex);
        }
    }

    private String checkDelimiter(String delim) {
        if ("\\t".equals(delim)) {
            return "\t";
        }
        if (delim.isEmpty()) {
            LOGGER.debug("Empty delimiter, will use ','");
            return ",";
        }
        return delim;
    }

    private void initHeader() {
        try (BufferedReader reader = new BufferedReader(this.createReader());){
            this.header = CSVSaveService.csvReadFile((BufferedReader)reader, (char)this.delim);
        }
        catch (IOException ex) {
            LOGGER.error("Cannot read CSV header ", (Throwable)ex);
            throw new RuntimeException("Cannot read CSV header: " + ex.getMessage(), ex);
        }
    }

    private void initConsistentReader() throws IOException {
        this.consistentReader = new BufferedReader(this.createReader());
        if (this.isSkipFirstLine && !this.offsets.isEmpty()) {
            this.consistentReader.skip(this.offsets.get(0).intValue());
        }
    }

    public void closeConsistentReader() throws IOException {
        this.consistentReader.close();
    }

    public boolean hasNextRecord() {
        if (this.curPos >= this.offsets.size() && this.isRewindOnEndOfList) {
            this.reInitialize();
            LOGGER.debug("Reset cursor position");
            this.curPos = 0;
            return true;
        }
        return this.curPos < this.offsets.size();
    }

    private void reInitialize() {
        if (this.randomOrder) {
            this.initRandom();
        } else {
            try {
                this.closeConsistentReader();
                this.initConsistentReader();
            }
            catch (IOException ex) {
                LOGGER.error("Cannot reInitialize consistent reader ", (Throwable)ex);
                throw new RuntimeException("Cannot reInitialize consistent reader: " + ex.getMessage(), ex);
            }
        }
    }

    public String[] getHeader() {
        return this.header;
    }

    public String[] readNextLine() {
        try {
            ++this.curPos;
            return CSVSaveService.csvReadFile((BufferedReader)this.consistentReader, (char)this.delim);
        }
        catch (IOException ex) {
            LOGGER.error("Cannot get next record from csv file: ", (Throwable)ex);
            throw new RuntimeException("Cannot get next record from csv file: " + ex.getMessage(), ex);
        }
    }

    public long getNextLineAddr() {
        int pos = this.getRandomPos();
        this.swap(this.curPos + pos);
        long lineAddr = this.offsets.get(this.curPos).intValue();
        ++this.curPos;
        return lineAddr;
    }

    private void swap(int pos) {
        Integer tmp = this.offsets.get(this.curPos);
        this.offsets.set(this.curPos, this.offsets.get(pos));
        this.offsets.set(pos, tmp);
    }

    public String[] readLineWithSeek(long pos) {
        try {
            this.rbr.get().seek(pos);
            return CSVSaveService.csvReadFile((BufferedReader)this.rbr.get(), (char)this.delim);
        }
        catch (ClosedChannelException ex) {
            LOGGER.warn("The channel has been closed");
            return new String[0];
        }
        catch (IOException ex) {
            LOGGER.error("Cannot get next record from csv file: ", (Throwable)ex);
            throw new RuntimeException("Cannot get next record from csv file: " + ex.getMessage(), ex);
        }
    }

    private int getRandomPos() {
        return this.random.nextInt(this.offsets.size() - this.curPos);
    }

    private void initRandom() {
        this.random = new Random(System.currentTimeMillis());
    }

    private void initOffsets() throws IOException {
        this.offsets = new ArrayList();
        if (!this.isSkipFirstLine) {
            this.offsets.add(0);
        }
        LOGGER.info("Start reading the file: " + this.file.getAbsolutePath());
        try (BufferedReaderExt reader = new BufferedReaderExt(this.createReader(), this.encoding);){
            long fileSize = this.file.length();
            while ((long)reader.getPos() < fileSize) {
                CSVSaveService.csvReadFile((BufferedReader)reader, (char)this.delim);
                if ((long)reader.getPos() >= fileSize) continue;
                this.offsets.add(reader.getPos());
            }
        }
        LOGGER.info("Reading finished. Found " + this.offsets.size() + " records in your csv file");
    }

    private Reader createReader() throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding);
    }

    public void close() {
        try {
            if (this.randomOrder) {
                this.rbr.get().close();
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to close readers");
        }
    }
}

