/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import java.util.Set;
import jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator;
import jetbrains.datalore.base.spatial.GeoRectangle;
import jetbrains.datalore.base.spatial.GeographicKt;
import jetbrains.datalore.base.spatial.LonLat;
import jetbrains.datalore.base.spatial.QuadKey;
import jetbrains.datalore.base.spatial.QuadsKt;
import jetbrains.datalore.base.typedGeometry.FunctionsKt;
import jetbrains.datalore.base.typedGeometry.Rect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u001a\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012\u001a\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b*\u0016\u0010\u0017\"\b\u0012\u0004\u0012\u00020\u00020\u00182\b\u0012\u0004\u0012\u00020\u00020\u0018\u00a8\u0006\u0019"}, d2={"BBOX_CALCULATOR", "Ljetbrains/datalore/base/spatial/GeoBoundingBoxCalculator;", "Ljetbrains/datalore/base/spatial/LonLat;", "getBBOX_CALCULATOR", "()Ljetbrains/datalore/base/spatial/GeoBoundingBoxCalculator;", "EARTH_RECT", "Ljetbrains/datalore/base/typedGeometry/Rect;", "getEARTH_RECT", "()Ljetbrains/datalore/base/typedGeometry/Rect;", "calculateQuadKeys", "", "Ljetbrains/datalore/base/spatial/QuadKey;", "rect", "zoom", "", "convertToGeoRectangle", "Ljetbrains/datalore/base/spatial/GeoRectangle;", "limitLat", "", "lat", "limitLon", "lon", "normalizeLon", "LonLatPoint", "Ljetbrains/datalore/base/typedGeometry/Vec;", "base-portable"})
public final class GeographicKt {
    @NotNull
    private static final Rect<LonLat> EARTH_RECT = new Rect(-180.0, -90.0, 360.0, 180.0);
    @NotNull
    private static final GeoBoundingBoxCalculator<LonLat> BBOX_CALCULATOR = new GeoBoundingBoxCalculator<LonLat>(EARTH_RECT, true, false);

    @NotNull
    public static final Rect<LonLat> getEARTH_RECT() {
        return EARTH_RECT;
    }

    @NotNull
    public static final GeoBoundingBoxCalculator<LonLat> getBBOX_CALCULATOR() {
        return BBOX_CALCULATOR;
    }

    public static final double limitLon(double lon) {
        double d = -180.0;
        double d2 = 180.0;
        boolean bl = false;
        d2 = Math.min(lon, d2);
        bl = false;
        return Math.max(d, d2);
    }

    public static final double limitLat(double lat) {
        double d = -90.0;
        double d2 = 90.0;
        boolean bl = false;
        d2 = Math.min(lat, d2);
        bl = false;
        return Math.max(d, d2);
    }

    public static final double normalizeLon(double lon) {
        double result = lon - (double)((int)(lon / 360.0)) * 360.0;
        if (result > 180.0) {
            result -= 360.0;
        }
        if (result < -180.0) {
            result += 360.0;
        }
        return result;
    }

    @NotNull
    public static final GeoRectangle convertToGeoRectangle(@NotNull Rect<LonLat> rect) {
        Intrinsics.checkNotNullParameter(rect, (String)"rect");
        double left = 0.0;
        double right = 0.0;
        if (FunctionsKt.getWidth(rect) < FunctionsKt.getWidth(EARTH_RECT)) {
            left = GeographicKt.normalizeLon(FunctionsKt.getLeft(rect));
            right = GeographicKt.normalizeLon(FunctionsKt.getRight(rect));
        } else {
            left = FunctionsKt.getLeft(EARTH_RECT);
            right = FunctionsKt.getRight(EARTH_RECT);
        }
        return new GeoRectangle(left, GeographicKt.limitLat(FunctionsKt.getTop(rect)), right, GeographicKt.limitLat(FunctionsKt.getBottom(rect)));
    }

    @NotNull
    public static final Set<QuadKey<LonLat>> calculateQuadKeys(@NotNull Rect<LonLat> rect, int zoom) {
        Intrinsics.checkNotNullParameter(rect, (String)"rect");
        Rect flippedRect = new Rect(FunctionsKt.getLeft(rect), -FunctionsKt.getBottom(rect), FunctionsKt.getWidth(rect), FunctionsKt.getHeight(rect));
        return QuadsKt.calculateQuadKeys(EARTH_RECT, flippedRect, zoom, calculateQuadKeys.1.INSTANCE);
    }
}

