/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads.arrivals;

import com.blazemeter.jmeter.threads.arrivals.ArrivalsThreadStarter;
import com.blazemeter.jmeter.threads.arrivals.FreeFormArrivalsThreadGroup;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeFormArrivalsThreadStarter
extends ArrivalsThreadStarter {
    private static final Logger log = LoggerFactory.getLogger(FreeFormArrivalsThreadStarter.class);
    private final FreeFormArrivalsThreadGroup arrivalsTG;

    public FreeFormArrivalsThreadStarter(int groupIndex, ListenerNotifier listenerNotifier, ListedHashTree listedHashTree, StandardJMeterEngine standardJMeterEngine, FreeFormArrivalsThreadGroup owner) {
        super(groupIndex, listenerNotifier, listedHashTree, standardJMeterEngine, owner);
        this.arrivalsTG = owner;
    }

    @Override
    protected double getCurrentRate() {
        CollectionProperty data = this.arrivalsTG.getData();
        PropertyIterator it = data.iterator();
        int offset = 0;
        while (it.hasNext()) {
            CollectionProperty record = (CollectionProperty)it.next();
            double chunkLen = record.get(2).getDoubleValue() * this.arrivalsTG.getUnitFactor();
            double timeProgress = this.rollingTime / 1000.0 - this.startTime;
            double chunkProgress = (timeProgress - (double)offset) / chunkLen;
            if (!(timeProgress <= (double)(offset = (int)((double)offset + chunkLen)))) continue;
            double chunkStart = record.get(0).getDoubleValue() / this.arrivalsTG.getUnitFactor();
            double chunkEnd = record.get(1).getDoubleValue() / this.arrivalsTG.getUnitFactor();
            double chunkHeight = chunkEnd - chunkStart;
            return chunkStart + chunkProgress * chunkHeight;
        }
        log.info("Got no further schedule, can stop now");
        return -1.0;
    }
}

