/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale;

import java.util.List;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.Transform;
import jetbrains.datalore.plot.base.scale.AbstractScale;
import jetbrains.datalore.plot.base.scale.BreaksGenerator;
import jetbrains.datalore.plot.base.scale.transform.Transforms;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001$B/\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0015\b\u0012\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Ljetbrains/datalore/plot/base/scale/ContinuousScale;", "T", "Ljetbrains/datalore/plot/base/scale/AbstractScale;", "", "name", "", "mapper", "Lkotlin/Function1;", "continuousOutput", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Z)V", "b", "Ljetbrains/datalore/plot/base/scale/ContinuousScale$MyBuilder;", "(Ljetbrains/datalore/plot/base/scale/ContinuousScale$MyBuilder;)V", "continuousDomainLimits", "Lkotlin/Pair;", "getContinuousDomainLimits", "()Lkotlin/Pair;", "continuousTransform", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "customBreaksGenerator", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "isContinuous", "()Z", "isContinuousDomain", "transform", "Ljetbrains/datalore/plot/base/Transform;", "getTransform", "()Ljetbrains/datalore/plot/base/Transform;", "getBreaksGenerator", "hasDomainLimits", "isInDomainLimits", "v", "", "with", "Ljetbrains/datalore/plot/base/Scale$Builder;", "MyBuilder", "plot-base-portable"})
public final class ContinuousScale<T>
extends AbstractScale<Double, T> {
    @NotNull
    private final ContinuousTransform continuousTransform;
    @Nullable
    private final BreaksGenerator customBreaksGenerator;
    private final boolean isContinuous;
    private final boolean isContinuousDomain;
    @NotNull
    private final Pair<Double, Double> continuousDomainLimits;

    @Override
    public boolean isContinuous() {
        return this.isContinuous;
    }

    @Override
    public boolean isContinuousDomain() {
        return this.isContinuousDomain;
    }

    @NotNull
    public final Pair<Double, Double> getContinuousDomainLimits() {
        return this.continuousDomainLimits;
    }

    @Override
    @NotNull
    public Transform getTransform() {
        return this.continuousTransform;
    }

    public ContinuousScale(@NotNull String name, @NotNull Function1<? super Double, ? extends T> mapper, boolean continuousOutput) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super(name, mapper, null, 4, null);
        this.isContinuousDomain = true;
        this.isContinuous = continuousOutput;
        this.continuousDomainLimits = new Pair((Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY);
        this.continuousTransform = Transforms.INSTANCE.getIDENTITY();
        this.customBreaksGenerator = null;
        this.setMultiplicativeExpand(0.05);
        this.setAdditiveExpand(0.0);
    }

    private ContinuousScale(MyBuilder<T> b) {
        super((AbstractScale.AbstractBuilder)b);
        double d;
        double lower;
        double d2;
        this.isContinuousDomain = true;
        this.continuousTransform = b.getMyContinuousTransform();
        this.customBreaksGenerator = b.getMyCustomBreaksGenerator();
        this.isContinuous = b.getMyContinuousOutput();
        if (SeriesUtil.INSTANCE.isFinite(b.getMyLowerLimit())) {
            Double d3 = b.getMyLowerLimit();
            Intrinsics.checkNotNull((Object)d3);
            d2 = d3;
        } else {
            d2 = lower = Double.NEGATIVE_INFINITY;
        }
        if (SeriesUtil.INSTANCE.isFinite(b.getMyUpperLimit())) {
            Double d4 = b.getMyUpperLimit();
            Intrinsics.checkNotNull((Object)d4);
            d = d4;
        } else {
            d = Double.POSITIVE_INFINITY;
        }
        double upper = d;
        boolean bl = false;
        bl = false;
        this.continuousDomainLimits = new Pair((Object)Math.min(lower, upper), (Object)Math.max(lower, upper));
    }

    @Override
    @NotNull
    public BreaksGenerator getBreaksGenerator() {
        return this.customBreaksGenerator != null ? (BreaksGenerator)new Transforms.BreaksGeneratorForTransformedDomain(this.continuousTransform, this.customBreaksGenerator) : Transforms.INSTANCE.createBreaksGeneratorForTransformedDomain(this.continuousTransform, this.getLabelFormatter());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInDomainLimits(@NotNull Object v) {
        double d;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (!(v instanceof Number)) return false;
        double d2 = d = ((Number)v).doubleValue();
        boolean bl = false;
        double d3 = d2;
        boolean bl2 = false;
        if (Double.isInfinite(d3)) return false;
        d3 = d2;
        bl2 = false;
        if (Double.isNaN(d3)) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        if (!(d >= ((Number)this.continuousDomainLimits.getFirst()).doubleValue())) return false;
        if (!(d <= ((Number)this.continuousDomainLimits.getSecond()).doubleValue())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasDomainLimits() {
        double d = ((Number)this.continuousDomainLimits.getFirst()).doubleValue();
        boolean bl = false;
        double d2 = d;
        boolean bl2 = false;
        if (!Double.isInfinite(d2)) {
            d2 = d;
            bl2 = false;
            if (!Double.isNaN(d2)) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        d = ((Number)this.continuousDomainLimits.getSecond()).doubleValue();
        bl = false;
        d2 = d;
        bl2 = false;
        if (Double.isInfinite(d2)) return false;
        d2 = d;
        bl2 = false;
        if (Double.isNaN(d2)) return false;
        return true;
    }

    @Override
    @NotNull
    public Scale.Builder<T> with() {
        return new MyBuilder(this);
    }

    public /* synthetic */ ContinuousScale(MyBuilder b, DefaultConstructorMarker $constructor_marker) {
        this(b);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\"\u001a\u00020\u0012H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010$H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\"\u001a\u00020\fH\u0016J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010!2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\"\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010\u001b\u00a8\u0006,"}, d2={"Ljetbrains/datalore/plot/base/scale/ContinuousScale$MyBuilder;", "T", "Ljetbrains/datalore/plot/base/scale/AbstractScale$AbstractBuilder;", "", "scale", "Ljetbrains/datalore/plot/base/scale/ContinuousScale;", "(Ljetbrains/datalore/plot/base/scale/ContinuousScale;)V", "myContinuousOutput", "", "getMyContinuousOutput", "()Z", "myContinuousTransform", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "getMyContinuousTransform", "()Ljetbrains/datalore/plot/base/ContinuousTransform;", "setMyContinuousTransform", "(Ljetbrains/datalore/plot/base/ContinuousTransform;)V", "myCustomBreaksGenerator", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "getMyCustomBreaksGenerator", "()Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "setMyCustomBreaksGenerator", "(Ljetbrains/datalore/plot/base/scale/BreaksGenerator;)V", "myLowerLimit", "getMyLowerLimit", "()Ljava/lang/Double;", "setMyLowerLimit", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "myUpperLimit", "getMyUpperLimit", "setMyUpperLimit", "breaksGenerator", "Ljetbrains/datalore/plot/base/Scale$Builder;", "v", "build", "Ljetbrains/datalore/plot/base/Scale;", "continuousTransform", "limits", "domainValues", "", "", "lowerLimit", "upperLimit", "plot-base-portable"})
    private static final class MyBuilder<T>
    extends AbstractScale.AbstractBuilder<Double, T> {
        @NotNull
        private ContinuousTransform myContinuousTransform;
        @Nullable
        private BreaksGenerator myCustomBreaksGenerator;
        @Nullable
        private Double myLowerLimit;
        @Nullable
        private Double myUpperLimit;
        private final boolean myContinuousOutput;

        public MyBuilder(@NotNull ContinuousScale<T> scale) {
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            super((AbstractScale)scale);
            this.myContinuousTransform = ((ContinuousScale)scale).continuousTransform;
            this.myCustomBreaksGenerator = ((ContinuousScale)scale).customBreaksGenerator;
            this.myLowerLimit = (Double)scale.getContinuousDomainLimits().getFirst();
            this.myUpperLimit = (Double)scale.getContinuousDomainLimits().getSecond();
            this.myContinuousOutput = scale.isContinuous();
        }

        @NotNull
        public final ContinuousTransform getMyContinuousTransform() {
            return this.myContinuousTransform;
        }

        public final void setMyContinuousTransform(@NotNull ContinuousTransform continuousTransform) {
            Intrinsics.checkNotNullParameter((Object)continuousTransform, (String)"<set-?>");
            this.myContinuousTransform = continuousTransform;
        }

        @Nullable
        public final BreaksGenerator getMyCustomBreaksGenerator() {
            return this.myCustomBreaksGenerator;
        }

        public final void setMyCustomBreaksGenerator(@Nullable BreaksGenerator breaksGenerator) {
            this.myCustomBreaksGenerator = breaksGenerator;
        }

        @Nullable
        public final Double getMyLowerLimit() {
            return this.myLowerLimit;
        }

        public final void setMyLowerLimit(@Nullable Double d) {
            this.myLowerLimit = d;
        }

        @Nullable
        public final Double getMyUpperLimit() {
            return this.myUpperLimit;
        }

        public final void setMyUpperLimit(@Nullable Double d) {
            this.myUpperLimit = d;
        }

        public final boolean getMyContinuousOutput() {
            return this.myContinuousOutput;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public Scale.Builder<T> lowerLimit(double v) {
            var3_2 = v;
            var5_4 = false;
            var6_6 = var3_2;
            var8_8 = false;
            if (Double.isInfinite(var6_6)) ** GOTO lbl-1000
            var6_6 = var3_2;
            var8_8 = false;
            if (!Double.isNaN(var6_6)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            var3_3 = v0;
            var4_9 = false;
            var5_4 = false;
            if (!var3_3) {
                $i$a$-require-ContinuousScale$MyBuilder$lowerLimit$1 = false;
                var5_5 = Intrinsics.stringPlus((String)"`lower` can't be ", (Object)v);
                throw (Throwable)new IllegalArgumentException(var5_5.toString());
            }
            this.myLowerLimit = v;
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public Scale.Builder<T> upperLimit(double v) {
            var3_2 = v;
            var5_4 = false;
            var6_6 = var3_2;
            var8_8 = false;
            if (Double.isInfinite(var6_6)) ** GOTO lbl-1000
            var6_6 = var3_2;
            var8_8 = false;
            if (!Double.isNaN(var6_6)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            var3_3 = v0;
            var4_9 = false;
            var5_4 = false;
            if (!var3_3) {
                $i$a$-require-ContinuousScale$MyBuilder$upperLimit$1 = false;
                var5_5 = Intrinsics.stringPlus((String)"`upper` can't be ", (Object)v);
                throw (Throwable)new IllegalArgumentException(var5_5.toString());
            }
            this.myUpperLimit = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder<T> limits(@NotNull List<? extends Object> domainValues) {
            Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
            throw new IllegalArgumentException("Can't apply discrete limits to scale with continuous domain");
        }

        @Override
        @NotNull
        public Scale.Builder<T> continuousTransform(@NotNull ContinuousTransform v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.myContinuousTransform = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder<T> breaksGenerator(@NotNull BreaksGenerator v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.myCustomBreaksGenerator = v;
            return this;
        }

        @Override
        @NotNull
        public Scale<T> build() {
            return new ContinuousScale(this, null);
        }
    }
}

