/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jmeter.reporters.ResultCollectorHelper;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.ScriptWrapper;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.NameUpdater;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.util.JMeterError;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveService {
    private static final Logger log = LoggerFactory.getLogger(SaveService.class);
    public static final String SAMPLE_EVENT_OBJECT = "SampleEvent";
    public static final String RESULTCOLLECTOR_HELPER_OBJECT = "ResultCollectorHelper";
    public static final String TEST_CLASS_NAME = "TestClassName";
    private static final XStream JMXSAVER = new XStreamWrapper((ReflectionProvider)new PureJavaReflectionProvider());
    private static final XStream JTLSAVER = new XStreamWrapper((ReflectionProvider)new PureJavaReflectionProvider());
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"<ph>\"?>";
    private static final String SAVESERVICE_PROPERTIES_FILE = "saveservice.properties";
    private static final String SAVESERVICE_PROPERTIES = "saveservice_properties";
    private static final String VERSION_2_2 = "2.2";
    private static final Properties aliasToClass;
    private static final Properties classToAlias;
    private static final String VERSION = "1.2";
    private static String propertiesVersion;
    static final String PROPVERSION = "5.0";
    private static String fileVersion;
    private static String fileEncoding;

    private static void makeAlias(String aliasList, String clazz) {
        String[] aliases = aliasList.split(",");
        String alias = aliases[0];
        for (String a : aliases) {
            Object old = aliasToClass.setProperty(a, clazz);
            if (old == null) continue;
            log.error("Duplicate class detected for {}: {} & {}", new Object[]{alias, clazz, old});
        }
        Object oldval = classToAlias.setProperty(clazz, alias);
        if (oldval != null) {
            log.error("Duplicate alias detected for {}: {} & {}", new Object[]{clazz, alias, oldval});
        }
    }

    private static File getSaveServiceFile() {
        String saveServiceProps = JMeterUtils.getPropDefault(SAVESERVICE_PROPERTIES, SAVESERVICE_PROPERTIES_FILE);
        if (saveServiceProps.length() > 0) {
            return JMeterUtils.findFile(saveServiceProps);
        }
        throw new IllegalStateException("Could not find file configured in saveservice_properties property set to:" + saveServiceProps);
    }

    public static Properties loadProperties() throws IOException {
        Properties nameMap = new Properties();
        File saveServiceFile = SaveService.getSaveServiceFile();
        if (saveServiceFile.canRead()) {
            try (FileInputStream fis = new FileInputStream(saveServiceFile);){
                nameMap.load(fis);
            }
        }
        return nameMap;
    }

    private static String checksum(Properties nameMap) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        nameMap.entrySet().stream().sorted(Comparator.comparing(e -> e.getKey().toString()).thenComparing(e -> e.getValue().toString())).forEachOrdered(e -> {
            md.update(e.getKey().toString().getBytes(StandardCharsets.UTF_8));
            md.update(e.getValue().toString().getBytes(StandardCharsets.UTF_8));
        });
        return JOrphanUtils.baToHexString((byte[])md.digest());
    }

    private static void initProps() {
        try {
            Properties nameMap = SaveService.loadProperties();
            try {
                fileVersion = SaveService.checksum(nameMap);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Can't compute checksum for saveservice properties file", (Throwable)e);
                throw new JMeterError("JMeter requires the checksum of saveservice properties file to continue", (Throwable)e);
            }
            for (Map.Entry<Object, Object> me : nameMap.entrySet()) {
                String key = (String)me.getKey();
                String val = (String)me.getValue();
                if (!key.startsWith("_")) {
                    SaveService.makeAlias(key, val);
                    continue;
                }
                if (key.equalsIgnoreCase("_version")) {
                    propertiesVersion = val;
                    log.info("Using SaveService properties version {}", (Object)propertiesVersion);
                    continue;
                }
                if (key.equalsIgnoreCase("_file_version")) {
                    log.info("SaveService properties file version is now computed by a checksum,the property _file_version is not used anymore and can be removed.");
                    continue;
                }
                if (key.equalsIgnoreCase("_file_encoding")) {
                    fileEncoding = val;
                    log.info("Using SaveService properties file encoding {}", (Object)fileEncoding);
                    continue;
                }
                key = key.substring(1);
                SaveService.registerConverter(key, val);
            }
        }
        catch (IOException e) {
            log.error("Bad saveservice properties file", (Throwable)e);
            throw new JMeterError("JMeter requires the saveservice properties file to continue");
        }
    }

    private static void registerConverter(String key, String val) {
        try {
            String trimmedValue = val.trim();
            boolean useMapper = "collection".equals(trimmedValue) || "mapping".equals(trimmedValue);
            SaveService.registerConverter(key, JMXSAVER, useMapper);
            SaveService.registerConverter(key, JTLSAVER, useMapper);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            log.warn("Can't register a converter: {}", (Object)key, (Object)e1);
        }
    }

    private static void registerConverter(String key, XStream jmxsaver, boolean useMapper) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Class<Converter> clazz = Class.forName(key).asSubclass(Converter.class);
        if (useMapper) {
            jmxsaver.registerConverter(clazz.getConstructor(Mapper.class).newInstance(jmxsaver.getMapper()));
        } else {
            jmxsaver.registerConverter(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
    }

    public static String aliasToClass(String s) {
        String r = aliasToClass.getProperty(s);
        return r == null ? s : r;
    }

    public static String classToAlias(String s) {
        String r = classToAlias.getProperty(s);
        return r == null ? s : r;
    }

    public static void saveTree(HashTree tree, OutputStream out) throws IOException {
        OutputStreamWriter outputStreamWriter = SaveService.getOutputStreamWriter(out);
        SaveService.writeXmlHeader(outputStreamWriter);
        ScriptWrapper wrapper = new ScriptWrapper();
        wrapper.testPlan = tree;
        JMXSAVER.toXML((Object)wrapper, (Writer)outputStreamWriter);
        outputStreamWriter.write(10);
        outputStreamWriter.close();
    }

    public static void saveElement(Object el, OutputStream out) throws IOException {
        OutputStreamWriter outputStreamWriter = SaveService.getOutputStreamWriter(out);
        SaveService.writeXmlHeader(outputStreamWriter);
        JMXSAVER.toXML(el, (Writer)outputStreamWriter);
        outputStreamWriter.close();
    }

    public static Object loadElement(InputStream in) throws IOException {
        InputStreamReader inputStreamReader = SaveService.getInputStreamReader(in);
        Object element = JMXSAVER.fromXML((Reader)inputStreamReader);
        inputStreamReader.close();
        return element;
    }

    public static synchronized void saveSampleResult(SampleEvent evt, Writer writer) throws IOException {
        DataHolder dh = JTLSAVER.newDataHolder();
        dh.put((Object)SAMPLE_EVENT_OBJECT, (Object)evt);
        try {
            JTLSAVER.marshal((Object)evt.getResult(), new XppDriver().createWriter(writer), dh);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Failed marshalling:" + (evt.getResult() != null ? SaveService.showDebuggingInfo(evt.getResult()) : "null"), e);
        }
        writer.write(10);
    }

    private static String showDebuggingInfo(SampleResult result) {
        try {
            return "class:" + result.getClass() + ",content:" + ToStringBuilder.reflectionToString((Object)result);
        }
        catch (Exception e) {
            return "Exception occurred creating debug from event, message:" + e.getMessage();
        }
    }

    static String getPropertyVersion() {
        return propertiesVersion;
    }

    static String getFileVersion() {
        return fileVersion;
    }

    static List<String> checkClasses() {
        ClassLoader classLoader = SaveService.class.getClassLoader();
        ArrayList<String> missingClasses = new ArrayList<String>();
        for (Object clazz : classToAlias.keySet()) {
            String name = (String)clazz;
            if (NameUpdater.isMapped(name)) continue;
            try {
                Class.forName(name, false, classLoader);
            }
            catch (ClassNotFoundException e) {
                log.error("Unexpected entry in saveservice.properties; class does not exist and is not upgraded: {}", (Object)name);
                missingClasses.add(name);
            }
        }
        return missingClasses;
    }

    private static void checkVersions() {
        if (!PROPVERSION.equalsIgnoreCase(propertiesVersion)) {
            log.warn("Bad _version - expected {}, found {}.", (Object)PROPVERSION, (Object)propertiesVersion);
        }
    }

    public static void loadTestResults(InputStream reader, ResultCollectorHelper resultCollectorHelper) throws IOException {
        InputStreamReader inputStreamReader = SaveService.getInputStreamReader(reader);
        DataHolder dh = JTLSAVER.newDataHolder();
        dh.put((Object)RESULTCOLLECTOR_HELPER_OBJECT, (Object)resultCollectorHelper);
        JTLSAVER.unmarshal(new XppDriver().createReader(reader), null, dh);
        inputStreamReader.close();
    }

    /*
     * Exception decompiling
     */
    public static HashTree loadTree(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static HashTree readTree(InputStream inputStream, File file) throws IOException {
        ScriptWrapper wrapper = null;
        try {
            InputStreamReader inputStreamReader = SaveService.getInputStreamReader(inputStream);
            wrapper = (ScriptWrapper)JMXSAVER.fromXML((Reader)inputStreamReader);
            inputStreamReader.close();
            if (wrapper == null) {
                log.error("Problem loading XML: see above.");
                return null;
            }
            return wrapper.testPlan;
        }
        catch (ConversionException | CannotResolveClassException | NoClassDefFoundError e) {
            if (file != null) {
                throw new IllegalArgumentException("Problem loading XML from:'" + file.getAbsolutePath() + "'. \nCause:\n" + ExceptionUtils.getRootCauseMessage((Throwable)e) + "\n\n Detail:" + e, e);
            }
            throw new IllegalArgumentException("Problem loading XML. \nCause:\n" + ExceptionUtils.getRootCauseMessage((Throwable)e) + "\n\n Detail:" + e, e);
        }
    }

    private static InputStreamReader getInputStreamReader(InputStream inStream) {
        Charset charset = SaveService.getFileEncodingCharset();
        return new InputStreamReader(inStream, charset);
    }

    private static OutputStreamWriter getOutputStreamWriter(OutputStream outStream) {
        Charset charset = SaveService.getFileEncodingCharset();
        return new OutputStreamWriter(outStream, charset);
    }

    public static String getFileEncoding(String dflt) {
        if (fileEncoding != null && fileEncoding.length() > 0) {
            return fileEncoding;
        }
        return dflt;
    }

    private static Charset getFileEncodingCharset() {
        if (fileEncoding != null && fileEncoding.length() > 0) {
            return Charset.forName(fileEncoding);
        }
        log.info("fileEncoding not defined - using JRE default");
        return Charset.defaultCharset();
    }

    private static void writeXmlHeader(OutputStreamWriter writer) throws IOException {
        Charset charset = SaveService.getFileEncodingCharset();
        String header = XML_HEADER.replaceAll("<ph>", charset.name());
        writer.write(header);
        writer.write(10);
    }

    public static String CEtoString(ConversionException ce) {
        return "XStream ConversionException at line: " + ce.get("line number") + "\n" + ce.get("message") + "\nPerhaps a missing jar? See log file.";
    }

    public static String getPropertiesVersion() {
        return propertiesVersion;
    }

    public static String getVERSION() {
        return VERSION;
    }

    static {
        JTLSAVER.setMode(1001);
        JMeterUtils.setupXStreamSecurityPolicy(JMXSAVER);
        JMeterUtils.setupXStreamSecurityPolicy(JTLSAVER);
        aliasToClass = new Properties();
        classToAlias = new Properties();
        propertiesVersion = "";
        fileVersion = "";
        fileEncoding = "";
        log.info("Testplan (JMX) version: {}. Testlog (JTL) version: {}", (Object)VERSION_2_2, (Object)VERSION_2_2);
        SaveService.initProps();
        SaveService.checkVersions();
    }

    private static final class XStreamWrapper
    extends XStream {
        private XStreamWrapper(ReflectionProvider reflectionProvider) {
            super(reflectionProvider);
        }

        protected MapperWrapper wrapMapper(MapperWrapper next) {
            return new MapperWrapper((Mapper)next){

                public Class<?> realClass(String alias) {
                    String fullName = SaveService.aliasToClass(alias);
                    if (fullName != null) {
                        fullName = NameUpdater.getCurrentName(fullName);
                    }
                    return super.realClass(fullName == null ? alias : fullName);
                }

                public String serializedClass(Class type) {
                    if (type == null) {
                        return super.serializedClass(null);
                    }
                    String alias = SaveService.classToAlias(type.getName());
                    return alias == null ? super.serializedClass(type) : alias;
                }
            };
        }
    }
}

