/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.jmeter.gui.JMeterFileFilter;
import org.apache.jmeter.gui.action.HtmlReportGenerator;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReportUI
implements ActionListener {
    private static Set<String> commands = new HashSet<String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlReportUI.class);
    private static final String CREATE_REQUEST = "CREATE_REQUEST";
    private static final String BROWSE_CSV = "BROWSE_CSV";
    private static final String BROWSE_USER_PROPERTIES = "BROWSE_USER_PROPERTIES";
    private static final String BROWSE_OUTPUT = "BROWSE_OUTPUT";
    private EscapeDialog messageDialog;
    private JTextField csvFilePathTextField;
    private JTextField userPropertiesFilePathTextField;
    private JTextField outputDirectoryPathTextField;
    private JButton reportLaunchButton;
    private JSyntaxTextArea reportArea;
    private JButton csvFileButton;
    private JButton outputDirectoryButton;
    private JButton userPropertiesFileButton;
    private String lastJFCDirectory;
    private final String iconSize = JMeterUtils.getPropDefault("jmeter.toolbar.icons.size", "22x22");
    private static final String GENERATE_REPORT_LABEL = JMeterUtils.getResString("generate_report_ui.html_report_request");
    private static final String GENERATING_REPORT_LABEL = JMeterUtils.getResString("generate_report_ui.html_report_processing");
    private static final String BROWSE = "browse";
    private static final String IMAGES_PREFIX = "status/";
    private final ImageIcon runningIcon = JMeterUtils.getImage("status/" + this.iconSize + "/task-recurring.png");
    private final ImageIcon inErrorIcon = JMeterUtils.getImage("status/" + this.iconSize + "/dialog-error-5.png");
    private final ImageIcon completedIcon = JMeterUtils.getImage("status/" + this.iconSize + "/task-complete.png");

    public void showInputDialog(JFrame parent) {
        this.setupInputDialog(parent);
        this.launchInputDialog();
    }

    private void launchInputDialog() {
        this.messageDialog.pack();
        ComponentUtil.centerComponentInWindow((Component)this.messageDialog);
        this.messageDialog.setVisible(true);
    }

    public void setupInputDialog(JFrame parent) {
        this.messageDialog = new EscapeDialog(parent, JMeterUtils.getResString("html_report"), false);
        this.setupContentPane();
    }

    private void setupContentPane() {
        Container contentPane = this.messageDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.setupFileChooserPanel(), "North");
        this.reportArea = JSyntaxTextArea.getInstance(10, 60, true);
        this.reportArea.setSyntaxEditingStyle("text/plain");
        this.reportArea.setEditable(false);
        contentPane.add((Component)((Object)this.reportArea), "Center");
        contentPane.add((Component)this.setupButtonPanel(), "South");
    }

    private JPanel setupFileChooserPanel() {
        JPanel fileChooserPanel = new JPanel(new GridLayout(3, 3));
        fileChooserPanel.add(new JLabel(JMeterUtils.getResString("generate_report_ui.csv_file")));
        this.csvFilePathTextField = new JTextField();
        fileChooserPanel.add(this.csvFilePathTextField);
        this.csvFileButton = new JButton(JMeterUtils.getResString(BROWSE));
        this.csvFileButton.setActionCommand(BROWSE_CSV);
        this.csvFileButton.addActionListener(this);
        fileChooserPanel.add(this.csvFileButton);
        fileChooserPanel.add(new JLabel(JMeterUtils.getResString("generate_report_ui.user_properties_file")));
        this.userPropertiesFilePathTextField = new JTextField();
        fileChooserPanel.add(this.userPropertiesFilePathTextField);
        this.userPropertiesFileButton = new JButton(JMeterUtils.getResString(BROWSE));
        this.userPropertiesFileButton.setActionCommand(BROWSE_USER_PROPERTIES);
        this.userPropertiesFileButton.addActionListener(this);
        fileChooserPanel.add(this.userPropertiesFileButton);
        fileChooserPanel.add(new JLabel(JMeterUtils.getResString("generate_report_ui.output_directory")));
        this.outputDirectoryPathTextField = new JTextField();
        fileChooserPanel.add(this.outputDirectoryPathTextField);
        this.outputDirectoryButton = new JButton(JMeterUtils.getResString(BROWSE));
        this.outputDirectoryButton.setActionCommand(BROWSE_OUTPUT);
        this.outputDirectoryButton.addActionListener(this);
        fileChooserPanel.add(this.outputDirectoryButton);
        return fileChooserPanel;
    }

    private JPanel setupButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1));
        this.reportLaunchButton = new JButton(GENERATE_REPORT_LABEL);
        this.reportLaunchButton.setActionCommand(CREATE_REQUEST);
        this.reportLaunchButton.addActionListener(this);
        buttonPanel.add(this.reportLaunchButton);
        return buttonPanel;
    }

    private void addTextToReport(String errorMessage) {
        this.reportArea.setText(this.reportArea.getText() + errorMessage + "\n");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        var2_2 = e.getActionCommand();
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case 2066480684: {
                if (!var2_2.equals("CREATE_REQUEST")) break;
                var3_3 = 0;
                break;
            }
            case 1024969330: {
                if (!var2_2.equals("BROWSE_USER_PROPERTIES")) break;
                var3_3 = 1;
                break;
            }
            case 321944241: {
                if (!var2_2.equals("BROWSE_CSV")) break;
                var3_3 = 2;
                break;
            }
            case 724328534: {
                if (!var2_2.equals("BROWSE_OUTPUT")) break;
                var3_3 = 3;
            }
        }
        switch (var3_3) {
            case 0: {
                try {
                    this.reportArea.setText(HtmlReportUI.GENERATING_REPORT_LABEL + "\n");
                    this.reportLaunchButton.setIcon(this.runningIcon);
                    new ReportGenerationWorker(this.reportLaunchButton).execute();
                }
                catch (Exception exception) {
                    if (!HtmlReportUI.LOGGER.isErrorEnabled()) ** GOTO lbl29
                    HtmlReportUI.LOGGER.error("Error during html report generation: {}", (Object)exception.getMessage(), (Object)exception);
                }
lbl29:
                // 3 sources

                if (!HtmlReportUI.LOGGER.isDebugEnabled()) break;
                HtmlReportUI.LOGGER.debug("CSV file path {}\nuser.properties file path: {}\nOutput directory file path: {}", new Object[]{this.csvFilePathTextField.getText(), this.userPropertiesFilePathTextField.getText(), this.outputDirectoryPathTextField.getText()});
                break;
            }
            case 1: {
                this.userPropertiesFilePathTextField.setText(this.showFileChooser(this.userPropertiesFileButton.getParent(), this.userPropertiesFilePathTextField, false, new String[]{".properties"}));
                break;
            }
            case 2: {
                this.csvFilePathTextField.setText(this.showFileChooser(this.csvFileButton.getParent(), this.csvFilePathTextField, false, new String[]{".jtl", ".csv"}));
                break;
            }
            case 3: {
                this.outputDirectoryPathTextField.setText(this.showFileChooser(this.outputDirectoryButton.getParent(), this.outputDirectoryPathTextField, true, null));
                break;
            }
        }
    }

    void reportToUser(List<String> runErrors) {
        if (runErrors.isEmpty()) {
            this.addTextToReport(JMeterUtils.getResString("generate_report_ui.html_report_success"));
            this.reportLaunchButton.setIcon(this.completedIcon);
        } else {
            this.addTextToReport(String.join((CharSequence)"\n", runErrors));
            this.reportLaunchButton.setIcon(this.inErrorIcon);
        }
    }

    private String showFileChooser(Component component, JTextField locationTextField, boolean onlyDirectory, String[] extensions) {
        JFileChooser jfc = new JFileChooser();
        if (onlyDirectory) {
            jfc.setFileSelectionMode(1);
        } else {
            jfc.setFileSelectionMode(2);
        }
        if (extensions != null && extensions.length > 0) {
            JMeterFileFilter currentFilter = new JMeterFileFilter(extensions);
            jfc.addChoosableFileFilter(currentFilter);
            jfc.setAcceptAllFileFilterUsed(true);
            jfc.setFileFilter(currentFilter);
        }
        if (this.lastJFCDirectory != null) {
            jfc.setCurrentDirectory(new File(this.lastJFCDirectory));
        } else {
            String start2 = System.getProperty("user.dir", "");
            if (!start2.isEmpty()) {
                jfc.setCurrentDirectory(new File(start2));
            }
        }
        int retVal = jfc.showOpenDialog(component);
        if (retVal == 0) {
            this.lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
            return jfc.getSelectedFile().getPath();
        }
        return locationTextField.getText();
    }

    static {
        commands.add("html_report");
    }

    private class ReportGenerationWorker
    extends SwingWorker<List<String>, String> {
        private JButton reportLaunchButton;

        public ReportGenerationWorker(JButton reportLaunchButton) {
            this.reportLaunchButton = reportLaunchButton;
        }

        @Override
        protected List<String> doInBackground() throws Exception {
            HtmlReportGenerator htmlReportAction = new HtmlReportGenerator(HtmlReportUI.this.csvFilePathTextField.getText(), HtmlReportUI.this.userPropertiesFilePathTextField.getText(), HtmlReportUI.this.outputDirectoryPathTextField.getText());
            SwingUtilities.invokeAndWait(() -> {
                this.reportLaunchButton.setEnabled(false);
                this.reportLaunchButton.setIcon(HtmlReportUI.this.runningIcon);
                this.reportLaunchButton.setText(GENERATING_REPORT_LABEL);
            });
            return htmlReportAction.run();
        }

        @Override
        protected void done() {
            try {
                this.reportLaunchButton.setEnabled(true);
                this.reportLaunchButton.setText(GENERATE_REPORT_LABEL);
                HtmlReportUI.this.reportToUser((List)this.get());
            }
            catch (InterruptedException | ExecutionException exception) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Error during html report generation: {}", (Object)exception.getMessage(), (Object)exception);
                }
                HtmlReportUI.this.reportToUser(Arrays.asList(exception.getMessage()));
            }
        }
    }
}

