/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.assertions.CompareAssertionResult;
import org.apache.jmeter.assertions.SubstitutionElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

@TestElementMetadata(labelResource="displayName")
public class CompareAssertion
extends AbstractTestElement
implements Assertion,
TestBean,
Serializable,
LoopIterationListener {
    private static final long serialVersionUID = 240L;
    private transient List<SampleResult> responses;
    private final transient StringSubstitution emptySub = new StringSubstitution("");
    private boolean compareContent = true;
    private long compareTime = -1L;
    private Collection<SubstitutionElement> stringsToSkip;
    private static final boolean USE_JAVA_REGEX = !JMeterUtils.getPropDefault((String)"jmeter.regex.engine", (String)"oro").equalsIgnoreCase("oro");

    public AssertionResult getResult(SampleResult response) {
        this.responses.add(response);
        if (this.responses.size() > 1) {
            CompareAssertionResult result = new CompareAssertionResult(this.getName());
            this.compareContent(result);
            this.compareTime(result);
            return result;
        }
        return new AssertionResult(this.getName());
    }

    private void compareTime(CompareAssertionResult result) {
        if (this.compareTime < 0L) {
            return;
        }
        long prevTime = -1L;
        SampleResult prevResult = null;
        for (SampleResult currentResult : this.responses) {
            long currentTime = currentResult.getTime();
            if (prevTime != -1L) {
                boolean failure;
                boolean bl = failure = Math.abs(prevTime - currentTime) > this.compareTime;
                if (failure) {
                    this.markTimeFailure(result, prevResult, prevTime, currentResult, currentTime);
                    return;
                }
            }
            prevResult = currentResult;
            prevTime = currentTime;
        }
    }

    private void markTimeFailure(CompareAssertionResult result, SampleResult prevResult, long prevTime, SampleResult currentResult, long currentTime) {
        result.setFailure(true);
        StringBuilder sb = new StringBuilder();
        this.appendResultDetails(sb, prevResult);
        sb.append(JMeterUtils.getResString((String)"comparison_response_time")).append(prevTime);
        result.addToBaseResult(sb.toString());
        sb.setLength(0);
        this.appendResultDetails(sb, currentResult);
        sb.append(JMeterUtils.getResString((String)"comparison_response_time")).append(currentTime);
        result.addToSecondaryResult(sb.toString());
        result.setFailureMessage(JMeterUtils.getResString((String)"comparison_differ_time") + this.compareTime + JMeterUtils.getResString((String)"comparison_unit"));
    }

    private void compareContent(CompareAssertionResult result) {
        if (!this.compareContent) {
            return;
        }
        String prevContent = null;
        SampleResult prevResult = null;
        for (SampleResult currentResult : this.responses) {
            String currentContent = currentResult.getResponseDataAsString();
            currentContent = this.filterString(currentContent);
            if (prevContent != null) {
                boolean failure;
                boolean bl = failure = !prevContent.equals(currentContent);
                if (failure) {
                    this.markContentFailure(result, prevContent, prevResult, currentResult, currentContent);
                    return;
                }
            }
            prevResult = currentResult;
            prevContent = currentContent;
        }
    }

    private void markContentFailure(CompareAssertionResult result, String prevContent, SampleResult prevResult, SampleResult currentResult, String currentContent) {
        result.setFailure(true);
        StringBuilder sb = new StringBuilder();
        this.appendResultDetails(sb, prevResult);
        sb.append(prevContent);
        result.addToBaseResult(sb.toString());
        sb.setLength(0);
        this.appendResultDetails(sb, currentResult);
        sb.append(currentContent);
        result.addToSecondaryResult(sb.toString());
        result.setFailureMessage(JMeterUtils.getResString((String)"comparison_differ_content"));
    }

    private void appendResultDetails(StringBuilder buf, SampleResult result) {
        String samplerData = result.getSamplerData();
        if (samplerData != null) {
            buf.append(samplerData.trim());
        }
        buf.append("\n");
        String requestHeaders = result.getRequestHeaders();
        if (requestHeaders != null) {
            buf.append(requestHeaders);
        }
        buf.append("\n\n");
    }

    private String filterString(String content) {
        if (this.stringsToSkip == null || this.stringsToSkip.isEmpty()) {
            return content;
        }
        if (USE_JAVA_REGEX) {
            String result = content;
            for (SubstitutionElement element : this.stringsToSkip) {
                result = result.replaceAll(element.getRegex(), element.getSubstitute());
            }
            return result;
        }
        String result = content;
        for (SubstitutionElement regex : this.stringsToSkip) {
            this.emptySub.setSubstitution(regex.getSubstitute());
            result = Util.substitute((PatternMatcher)JMeterUtils.getMatcher(), (Pattern)JMeterUtils.getPatternCache().getPattern(regex.getRegex()), (Substitution)this.emptySub, (String)result, (int)-1);
        }
        return result;
    }

    public void iterationStart(LoopIterationEvent iterEvent) {
        this.responses = new ArrayList<SampleResult>();
    }

    public boolean isCompareContent() {
        return this.compareContent;
    }

    public void setCompareContent(boolean compareContent) {
        this.compareContent = compareContent;
    }

    public long getCompareTime() {
        return this.compareTime;
    }

    public void setCompareTime(long compareTime) {
        this.compareTime = compareTime;
    }

    public Collection<SubstitutionElement> getStringsToSkip() {
        return this.stringsToSkip;
    }

    public void setStringsToSkip(Collection<SubstitutionElement> stringsToSkip) {
        this.stringsToSkip = stringsToSkip;
    }
}

