/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayout;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.XYPlotLayoutUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/builder/layout/XYPlotTileLayout;", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "hAxisLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "vAxisLayout", "hDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "vDomain", "(Ljetbrains/datalore/plot/builder/layout/AxisLayout;Ljetbrains/datalore/plot/builder/layout/AxisLayout;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;)V", "doLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "Companion", "plot-builder-portable"})
public final class XYPlotTileLayout
implements TileLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AxisLayout hAxisLayout;
    @NotNull
    private final AxisLayout vAxisLayout;
    @NotNull
    private final ClosedRange<Double> hDomain;
    @NotNull
    private final ClosedRange<Double> vDomain;
    private static final double AXIS_STRETCH_RATIO = 0.1;

    public XYPlotTileLayout(@NotNull AxisLayout hAxisLayout, @NotNull AxisLayout vAxisLayout, @NotNull ClosedRange<Double> hDomain, @NotNull ClosedRange<Double> vDomain) {
        Intrinsics.checkNotNullParameter((Object)hAxisLayout, (String)"hAxisLayout");
        Intrinsics.checkNotNullParameter((Object)vAxisLayout, (String)"vAxisLayout");
        Intrinsics.checkNotNullParameter(hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter(vDomain, (String)"vDomain");
        this.hAxisLayout = hAxisLayout;
        this.vAxisLayout = vAxisLayout;
        this.hDomain = hDomain;
        this.vDomain = vDomain;
    }

    @Override
    @NotNull
    public TileLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        DoubleRectangle doubleRectangle;
        DoubleRectangle boundsNew;
        DoubleRectangle geomBoundsAfterLayout;
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Pair pair2 = XYPlotTileLayout.Companion.computeAxisInfos(this.hAxisLayout, this.vAxisLayout, preferredSize, this.hDomain, this.vDomain, coordProvider);
        Object hAxisInfo = null;
        hAxisInfo = pair2.component1();
        AxisLayoutInfo vAxisInfo = (AxisLayoutInfo)pair2.component2();
        double hAxisThickness = ((AxisLayoutInfo)hAxisInfo).axisBounds().getDimension().getY();
        double vAxisThickness = vAxisInfo.axisBounds().getDimension().getX();
        DoubleRectangle doubleRectangle2 = geomBoundsAfterLayout = XYPlotLayoutUtil.INSTANCE.geomBounds(hAxisThickness, vAxisThickness, preferredSize, this.hDomain, this.vDomain, coordProvider);
        boolean bl = false;
        boolean bl2 = false;
        DoubleRectangle it = doubleRectangle2;
        boolean bl3 = false;
        DoubleRectangle maxTickLabelsBounds = XYPlotLayoutUtil.INSTANCE.maxTickLabelsBounds(Orientation.BOTTOM, 0.0, it, preferredSize);
        DoubleRectangle tickLabelsBounds = ((AxisLayoutInfo)hAxisInfo).getTickLabelsBounds();
        double d = maxTickLabelsBounds.getLeft();
        DoubleRectangle doubleRectangle3 = tickLabelsBounds;
        Intrinsics.checkNotNull((Object)doubleRectangle3);
        double leftOverflow = d - doubleRectangle3.getOrigin().getX();
        double rightOverflow = tickLabelsBounds.getOrigin().getX() + tickLabelsBounds.getDimension().getX() - maxTickLabelsBounds.getRight();
        double newX = it.getOrigin().getX();
        double newW = it.getDimension().getX();
        if (leftOverflow > 0.0) {
            newX = it.getOrigin().getX() + leftOverflow;
            newW = it.getDimension().getX() - leftOverflow;
        }
        if (rightOverflow > 0.0) {
            newW -= rightOverflow;
        }
        if (!Intrinsics.areEqual((Object)(boundsNew = new DoubleRectangle(newX, it.getOrigin().getY(), newW, it.getDimension().getY())), (Object)geomBoundsAfterLayout)) {
            DoubleVector sizeNew = coordProvider.adjustGeomSize(this.hDomain, this.vDomain, boundsNew.getDimension());
            doubleRectangle = new DoubleRectangle(boundsNew.getOrigin(), sizeNew);
        } else {
            doubleRectangle = boundsNew;
        }
        DoubleRectangle geomBounds = doubleRectangle;
        DoubleRectangle geomWithAxisBounds = XYPlotTileLayout.Companion.tileBounds(((AxisLayoutInfo)hAxisInfo).axisBounds(), vAxisInfo.axisBounds(), geomBounds);
        hAxisInfo = ((AxisLayoutInfo)hAxisInfo).withAxisLength(geomBounds.getWidth()).build();
        vAxisInfo = vAxisInfo.withAxisLength(geomBounds.getHeight()).build();
        return new TileLayoutInfo(geomWithAxisBounds, geomBounds, XYPlotLayoutUtil.INSTANCE.clipBounds(geomBounds), (AxisLayoutInfo)hAxisInfo, vAxisInfo, false, false, 0, 96, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/builder/layout/XYPlotTileLayout$Companion;", "", "()V", "AXIS_STRETCH_RATIO", "", "computeAxisInfos", "Lkotlin/Pair;", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "hAxisLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "vAxisLayout", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "hDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "vDomain", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "computeHAxisInfo", "axisLayout", "axisDomain", "geomBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "computeVAxisInfo", "tileBounds", "xAxisBounds", "yAxisBounds", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final DoubleRectangle tileBounds(DoubleRectangle xAxisBounds, DoubleRectangle yAxisBounds, DoubleRectangle geomBounds) {
            DoubleVector leftTop = new DoubleVector(geomBounds.getLeft() - yAxisBounds.getWidth(), geomBounds.getTop() - 0.0);
            DoubleVector rightBottom = new DoubleVector(geomBounds.getRight() + 0.0, geomBounds.getBottom() + xAxisBounds.getHeight());
            return new DoubleRectangle(leftTop, rightBottom.subtract(leftTop));
        }

        private final Pair<AxisLayoutInfo, AxisLayoutInfo> computeAxisInfos(AxisLayout hAxisLayout, AxisLayout vAxisLayout, DoubleVector plotSize2, ClosedRange<Double> hDomain, ClosedRange<Double> vDomain, CoordProvider coordProvider) {
            AxisLayoutInfo vAxisInfo;
            double vAxisThickness;
            double hAxisThickness = hAxisLayout.initialThickness();
            AxisLayoutInfo hAxisInfo = this.computeHAxisInfo(hAxisLayout, hDomain, plotSize2, XYPlotLayoutUtil.INSTANCE.geomBounds(hAxisThickness, vAxisThickness = (vAxisInfo = this.computeVAxisInfo(vAxisLayout, vDomain, XYPlotLayoutUtil.INSTANCE.geomBounds(hAxisThickness, vAxisLayout.initialThickness(), plotSize2, hDomain, vDomain, coordProvider))).axisBounds().getDimension().getX(), plotSize2, hDomain, vDomain, coordProvider));
            if (hAxisInfo.axisBounds().getDimension().getY() > hAxisThickness) {
                vAxisInfo = this.computeVAxisInfo(vAxisLayout, vDomain, XYPlotLayoutUtil.INSTANCE.geomBounds(hAxisInfo.axisBounds().getDimension().getY(), vAxisThickness, plotSize2, hDomain, vDomain, coordProvider));
            }
            return new Pair((Object)hAxisInfo, (Object)vAxisInfo);
        }

        private final AxisLayoutInfo computeHAxisInfo(AxisLayout axisLayout, ClosedRange<Double> axisDomain, DoubleVector plotSize2, DoubleRectangle geomBounds) {
            double axisLength = geomBounds.getDimension().getX();
            double stretch = axisLength * 0.1;
            DoubleRectangle maxTickLabelsBounds = XYPlotLayoutUtil.INSTANCE.maxTickLabelsBounds(Orientation.BOTTOM, stretch, geomBounds, plotSize2);
            return axisLayout.doLayout(axisDomain, axisLength, maxTickLabelsBounds);
        }

        private final AxisLayoutInfo computeVAxisInfo(AxisLayout axisLayout, ClosedRange<Double> axisDomain, DoubleRectangle geomBounds) {
            return axisLayout.doLayout(axisDomain, geomBounds.getDimension().getY(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

