/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.interact.loc;

import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.builder.interact.MathUtil;
import jetbrains.datalore.plot.builder.interact.loc.PathTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.PointTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.PolygonTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.RectTargetProjection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0019\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/TargetDetector;", "", "locatorLookupSpace", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupSpace;", "locatorLookupStrategy", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupStrategy;", "(Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupSpace;Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupStrategy;)V", "checkPath", "Ljetbrains/datalore/plot/builder/interact/loc/PathTargetProjection$PathPoint;", "cursorCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "pathProjection", "Ljetbrains/datalore/plot/builder/interact/loc/PathTargetProjection;", "closestPointChecker", "Ljetbrains/datalore/plot/builder/interact/MathUtil$ClosestPointChecker;", "checkPoint", "", "pointProjection", "Ljetbrains/datalore/plot/builder/interact/loc/PointTargetProjection;", "checkPolygon", "polygonProjection", "Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection;", "checkRect", "rectProjection", "Ljetbrains/datalore/plot/builder/interact/loc/RectTargetProjection;", "rangeBasedLookup", "range", "Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;", "Companion", "plot-builder-portable"})
public final class TargetDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeomTargetLocator.LookupSpace locatorLookupSpace;
    @NotNull
    private final GeomTargetLocator.LookupStrategy locatorLookupStrategy;
    private static final double POINT_AREA_EPSILON = 0.1;
    private static final double POINT_X_NEAREST_EPSILON = 2.0;
    private static final double RECT_X_NEAREST_EPSILON = 2.0;

    public TargetDetector(@NotNull GeomTargetLocator.LookupSpace locatorLookupSpace, @NotNull GeomTargetLocator.LookupStrategy locatorLookupStrategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)locatorLookupSpace), (String)"locatorLookupSpace");
        Intrinsics.checkNotNullParameter((Object)((Object)locatorLookupStrategy), (String)"locatorLookupStrategy");
        this.locatorLookupSpace = locatorLookupSpace;
        this.locatorLookupStrategy = locatorLookupStrategy;
    }

    @Nullable
    public final PathTargetProjection.PathPoint checkPath(@NotNull DoubleVector cursorCoord, @NotNull PathTargetProjection pathProjection, @NotNull MathUtil.ClosestPointChecker closestPointChecker) {
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)pathProjection, (String)"pathProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        GeomTargetLocator.LookupSpace lookupSpace = this.locatorLookupSpace;
        int n = WhenMappings.$EnumSwitchMapping$0[lookupSpace.ordinal()];
        switch (n) {
            case 1: {
                PathTargetProjection.PathPoint pathPoint;
                if (this.locatorLookupStrategy == GeomTargetLocator.LookupStrategy.NONE) {
                    return null;
                }
                List<PathTargetProjection.PathPoint> pathPoints = pathProjection.getPoints();
                if (pathPoints.isEmpty()) {
                    return null;
                }
                int resultIndex2 = TargetDetector.Companion.binarySearch(cursorCoord.getX(), pathPoints.size(), (Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(pathPoints){
                    final /* synthetic */ List<PathTargetProjection.PathPoint> $pathPoints;
                    {
                        this.$pathPoints = $pathPoints;
                        super(1);
                    }

                    @NotNull
                    public final Double invoke(int index) {
                        return this.$pathPoints.get(index).projection().x();
                    }
                }));
                PathTargetProjection.PathPoint bestPoint = pathPoints.get(resultIndex2);
                GeomTargetLocator.LookupStrategy lookupStrategy = this.locatorLookupStrategy;
                int n2 = WhenMappings.$EnumSwitchMapping$1[lookupStrategy.ordinal()];
                switch (n2) {
                    case 1: {
                        if (cursorCoord.getX() < pathPoints.get(0).projection().x() || cursorCoord.getX() > pathPoints.get(pathPoints.size() - 1).projection().x()) {
                            pathPoint = null;
                            break;
                        }
                        pathPoint = bestPoint;
                        break;
                    }
                    case 2: {
                        pathPoint = bestPoint;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown lookup strategy: ", (Object)((Object)this.locatorLookupStrategy)));
                    }
                }
                return pathPoint;
            }
            case 2: {
                GeomTargetLocator.LookupStrategy lookupStrategy = this.locatorLookupStrategy;
                int n3 = WhenMappings.$EnumSwitchMapping$1[lookupStrategy.ordinal()];
                switch (n3) {
                    case 1: {
                        for (PathTargetProjection.PathPoint pathPoint : pathProjection.getPoints()) {
                            DoubleVector targetPointCoord = pathPoint.projection().xy();
                            if (!MathUtil.INSTANCE.areEqual$plot_builder_portable(targetPointCoord, cursorCoord, 0.1)) continue;
                            return pathPoint;
                        }
                        return null;
                    }
                    case 2: {
                        PathTargetProjection.PathPoint nearestPoint = null;
                        for (PathTargetProjection.PathPoint pathPoint : pathProjection.getPoints()) {
                            DoubleVector targetPointCoord = pathPoint.projection().xy();
                            if (!closestPointChecker.check(targetPointCoord)) continue;
                            nearestPoint = pathPoint;
                        }
                        return nearestPoint;
                    }
                    case 3: {
                        return null;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public final boolean checkPoint(@NotNull DoubleVector cursorCoord, @NotNull PointTargetProjection pointProjection, @NotNull MathUtil.ClosestPointChecker closestPointChecker) {
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)pointProjection, (String)"pointProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        GeomTargetLocator.LookupSpace lookupSpace = this.locatorLookupSpace;
        int n = WhenMappings.$EnumSwitchMapping$0[lookupSpace.ordinal()];
        switch (n) {
            case 1: {
                boolean bl;
                double x2 = pointProjection.x();
                GeomTargetLocator.LookupStrategy lookupStrategy = this.locatorLookupStrategy;
                int n2 = WhenMappings.$EnumSwitchMapping$1[lookupStrategy.ordinal()];
                switch (n2) {
                    case 1: {
                        bl = MathUtil.INSTANCE.areEqual$plot_builder_portable(x2, cursorCoord.getX(), 0.1);
                        break;
                    }
                    case 2: {
                        bl = closestPointChecker.check(new DoubleVector(x2, 0.0));
                        break;
                    }
                    case 3: {
                        bl = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return bl;
            }
            case 2: {
                boolean bl;
                DoubleVector targetPointCoord = pointProjection.xy();
                GeomTargetLocator.LookupStrategy lookupStrategy = this.locatorLookupStrategy;
                int n3 = WhenMappings.$EnumSwitchMapping$1[lookupStrategy.ordinal()];
                switch (n3) {
                    case 1: {
                        bl = MathUtil.INSTANCE.areEqual$plot_builder_portable(targetPointCoord, cursorCoord, 0.1);
                        break;
                    }
                    case 2: {
                        bl = closestPointChecker.check(targetPointCoord);
                        break;
                    }
                    case 3: {
                        bl = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return bl;
            }
            case 3: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    public final boolean checkRect(@NotNull DoubleVector cursorCoord, @NotNull RectTargetProjection rectProjection, @NotNull MathUtil.ClosestPointChecker closestPointChecker) {
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)rectProjection, (String)"rectProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        GeomTargetLocator.LookupSpace lookupSpace = this.locatorLookupSpace;
        int n = WhenMappings.$EnumSwitchMapping$0[lookupSpace.ordinal()];
        switch (n) {
            case 1: {
                MathUtil.DoubleRange range = rectProjection.x();
                return this.rangeBasedLookup(cursorCoord, closestPointChecker, range);
            }
            case 2: {
                DoubleRectangle rect2 = rectProjection.xy();
                GeomTargetLocator.LookupStrategy lookupStrategy = this.locatorLookupStrategy;
                int n2 = WhenMappings.$EnumSwitchMapping$1[lookupStrategy.ordinal()];
                switch (n2) {
                    case 1: {
                        return rect2.contains(cursorCoord);
                    }
                    case 2: {
                        if (rect2.contains(cursorCoord)) {
                            return closestPointChecker.check(cursorCoord);
                        }
                        double x2 = cursorCoord.getX() < rect2.getLeft() ? rect2.getLeft() : rect2.getRight();
                        double y2 = cursorCoord.getY() < rect2.getTop() ? rect2.getTop() : rect2.getBottom();
                        x2 = rect2.xRange().contains((Double)((Comparable)Double.valueOf(cursorCoord.getX()))) ? cursorCoord.getX() : x2;
                        y2 = rect2.yRange().contains((Double)((Comparable)Double.valueOf(cursorCoord.getY()))) ? cursorCoord.getY() : y2;
                        return closestPointChecker.check(new DoubleVector(x2, y2));
                    }
                    case 3: {
                        return false;
                    }
                }
                throw new IllegalStateException();
            }
            case 3: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    public final boolean checkPolygon(@NotNull DoubleVector cursorCoord, @NotNull PolygonTargetProjection polygonProjection, @NotNull MathUtil.ClosestPointChecker closestPointChecker) {
        Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
        Intrinsics.checkNotNullParameter((Object)polygonProjection, (String)"polygonProjection");
        Intrinsics.checkNotNullParameter((Object)closestPointChecker, (String)"closestPointChecker");
        GeomTargetLocator.LookupSpace lookupSpace = this.locatorLookupSpace;
        int n = WhenMappings.$EnumSwitchMapping$0[lookupSpace.ordinal()];
        switch (n) {
            case 1: {
                MathUtil.DoubleRange range = polygonProjection.x();
                return this.rangeBasedLookup(cursorCoord, closestPointChecker, range);
            }
            case 2: {
                List<PolygonTargetProjection.RingXY> polygon2 = polygonProjection.xy();
                GeomTargetLocator.LookupStrategy lookupStrategy = this.locatorLookupStrategy;
                int n2 = WhenMappings.$EnumSwitchMapping$1[lookupStrategy.ordinal()];
                switch (n2) {
                    case 1: 
                    case 2: {
                        int counter = 0;
                        for (PolygonTargetProjection.RingXY ring : polygon2) {
                            if (!ring.getBbox().contains(cursorCoord) || !MathUtil.INSTANCE.polygonContainsCoordinate$plot_builder_portable(ring.getEdges(), cursorCoord)) continue;
                            int n3 = counter;
                            counter = n3 + 1;
                        }
                        return counter % 2 != 0;
                    }
                    case 3: {
                        return false;
                    }
                }
                throw new IllegalStateException();
            }
            case 3: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private final boolean rangeBasedLookup(DoubleVector cursorCoord, MathUtil.ClosestPointChecker closestPointChecker, MathUtil.DoubleRange range) {
        GeomTargetLocator.LookupStrategy lookupStrategy = this.locatorLookupStrategy;
        int n = WhenMappings.$EnumSwitchMapping$1[lookupStrategy.ordinal()];
        switch (n) {
            case 1: {
                return range.contains(cursorCoord.getX());
            }
            case 2: {
                return !range.contains(cursorCoord.getX() - 2.0) && !range.contains(cursorCoord.getX() + 2.0) ? false : closestPointChecker.compare(new DoubleVector(range.start() + range.length() / (double)2, cursorCoord.getY())) != MathUtil.ClosestPointChecker.COMPARISON_RESULT.NEW_FARTHER;
            }
            case 3: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/TargetDetector$Companion;", "", "()V", "POINT_AREA_EPSILON", "", "POINT_X_NEAREST_EPSILON", "RECT_X_NEAREST_EPSILON", "binarySearch", "", "value", "length", "indexer", "Lkotlin/Function1;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final int binarySearch(double value, int length, Function1<? super Integer, Double> indexer) {
            if (value < ((Number)indexer.invoke((Object)0)).doubleValue()) {
                return 0;
            }
            if (value > ((Number)indexer.invoke((Object)(length - 1))).doubleValue()) {
                return length - 1;
            }
            int lo = 0;
            int hi = length - 1;
            while (lo <= hi) {
                int mid = (hi + lo) / 2;
                double midValue = ((Number)indexer.invoke((Object)mid)).doubleValue();
                if (value < midValue) {
                    hi = mid - 1;
                    continue;
                }
                if (value > midValue) {
                    lo = mid + 1;
                    continue;
                }
                return mid;
            }
            return ((Number)indexer.invoke((Object)lo)).doubleValue() - value < value - ((Number)indexer.invoke((Object)hi)).doubleValue() ? lo : hi;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GeomTargetLocator.LookupSpace.values().length];
            nArray[GeomTargetLocator.LookupSpace.X.ordinal()] = 1;
            nArray[GeomTargetLocator.LookupSpace.XY.ordinal()] = 2;
            nArray[GeomTargetLocator.LookupSpace.NONE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GeomTargetLocator.LookupStrategy.values().length];
            nArray[GeomTargetLocator.LookupStrategy.HOVER.ordinal()] = 1;
            nArray[GeomTargetLocator.LookupStrategy.NEAREST.ordinal()] = 2;
            nArray[GeomTargetLocator.LookupStrategy.NONE.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

