/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.SomeFig;
import jetbrains.datalore.plot.base.geom.LiveMapGeom;
import jetbrains.datalore.plot.base.geom.LiveMapProvider;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.TileFrameOfReference;
import jetbrains.datalore.plot.builder.interact.loc.LayerTargetCollectorWithLocator;
import jetbrains.datalore.plot.builder.layout.FacetGridPlotLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.theme.FacetsTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import jetbrains.datalore.vis.svg.SvgRectElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\"H\u0002J\b\u0010%\u001a\u00020\u001fH\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ljetbrains/datalore/plot/builder/PlotTile;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "layers", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "tilesOrigin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "tileLayoutInfo", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "frameOfReference", "Ljetbrains/datalore/plot/builder/TileFrameOfReference;", "(Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;Ljetbrains/datalore/plot/builder/theme/Theme;Ljetbrains/datalore/plot/builder/TileFrameOfReference;)V", "<set-?>", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "geomDrawingBounds", "getGeomDrawingBounds", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "Ljetbrains/datalore/base/values/SomeFig;", "liveMapFigure", "getLiveMapFigure", "()Ljetbrains/datalore/base/values/SomeFig;", "myTargetLocators", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "Lkotlin/collections/ArrayList;", "targetLocators", "getTargetLocators", "()Ljava/util/List;", "addFacetLabBackground", "", "labelBounds", "facetTheme", "Ljetbrains/datalore/plot/builder/theme/FacetsTheme;", "addFacetLabels", "geomBounds", "buildComponent", "Companion", "plot-builder-portable"})
public final class PlotTile
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<GeomLayer> layers;
    @NotNull
    private final DoubleVector tilesOrigin;
    @NotNull
    private final TileLayoutInfo tileLayoutInfo;
    @NotNull
    private final Theme theme;
    @NotNull
    private final TileFrameOfReference frameOfReference;
    @NotNull
    private final ArrayList<GeomTargetLocator> myTargetLocators;
    @Nullable
    private SomeFig liveMapFigure;
    private DoubleRectangle geomDrawingBounds;

    public PlotTile(@NotNull List<? extends GeomLayer> layers, @NotNull DoubleVector tilesOrigin, @NotNull TileLayoutInfo tileLayoutInfo, @NotNull Theme theme, @NotNull TileFrameOfReference frameOfReference) {
        Intrinsics.checkNotNullParameter(layers, (String)"layers");
        Intrinsics.checkNotNullParameter((Object)tilesOrigin, (String)"tilesOrigin");
        Intrinsics.checkNotNullParameter((Object)tileLayoutInfo, (String)"tileLayoutInfo");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)frameOfReference, (String)"frameOfReference");
        this.layers = layers;
        this.tilesOrigin = tilesOrigin;
        this.tileLayoutInfo = tileLayoutInfo;
        this.theme = theme;
        this.frameOfReference = frameOfReference;
        this.myTargetLocators = new ArrayList();
        this.moveTo(this.tileLayoutInfo.getAbsoluteBounds(this.tilesOrigin).getOrigin());
    }

    @Nullable
    public final SomeFig getLiveMapFigure() {
        return this.liveMapFigure;
    }

    @NotNull
    public final List<GeomTargetLocator> getTargetLocators() {
        return this.myTargetLocators;
    }

    @NotNull
    public final DoubleRectangle getGeomDrawingBounds() {
        DoubleRectangle doubleRectangle = this.geomDrawingBounds;
        if (doubleRectangle != null) {
            return doubleRectangle;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"geomDrawingBounds");
        return null;
    }

    @Override
    protected void buildComponent() {
        Object v0;
        DoubleRectangle geomBounds;
        block4: {
            geomBounds = this.tileLayoutInfo.getGeomBounds();
            this.addFacetLabels(geomBounds, this.theme.facets());
            Iterable $this$firstOrNull$iv = this.layers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GeomLayer it = (GeomLayer)element$iv;
                boolean bl = false;
                if (!it.isLiveMap()) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        GeomLayer liveMapGeomLayer = v0;
        if (liveMapGeomLayer != null) {
            DoubleRectangle realBounds = this.tileLayoutInfo.getAbsoluteGeomBounds(this.tilesOrigin);
            LiveMapProvider.LiveMapData liveMapData = PlotTile.Companion.createCanvasFigure(liveMapGeomLayer, realBounds);
            this.liveMapFigure = liveMapData.getCanvasFigure();
            this.myTargetLocators.add(liveMapData.getTargetLocator());
            this.geomDrawingBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), geomBounds.getDimension());
        } else {
            this.frameOfReference.drawBeforeGeomLayer(this);
            this.geomDrawingBounds = this.frameOfReference.applyClientLimits(new DoubleRectangle(DoubleVector.Companion.getZERO(), geomBounds.getDimension()));
            for (GeomLayer layer : this.layers) {
                LayerTargetCollectorWithLocator collectorWithLocator = new LayerTargetCollectorWithLocator(layer.getGeomKind(), layer.getLocatorLookupSpec(), layer.getContextualMapping());
                this.myTargetLocators.add(collectorWithLocator);
                SvgComponent layerComponent = this.frameOfReference.buildGeomComponent(layer, collectorWithLocator);
                layerComponent.moveTo(geomBounds.getOrigin());
                layerComponent.clipBounds(this.getGeomDrawingBounds());
                this.add(layerComponent);
            }
            this.frameOfReference.drawAfterGeomLayer(this);
        }
    }

    private final void addFacetLabels(DoubleRectangle geomBounds, FacetsTheme theme) {
        DoubleRectangle labelBounds;
        List<String> xLabels = this.tileLayoutInfo.getFacetXLabels();
        Collection collection = xLabels;
        boolean bl = false;
        if (!collection.isEmpty()) {
            DoubleVector labelSize = FacetGridPlotLayout.Companion.facetColLabelSize(geomBounds.getWidth());
            DoubleVector labelOrig = new DoubleVector(geomBounds.getLeft() + 0.0, geomBounds.getTop() - FacetGridPlotLayout.Companion.facetColHeadHeight(xLabels.size()) + (double)6);
            labelBounds = new DoubleRectangle(labelOrig, labelSize);
            for (String xLabel : xLabels) {
                this.addFacetLabBackground(labelBounds, theme);
                double x2 = labelBounds.getCenter().getX();
                double y2 = labelBounds.getCenter().getY();
                TextLabel lab = new TextLabel(xLabel);
                lab.moveTo(x2, y2);
                lab.textColor().set(theme.stripTextColor());
                lab.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
                lab.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
                this.add(lab);
                labelBounds = labelBounds.add(new DoubleVector(0.0, labelSize.getY()));
            }
        }
        if (this.tileLayoutInfo.getFacetYLabel() != null) {
            int hPad = 6;
            int vPad = 0;
            labelBounds = new DoubleRectangle(geomBounds.getRight() + (double)hPad, geomBounds.getTop() - (double)vPad, 30.0 - (double)(hPad * 2), geomBounds.getHeight() - (double)(vPad * 2));
            this.addFacetLabBackground(labelBounds, theme);
            double x3 = labelBounds.getCenter().getX();
            double y3 = labelBounds.getCenter().getY();
            TextLabel lab = new TextLabel(this.tileLayoutInfo.getFacetYLabel());
            lab.moveTo(x3, y3);
            lab.textColor().set(theme.stripTextColor());
            lab.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
            lab.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
            lab.rotate(90.0);
            this.add(lab);
        }
    }

    private final void addFacetLabBackground(DoubleRectangle labelBounds, FacetsTheme facetTheme) {
        if (facetTheme.showStripBackground()) {
            SvgRectElement svgRectElement = new SvgRectElement(labelBounds);
            boolean bl = false;
            boolean bl2 = false;
            SvgRectElement $this$addFacetLabBackground_u24lambda_u2d1 = svgRectElement;
            boolean bl3 = false;
            $this$addFacetLabBackground_u24lambda_u2d1.strokeWidth().set(facetTheme.stripStrokeWidth());
            $this$addFacetLabBackground_u24lambda_u2d1.fillColor().set(facetTheme.stripFill());
            $this$addFacetLabBackground_u24lambda_u2d1.strokeColor().set(facetTheme.stripColor());
            SvgRectElement rect2 = svgRectElement;
            this.add(rect2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/builder/PlotTile$Companion;", "", "()V", "createCanvasFigure", "Ljetbrains/datalore/plot/base/geom/LiveMapProvider$LiveMapData;", "layer", "Ljetbrains/datalore/plot/builder/GeomLayer;", "bounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final LiveMapProvider.LiveMapData createCanvasFigure(GeomLayer layer, DoubleRectangle bounds) {
            return ((LiveMapGeom)layer.getGeom()).createCanvasFigure(bounds);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

