# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['grouponefunctions']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib>=3.5.1', 'numpy==1.21.5', 'pandas>=1.4.2']

setup_kwargs = {
    'name': 'grouponefunctions',
    'version': '0.1.7',
    'description': 'A package containing the necessary functions to smoothly run the analysis in DSCI-310-Group-1',
    'long_description': '# grouponefunctions\n\nA package containing the necessary functions to smoothly run the analysis in DSCI-310-Group-1.\n\n## Installation\n\nNote: The installation is not likely to proceed for Python version lower than 3.9.10. Please check your Python version the code below.\n\n```bash\npython --version\n```\n\nThen you can install the package by the command below.\n\n```bash\npip install grouponefunctions\n```\n\n## Usage\n\n`grouponefunctions` is primarily used for analysis of [Predicting students’ grades using multi-variable regression](https://github.com/DSCI-310/DSCI-310-Group-1), but contains three general use functions. To implement the functions, `import` our package `grouponefunctions` as a module. The package has three functions: `splitxy`, `listfun`, and `plotsquaredata`. \n\n### `split_xy`\n\n `split_xy` can be used to split data into predictor feature and target variables as follows:\n\n```python\nfrom grouponefunctions.grouponefunctions import split_xy\n\nX_train, y_train = split_xy(train_df, ["feature1", "feature2", "feature3"], target)\nX_test, y_test = split_xy(test_df, ["feature1", "feature2", "feature3"], target) \n```\n\n### `plot_square_data`\n\nThis function is capable at creating plots to display in a grid configuration.\n\n```python\nfrom grouponefunctions.grouponefunction import plot_square_data\n\nplot_square_data(X_train, y_train, ["feature1", "feature2", "feature3"], ["title1", "title2", "title3], "This is Plot 1")\nplot_square_data(dependent, independednts, ["income"], ["retirement_age"], "Income and Retirement Age Relation")\n```\n\n\n\n\n\nThe third function `list_abs`\n\n\n## Contributing\n\nInterested in contributing? Check out the contributing guidelines. Please note that this project is released with a Code of Conduct. By contributing to this project, you agree to abide by its terms.\n\n## License\n\n`grouponefunctions` was created by Andres Zepeda Perez, Daniel Hou, Zizhen Guo, Timothy Zhou. It is licensed under the terms of the MIT license.\n\n## Credits\n\n`grouponefunctions` was created with [`cookiecutter`](https://cookiecutter.readthedocs.io/en/latest/) and the `py-pkgs-cookiecutter` [template](https://github.com/py-pkgs/py-pkgs-cookiecutter).\n',
    'author': 'Andres Perez, Daniel Hou, Zizhen Guo, Timothy Zhou',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<3.11',
}


setup(**setup_kwargs)
