# 经济数据工具

## 数据源

* 上海证券交易所(http://www.sse.com.cn/)
* 深证证券交易所(http://www.szse.cn/)
* 中国外汇交易中心(https://www.chinamoney.com.cn/)
* 新浪财经(https://finance.sina.com.cn/)
* 网易财经(https://money.163.com/)
* 华尔街见闻(https://wallstreetcn.com/)

## 使用方法

### 例1：获取LPR利率

```bash
$ python -m chinamoney
2022-03-21 9:15 1Y 3.70
2022-03-21 9:15 5Y 4.60
```

### 例2：获取沪市成交金额

```bash
$ python -m sse 2022-03-23 01,02,03,11,17
01 20220323 1663 420949.77 379170.91 3687.92 341.21 15.06 0.8761 0.9726
02 20220323 46 791.31 668.08 0.98 0.23 13.07 0.1235 0.1463
03 20220323 402 49116.16 19574.31 377.0 9.03 59.27 0.7676 1.926
11 20220323 0 0.0 0.0 2.49 0.24 - 0.0 0.0
17 20220323 2111 470857.23 399413.3 4065.9 350.47 16.23 0.8635 1.018
```

### 例3：获取深市成交金额

```bash
$ python -m szse
股票 2650 5,383.95 451.70 344,569.50 275,209.90 24,802.89 20,691.35
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;主板A股 1486 3,309.74 326.64 223,491.65 189,818.87 19,429.17 16,535.90
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;主板B股 43 0.39 0.09 460.54 458.21 121.28 120.97
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;创业板A股 1121 2,073.82 124.97 120,617.30 84,932.81 5,252.43 4,034.47
基金 556 142.02 134.51 3,302.35 3,175.28 2,553.36 2,535.76
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ETF 247 130.09 124.68 2,658.84 2,658.84 2,170.19 2,170.19
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;LOF 303 10.32 9.52 443.48 443.48 356.46 356.46
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;封闭式基金 1 0.01 0.00 18.75 18.75 0.19 0.19
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;基础设施基金 5 1.59 0.30 181.27 54.20 26.51 8.91
债券 10327 2,297.17 21.52        
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;债券现券 9631 487.02 3.40 515,814.02 22,820.32 5,160.01 225.82
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;债券回购 14 1,802.61 18.03        
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ABS    682 7.53 0.07 5,832.13 5,832.13 63.65 63.65
期权 160 2.27 0.00
```

### 例4：使用新浪财经获取伦敦金和WTI纽约原油

```bash
$ python -m sina_finance hf_XAU,hf_CL
var hq_str_hf_XAU="1913.02,1922.580,1913.02,1913.28,1929.23,1889.98,23:35:51,1922.58,1923.19,0,0,0,2022-03-29,伦敦金（现货黄金）";
var hq_str_hf_CL="102.454,,102.900,102.920,107.840,98.440,23:36:59,105.960,103.470,274556.000,1,2,2022-03-29,WTI纽约原油,285553";
```

### 例5：网易财经获得股票历史价格

```bash
$ python -m netease --code 0601318 --start 20220331 --end 20220331
日期,股票代码,名称,收盘价,前收盘,换手率,成交量,成交金额,总市值,流通市值
2022-03-31,'601318,中国平安,48.45,48.7,0.3909,42349781,2063589520.0,8.85677696314e+11,5.24842594928e+11
```

### 例6：新浪财经获取资产负债表

```bash
$ python -m sina_finance 601318 --zcfzb
```

指定资产负债表年份

```bash
$ python -m sina_finance 601318 --zcfzb --year 2020
报表日期 2020-12-31 2020-09-30 2020-06-30 2020-03-31 
货币资金 52,630,100.00 50,849,700.00 47,383,200.00 51,504,800.00 
拆出资金 7,099,600.00 9,879,700.00 8,381,800.00 4,955,100.00 
交易性金融资产 123,133,100.00 106,041,300.00 104,284,900.00 103,236,700.00 
衍生金融资产 3,766,100.00 3,165,000.00 3,575,000.00 4,056,400.00 
买入返售金融资产 12,276,500.00 9,291,700.00 9,389,600.00 9,345,400.00 
应收保费 9,400,300.00 9,811,400.00 9,590,100.00 9,279,900.00 
应收利息 -- -- -- -- 
应收分保账款 1,184,000.00 1,386,400.00 1,215,900.00 1,411,200.00 
应收分保未到期责任准备金 -- -- -- -- 
应收分保未决赔款准备金 -- -- -- -- 
应收分保寿险责任准备金 -- -- -- -- 
应收分保长期健康险责任准备金 -- -- -- -- 
保户质押贷款 16,138,100.00 15,670,200.00 15,231,700.00 14,790,100.00 
可供出售金融资产 -- -- -- -- 
持有至到期投资 262,484,800.00 257,035,700.00 245,421,700.00 234,216,900.00 
长期股权投资 26,781,900.00 23,668,500.00 22,358,500.00 21,343,400.00 
存出资本保证金 1,256,100.00 1,261,100.00 1,257,000.00 1,251,000.00 
应收款项类投资 -- -- -- -- 
固定资产 4,184,900.00 4,130,300.00 4,155,500.00 4,166,500.00 
无形资产 2,749,000.00 2,856,700.00 2,783,200.00 2,732,400.00 
商誉 2,303,100.00 2,122,400.00 2,085,900.00 2,091,400.00 
独立账户资产 5,305,900.00 5,087,300.00 5,039,800.00 4,538,400.00 
递延所得税资产 6,190,100.00 5,624,300.00 5,621,900.00 5,337,100.00 
投资性房地产 5,715,400.00 5,140,200.00 5,321,400.00 5,411,200.00 
定期存款 25,351,800.00 25,326,500.00 24,670,600.00 24,421,200.00 
其他资产 18,448,900.00 20,318,400.00 21,694,900.00 20,784,400.00 
资产总计 952,787,000.00 913,831,800.00 884,863,100.00 866,295,200.00 
短期借款 13,475,300.00 11,581,100.00 11,869,200.00 10,511,600.00 
拆入资金 4,133,400.00 6,215,800.00 3,929,600.00 2,689,600.00 
交易性金融负债 3,721,700.00 5,668,100.00 7,646,400.00 7,749,400.00 
衍生金融负债 4,857,900.00 4,298,400.00 4,637,700.00 4,865,600.00 
卖出回购金融资产款 27,660,200.00 31,172,300.00 22,998,900.00 22,634,000.00 
预收账款 -- -- -- -- 
预收保费 4,844,200.00 1,655,000.00 1,689,600.00 1,776,000.00 
应付手续费及佣金 1,000,100.00 1,113,300.00 1,155,400.00 1,085,200.00 
应付分保账款 1,599,100.00 1,771,700.00 1,645,800.00 1,875,700.00 
应付职工薪酬 4,349,500.00 4,039,300.00 3,529,000.00 3,250,800.00 
应交税费 2,606,000.00 2,703,900.00 2,312,500.00 3,102,400.00 
应付利息 -- -- -- -- 
应付赔付款 6,509,400.00 6,358,100.00 6,273,100.00 6,140,000.00 
应付保单红利 6,380,600.00 6,346,600.00 6,304,200.00 6,192,000.00 
保户储金及投资款 76,897,500.00 75,328,100.00 73,658,200.00 72,402,200.00 
未到期责任准备金 -- -- -- -- 
未决赔款准备金 -- -- -- -- 
寿险责任准备金 -- -- -- -- 
长期健康险责任准备金 -- -- -- -- 
长期借款 20,582,400.00 21,046,300.00 21,625,400.00 21,395,500.00 
应付债券 90,128,500.00 82,497,300.00 78,582,500.00 67,741,900.00 
独立账户负债 5,305,900.00 5,087,300.00 5,039,800.00 4,538,400.00 
递延所得税负债 1,926,700.00 871,800.00 1,574,100.00 1,725,700.00 
预计负债 -- -- -- -- 
其他负债 26,930,900.00 26,760,000.00 25,642,700.00 23,279,100.00 
负债合计 853,996,500.00 820,268,700.00 792,646,000.00 775,772,300.00 
股本 1,828,000.00 1,828,000.00 1,828,000.00 1,828,000.00 
资本公积金 13,447,400.00 12,817,600.00 12,528,500.00 12,421,400.00 
其他综合收益 -682,900.00 -1,336,400.00 162,000.00 986,200.00 
盈余公积金金 1,216,400.00 1,216,400.00 1,216,400.00 1,216,400.00 
未分配利润 52,167,700.00 49,736,900.00 47,765,400.00 45,954,900.00 
一般风险准备 8,878,900.00 7,303,900.00 7,296,400.00 7,212,200.00 
外币报表折算差额 -- -- -- -- 
归属于母公司的股东权益合计 76,256,000.00 70,966,900.00 70,197,200.00 69,019,600.00 
少数股东权益 22,534,500.00 22,596,200.00 22,019,900.00 21,503,300.00 
所有者权益合计 98,790,500.00 93,563,100.00 92,217,100.00 90,522,900.00 
负债及股东权益总计 952,787,000.00 913,831,800.00 884,863,100.00 866,295,200.00 
```

### 例7：从华尔街见闻获得世界主要国家国债收益率

```bash
$ python -m wallstreetcn
CN10YR CN10YR.OTC 中国10年期国债收益率 CN10YR 2.817 3 2.817 2.854 2.806 3.246 2.674 1648799746 2.823 0.006 0.23 forexdata ENDTR 0
US10YR US10YR.OTC 美国10年期国债收益率 US10YR 2.325 3 2.325 2.456 2.352 2.555 1.138 1648846795 2.386 0.061 2.62 forexdata ENDTR 0
```