# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class MetatypeKeysApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def archive_metatype_key(self, container_id, metatype_id, key_id, **kwargs):  # noqa: E501
        """ArchiveMetatypeKey  # noqa: E501

        Archiving the metatype key prevents any new types from implementing the key. It *does not remove key/value pairs on existing types*. We highly recommend you archive type keys instead of deleting them so that previous data is not affected.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_metatype_key(container_id, metatype_id, key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str metatype_id: (required)
        :param str key_id: (required)
        :return: Generic200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.archive_metatype_key_with_http_info(container_id, metatype_id, key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.archive_metatype_key_with_http_info(container_id, metatype_id, key_id, **kwargs)  # noqa: E501
            return data

    def archive_metatype_key_with_http_info(self, container_id, metatype_id, key_id, **kwargs):  # noqa: E501
        """ArchiveMetatypeKey  # noqa: E501

        Archiving the metatype key prevents any new types from implementing the key. It *does not remove key/value pairs on existing types*. We highly recommend you archive type keys instead of deleting them so that previous data is not affected.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_metatype_key_with_http_info(container_id, metatype_id, key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str metatype_id: (required)
        :param str key_id: (required)
        :return: Generic200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'metatype_id', 'key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_metatype_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `archive_metatype_key`")  # noqa: E501
        # verify the required parameter 'metatype_id' is set
        if ('metatype_id' not in params or
                params['metatype_id'] is None):
            raise ValueError("Missing the required parameter `metatype_id` when calling `archive_metatype_key`")  # noqa: E501
        # verify the required parameter 'key_id' is set
        if ('key_id' not in params or
                params['key_id'] is None):
            raise ValueError("Missing the required parameter `key_id` when calling `archive_metatype_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'metatype_id' in params:
            path_params['metatype_id'] = params['metatype_id']  # noqa: E501
        if 'key_id' in params:
            path_params['key_id'] = params['key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/metatypes/{metatype_id}/keys/{key_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Generic200Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_metatype_key(self, body, container_id, metatype_id, **kwargs):  # noqa: E501
        """CreateMetatypeKey  # noqa: E501

        Creates a new key for a metatype. Keys consist of a unique key name (unique to the metatype only), key type, default values, and allowed values. Of those, only the first two are required.  The `dataType` field accepts only one of the following values: number, string, date, boolean, enumeration, file.   The fields `defaultValue` and `options` will only accept an array of the following types: string, boolean, number, float.  Pass in an array for bulk creation.  Currently the validation and cardinality functionality of keys are NOT checked at data insertion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_metatype_key(body, container_id, metatype_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NewMetatypeKeyRequest body: (required)
        :param str container_id: (required)
        :param str metatype_id: (required)
        :return: CreateMetatypeKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_metatype_key_with_http_info(body, container_id, metatype_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_metatype_key_with_http_info(body, container_id, metatype_id, **kwargs)  # noqa: E501
            return data

    def create_metatype_key_with_http_info(self, body, container_id, metatype_id, **kwargs):  # noqa: E501
        """CreateMetatypeKey  # noqa: E501

        Creates a new key for a metatype. Keys consist of a unique key name (unique to the metatype only), key type, default values, and allowed values. Of those, only the first two are required.  The `dataType` field accepts only one of the following values: number, string, date, boolean, enumeration, file.   The fields `defaultValue` and `options` will only accept an array of the following types: string, boolean, number, float.  Pass in an array for bulk creation.  Currently the validation and cardinality functionality of keys are NOT checked at data insertion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_metatype_key_with_http_info(body, container_id, metatype_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NewMetatypeKeyRequest body: (required)
        :param str container_id: (required)
        :param str metatype_id: (required)
        :return: CreateMetatypeKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'container_id', 'metatype_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_metatype_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_metatype_key`")  # noqa: E501
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `create_metatype_key`")  # noqa: E501
        # verify the required parameter 'metatype_id' is set
        if ('metatype_id' not in params or
                params['metatype_id'] is None):
            raise ValueError("Missing the required parameter `metatype_id` when calling `create_metatype_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'metatype_id' in params:
            path_params['metatype_id'] = params['metatype_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/metatypes/{metatype_id}/keys', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateMetatypeKeysResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_metatypes_keys(self, container_id, metatype_id, **kwargs):  # noqa: E501
        """ListMetatypesKeys  # noqa: E501

        Lists all currently valid and available keys for the metatype.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_metatypes_keys(container_id, metatype_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str metatype_id: (required)
        :return: ListMetatypeKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_metatypes_keys_with_http_info(container_id, metatype_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_metatypes_keys_with_http_info(container_id, metatype_id, **kwargs)  # noqa: E501
            return data

    def list_metatypes_keys_with_http_info(self, container_id, metatype_id, **kwargs):  # noqa: E501
        """ListMetatypesKeys  # noqa: E501

        Lists all currently valid and available keys for the metatype.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_metatypes_keys_with_http_info(container_id, metatype_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str metatype_id: (required)
        :return: ListMetatypeKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'metatype_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_metatypes_keys" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `list_metatypes_keys`")  # noqa: E501
        # verify the required parameter 'metatype_id' is set
        if ('metatype_id' not in params or
                params['metatype_id'] is None):
            raise ValueError("Missing the required parameter `metatype_id` when calling `list_metatypes_keys`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'metatype_id' in params:
            path_params['metatype_id'] = params['metatype_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/metatypes/{metatype_id}/keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListMetatypeKeysResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_metatype_key(self, container_id, metatype_id, key_id, **kwargs):  # noqa: E501
        """RetrieveMetatypeKey  # noqa: E501

        Retrieve the specified key for the metatype.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_metatype_key(container_id, metatype_id, key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str metatype_id: (required)
        :param str key_id: (required)
        :return: GetMetatypeKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_metatype_key_with_http_info(container_id, metatype_id, key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_metatype_key_with_http_info(container_id, metatype_id, key_id, **kwargs)  # noqa: E501
            return data

    def retrieve_metatype_key_with_http_info(self, container_id, metatype_id, key_id, **kwargs):  # noqa: E501
        """RetrieveMetatypeKey  # noqa: E501

        Retrieve the specified key for the metatype.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_metatype_key_with_http_info(container_id, metatype_id, key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str metatype_id: (required)
        :param str key_id: (required)
        :return: GetMetatypeKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'metatype_id', 'key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_metatype_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `retrieve_metatype_key`")  # noqa: E501
        # verify the required parameter 'metatype_id' is set
        if ('metatype_id' not in params or
                params['metatype_id'] is None):
            raise ValueError("Missing the required parameter `metatype_id` when calling `retrieve_metatype_key`")  # noqa: E501
        # verify the required parameter 'key_id' is set
        if ('key_id' not in params or
                params['key_id'] is None):
            raise ValueError("Missing the required parameter `key_id` when calling `retrieve_metatype_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'metatype_id' in params:
            path_params['metatype_id'] = params['metatype_id']  # noqa: E501
        if 'key_id' in params:
            path_params['key_id'] = params['key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/metatypes/{metatype_id}/keys/{key_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetMetatypeKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_metatype_key(self, body, container_id, metatype_id, key_id, **kwargs):  # noqa: E501
        """UpdateMetatypeKey  # noqa: E501

        Updates a single key for a metatype.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_metatype_key(body, container_id, metatype_id, key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateMetatypeKeyRequest body: (required)
        :param str container_id: (required)
        :param str metatype_id: (required)
        :param str key_id: (required)
        :return: UpdateMetatypeKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_metatype_key_with_http_info(body, container_id, metatype_id, key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_metatype_key_with_http_info(body, container_id, metatype_id, key_id, **kwargs)  # noqa: E501
            return data

    def update_metatype_key_with_http_info(self, body, container_id, metatype_id, key_id, **kwargs):  # noqa: E501
        """UpdateMetatypeKey  # noqa: E501

        Updates a single key for a metatype.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_metatype_key_with_http_info(body, container_id, metatype_id, key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateMetatypeKeyRequest body: (required)
        :param str container_id: (required)
        :param str metatype_id: (required)
        :param str key_id: (required)
        :return: UpdateMetatypeKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'container_id', 'metatype_id', 'key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_metatype_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_metatype_key`")  # noqa: E501
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `update_metatype_key`")  # noqa: E501
        # verify the required parameter 'metatype_id' is set
        if ('metatype_id' not in params or
                params['metatype_id'] is None):
            raise ValueError("Missing the required parameter `metatype_id` when calling `update_metatype_key`")  # noqa: E501
        # verify the required parameter 'key_id' is set
        if ('key_id' not in params or
                params['key_id'] is None):
            raise ValueError("Missing the required parameter `key_id` when calling `update_metatype_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'metatype_id' in params:
            path_params['metatype_id'] = params['metatype_id']  # noqa: E501
        if 'key_id' in params:
            path_params['key_id'] = params['key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/metatypes/{metatype_id}/keys/{key_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateMetatypeKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
