# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class AuthenticationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def exchange_o_auth_token(self, **kwargs):  # noqa: E501
        """ExchangeOAuthToken  # noqa: E501

        Exchanges credentials for a JSON Web Token (JWT). Multiple authentication flows are supported, see Deep Lynx documentation for details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exchange_o_auth_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TokenExchangeRequest body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.exchange_o_auth_token_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.exchange_o_auth_token_with_http_info(**kwargs)  # noqa: E501
            return data

    def exchange_o_auth_token_with_http_info(self, **kwargs):  # noqa: E501
        """ExchangeOAuthToken  # noqa: E501

        Exchanges credentials for a JSON Web Token (JWT). Multiple authentication flows are supported, see Deep Lynx documentation for details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.exchange_o_auth_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TokenExchangeRequest body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exchange_o_auth_token" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/oauth/exchange', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_containers_container_id_metatypes_metatype_id(self, container_id, metatype_id, **kwargs):  # noqa: E501
        """post-containers-container_id-metatypes-metatype_id  # noqa: E501

        Returns any errors associated with the intended properties or keys for a metatype or else the data itself if no errors are present.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_containers_container_id_metatypes_metatype_id(container_id, metatype_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str metatype_id: (required)
        :param object body:
        :return: ValidateMetatypePropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_containers_container_id_metatypes_metatype_id_with_http_info(container_id, metatype_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_containers_container_id_metatypes_metatype_id_with_http_info(container_id, metatype_id, **kwargs)  # noqa: E501
            return data

    def post_containers_container_id_metatypes_metatype_id_with_http_info(self, container_id, metatype_id, **kwargs):  # noqa: E501
        """post-containers-container_id-metatypes-metatype_id  # noqa: E501

        Returns any errors associated with the intended properties or keys for a metatype or else the data itself if no errors are present.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_containers_container_id_metatypes_metatype_id_with_http_info(container_id, metatype_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str metatype_id: (required)
        :param object body:
        :return: ValidateMetatypePropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'metatype_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_containers_container_id_metatypes_metatype_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `post_containers_container_id_metatypes_metatype_id`")  # noqa: E501
        # verify the required parameter 'metatype_id' is set
        if ('metatype_id' not in params or
                params['metatype_id'] is None):
            raise ValueError("Missing the required parameter `metatype_id` when calling `post_containers_container_id_metatypes_metatype_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'metatype_id' in params:
            path_params['metatype_id'] = params['metatype_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/metatypes/{metatype_id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ValidateMetatypePropertiesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_rsa_cancel(self, **kwargs):  # noqa: E501
        """post-rsa-cancel  # noqa: E501

        Cancels an RSA authentication attempt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_rsa_cancel(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RSACancelRequest body:
        :return: RSAResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_rsa_cancel_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_rsa_cancel_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_rsa_cancel_with_http_info(self, **kwargs):  # noqa: E501
        """post-rsa-cancel  # noqa: E501

        Cancels an RSA authentication attempt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_rsa_cancel_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RSACancelRequest body:
        :return: RSAResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_rsa_cancel" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/rsa/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RSAResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_rsa_initialize(self, **kwargs):  # noqa: E501
        """post-rsa-initialize  # noqa: E501

        Used to begin (and optionally complete) an RSA authentication. Either a user's ID may be provided and the SecurID provided in a later `verify` request,  or else the user may provide both the user ID (`subjectName`) and `securID` at once to `initialize` to complete the authentication request.  The `securID` is the combination of the user's memorized token and 6 digit temporary RSA pin (with no spaces or characters between them).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_rsa_initialize(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RSAInitRequest body:
        :return: RSAResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_rsa_initialize_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_rsa_initialize_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_rsa_initialize_with_http_info(self, **kwargs):  # noqa: E501
        """post-rsa-initialize  # noqa: E501

        Used to begin (and optionally complete) an RSA authentication. Either a user's ID may be provided and the SecurID provided in a later `verify` request,  or else the user may provide both the user ID (`subjectName`) and `securID` at once to `initialize` to complete the authentication request.  The `securID` is the combination of the user's memorized token and 6 digit temporary RSA pin (with no spaces or characters between them).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_rsa_initialize_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RSAInitRequest body:
        :return: RSAResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_rsa_initialize" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/rsa/initialize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RSAResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_rsa_status(self, **kwargs):  # noqa: E501
        """post-rsa-status  # noqa: E501

        Returns the status of an RSA authentication attempt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_rsa_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RSAStatusRequest body:
        :return: RSAStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_rsa_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_rsa_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_rsa_status_with_http_info(self, **kwargs):  # noqa: E501
        """post-rsa-status  # noqa: E501

        Returns the status of an RSA authentication attempt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_rsa_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RSAStatusRequest body:
        :return: RSAStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_rsa_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/rsa/status', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RSAStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_rsa_verify(self, **kwargs):  # noqa: E501
        """post-rsa-verify  # noqa: E501

        Provides RSA with the user's SecurID to complete authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_rsa_verify(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RSAVerifyRequest body:
        :return: RSAResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_rsa_verify_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_rsa_verify_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_rsa_verify_with_http_info(self, **kwargs):  # noqa: E501
        """post-rsa-verify  # noqa: E501

        Provides RSA with the user's SecurID to complete authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_rsa_verify_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RSAVerifyRequest body:
        :return: RSAResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_rsa_verify" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/rsa/verify', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RSAResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_o_auth_token(self, x_api_key, x_api_secret, **kwargs):  # noqa: E501
        """RetrieveOAuthToken  # noqa: E501

        Returns an OAuth token. The API key and secret must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_o_auth_token(x_api_key, x_api_secret, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_api_key: The API key (required)
        :param str x_api_secret: The API secret (required)
        :param str x_api_expiry: The API expiry date
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_o_auth_token_with_http_info(x_api_key, x_api_secret, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_o_auth_token_with_http_info(x_api_key, x_api_secret, **kwargs)  # noqa: E501
            return data

    def retrieve_o_auth_token_with_http_info(self, x_api_key, x_api_secret, **kwargs):  # noqa: E501
        """RetrieveOAuthToken  # noqa: E501

        Returns an OAuth token. The API key and secret must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_o_auth_token_with_http_info(x_api_key, x_api_secret, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_api_key: The API key (required)
        :param str x_api_secret: The API secret (required)
        :param str x_api_expiry: The API expiry date
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_api_secret', 'x_api_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_o_auth_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `retrieve_o_auth_token`")  # noqa: E501
        # verify the required parameter 'x_api_secret' is set
        if ('x_api_secret' not in params or
                params['x_api_secret'] is None):
            raise ValueError("Missing the required parameter `x_api_secret` when calling `retrieve_o_auth_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_api_secret' in params:
            header_params['x-api-secret'] = params['x_api_secret']  # noqa: E501
        if 'x_api_expiry' in params:
            header_params['x-api-expiry'] = params['x_api_expiry']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['httpBearer']  # noqa: E501

        return self.api_client.call_api(
            '/oauth/token', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
