# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class FileInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'metadata': 'object',
        'id': 'str',
        'file_name': 'str',
        'file_size': 'float',
        'adapter_file_path': 'str',
        'adapter': 'str',
        'data_source_id': 'str',
        'created_at': 'str',
        'modified_at': 'str',
        'created_by': 'str',
        'modified_by': 'str',
        'container_id': 'str',
        'md5hash': 'str'
    }

    attribute_map = {
        'metadata': 'metadata',
        'id': 'id',
        'file_name': 'file_name',
        'file_size': 'file_size',
        'adapter_file_path': 'adapter_file_path',
        'adapter': 'adapter',
        'data_source_id': 'data_source_id',
        'created_at': 'created_at',
        'modified_at': 'modified_at',
        'created_by': 'created_by',
        'modified_by': 'modified_by',
        'container_id': 'container_id',
        'md5hash': 'md5hash'
    }

    def __init__(self, metadata=None, id=None, file_name=None, file_size=None, adapter_file_path=None, adapter=None, data_source_id=None, created_at=None, modified_at=None, created_by=None, modified_by=None, container_id=None, md5hash=None):  # noqa: E501
        """FileInfo - a model defined in Swagger"""  # noqa: E501
        self._metadata = None
        self._id = None
        self._file_name = None
        self._file_size = None
        self._adapter_file_path = None
        self._adapter = None
        self._data_source_id = None
        self._created_at = None
        self._modified_at = None
        self._created_by = None
        self._modified_by = None
        self._container_id = None
        self._md5hash = None
        self.discriminator = None
        if metadata is not None:
            self.metadata = metadata
        self.id = id
        self.file_name = file_name
        if file_size is not None:
            self.file_size = file_size
        self.adapter_file_path = adapter_file_path
        if adapter is not None:
            self.adapter = adapter
        self.data_source_id = data_source_id
        self.created_at = created_at
        if modified_at is not None:
            self.modified_at = modified_at
        self.created_by = created_by
        if modified_by is not None:
            self.modified_by = modified_by
        self.container_id = container_id
        if md5hash is not None:
            self.md5hash = md5hash

    @property
    def metadata(self):
        """Gets the metadata of this FileInfo.  # noqa: E501


        :return: The metadata of this FileInfo.  # noqa: E501
        :rtype: object
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this FileInfo.


        :param metadata: The metadata of this FileInfo.  # noqa: E501
        :type: object
        """

        self._metadata = metadata

    @property
    def id(self):
        """Gets the id of this FileInfo.  # noqa: E501


        :return: The id of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this FileInfo.


        :param id: The id of this FileInfo.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def file_name(self):
        """Gets the file_name of this FileInfo.  # noqa: E501


        :return: The file_name of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """Sets the file_name of this FileInfo.


        :param file_name: The file_name of this FileInfo.  # noqa: E501
        :type: str
        """
        if file_name is None:
            raise ValueError("Invalid value for `file_name`, must not be `None`")  # noqa: E501

        self._file_name = file_name

    @property
    def file_size(self):
        """Gets the file_size of this FileInfo.  # noqa: E501


        :return: The file_size of this FileInfo.  # noqa: E501
        :rtype: float
        """
        return self._file_size

    @file_size.setter
    def file_size(self, file_size):
        """Sets the file_size of this FileInfo.


        :param file_size: The file_size of this FileInfo.  # noqa: E501
        :type: float
        """

        self._file_size = file_size

    @property
    def adapter_file_path(self):
        """Gets the adapter_file_path of this FileInfo.  # noqa: E501


        :return: The adapter_file_path of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._adapter_file_path

    @adapter_file_path.setter
    def adapter_file_path(self, adapter_file_path):
        """Sets the adapter_file_path of this FileInfo.


        :param adapter_file_path: The adapter_file_path of this FileInfo.  # noqa: E501
        :type: str
        """
        if adapter_file_path is None:
            raise ValueError("Invalid value for `adapter_file_path`, must not be `None`")  # noqa: E501

        self._adapter_file_path = adapter_file_path

    @property
    def adapter(self):
        """Gets the adapter of this FileInfo.  # noqa: E501


        :return: The adapter of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._adapter

    @adapter.setter
    def adapter(self, adapter):
        """Sets the adapter of this FileInfo.


        :param adapter: The adapter of this FileInfo.  # noqa: E501
        :type: str
        """

        self._adapter = adapter

    @property
    def data_source_id(self):
        """Gets the data_source_id of this FileInfo.  # noqa: E501


        :return: The data_source_id of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._data_source_id

    @data_source_id.setter
    def data_source_id(self, data_source_id):
        """Sets the data_source_id of this FileInfo.


        :param data_source_id: The data_source_id of this FileInfo.  # noqa: E501
        :type: str
        """
        if data_source_id is None:
            raise ValueError("Invalid value for `data_source_id`, must not be `None`")  # noqa: E501

        self._data_source_id = data_source_id

    @property
    def created_at(self):
        """Gets the created_at of this FileInfo.  # noqa: E501


        :return: The created_at of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this FileInfo.


        :param created_at: The created_at of this FileInfo.  # noqa: E501
        :type: str
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def modified_at(self):
        """Gets the modified_at of this FileInfo.  # noqa: E501


        :return: The modified_at of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this FileInfo.


        :param modified_at: The modified_at of this FileInfo.  # noqa: E501
        :type: str
        """

        self._modified_at = modified_at

    @property
    def created_by(self):
        """Gets the created_by of this FileInfo.  # noqa: E501


        :return: The created_by of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this FileInfo.


        :param created_by: The created_by of this FileInfo.  # noqa: E501
        :type: str
        """
        if created_by is None:
            raise ValueError("Invalid value for `created_by`, must not be `None`")  # noqa: E501

        self._created_by = created_by

    @property
    def modified_by(self):
        """Gets the modified_by of this FileInfo.  # noqa: E501


        :return: The modified_by of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """Sets the modified_by of this FileInfo.


        :param modified_by: The modified_by of this FileInfo.  # noqa: E501
        :type: str
        """

        self._modified_by = modified_by

    @property
    def container_id(self):
        """Gets the container_id of this FileInfo.  # noqa: E501


        :return: The container_id of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """Sets the container_id of this FileInfo.


        :param container_id: The container_id of this FileInfo.  # noqa: E501
        :type: str
        """
        if container_id is None:
            raise ValueError("Invalid value for `container_id`, must not be `None`")  # noqa: E501

        self._container_id = container_id

    @property
    def md5hash(self):
        """Gets the md5hash of this FileInfo.  # noqa: E501


        :return: The md5hash of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._md5hash

    @md5hash.setter
    def md5hash(self, md5hash):
        """Sets the md5hash of this FileInfo.


        :param md5hash: The md5hash of this FileInfo.  # noqa: E501
        :type: str
        """

        self._md5hash = md5hash

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FileInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
