# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class EventActionStatus(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'event_action_id': 'str',
        'status': 'str',
        'status_message': 'str',
        'created_at': 'str',
        'modified_at': 'str',
        'modified_by': 'str',
        'event': 'Event'
    }

    attribute_map = {
        'id': 'id',
        'event_action_id': 'event_action_id',
        'status': 'status',
        'status_message': 'status_message',
        'created_at': 'created_at',
        'modified_at': 'modified_at',
        'modified_by': 'modified_by',
        'event': 'event'
    }

    def __init__(self, id=None, event_action_id=None, status=None, status_message=None, created_at=None, modified_at=None, modified_by=None, event=None):  # noqa: E501
        """EventActionStatus - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._event_action_id = None
        self._status = None
        self._status_message = None
        self._created_at = None
        self._modified_at = None
        self._modified_by = None
        self._event = None
        self.discriminator = None
        if id is not None:
            self.id = id
        self.event_action_id = event_action_id
        if status is not None:
            self.status = status
        if status_message is not None:
            self.status_message = status_message
        if created_at is not None:
            self.created_at = created_at
        if modified_at is not None:
            self.modified_at = modified_at
        if modified_by is not None:
            self.modified_by = modified_by
        if event is not None:
            self.event = event

    @property
    def id(self):
        """Gets the id of this EventActionStatus.  # noqa: E501


        :return: The id of this EventActionStatus.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this EventActionStatus.


        :param id: The id of this EventActionStatus.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def event_action_id(self):
        """Gets the event_action_id of this EventActionStatus.  # noqa: E501


        :return: The event_action_id of this EventActionStatus.  # noqa: E501
        :rtype: str
        """
        return self._event_action_id

    @event_action_id.setter
    def event_action_id(self, event_action_id):
        """Sets the event_action_id of this EventActionStatus.


        :param event_action_id: The event_action_id of this EventActionStatus.  # noqa: E501
        :type: str
        """
        if event_action_id is None:
            raise ValueError("Invalid value for `event_action_id`, must not be `None`")  # noqa: E501

        self._event_action_id = event_action_id

    @property
    def status(self):
        """Gets the status of this EventActionStatus.  # noqa: E501


        :return: The status of this EventActionStatus.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this EventActionStatus.


        :param status: The status of this EventActionStatus.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def status_message(self):
        """Gets the status_message of this EventActionStatus.  # noqa: E501


        :return: The status_message of this EventActionStatus.  # noqa: E501
        :rtype: str
        """
        return self._status_message

    @status_message.setter
    def status_message(self, status_message):
        """Sets the status_message of this EventActionStatus.


        :param status_message: The status_message of this EventActionStatus.  # noqa: E501
        :type: str
        """

        self._status_message = status_message

    @property
    def created_at(self):
        """Gets the created_at of this EventActionStatus.  # noqa: E501


        :return: The created_at of this EventActionStatus.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this EventActionStatus.


        :param created_at: The created_at of this EventActionStatus.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def modified_at(self):
        """Gets the modified_at of this EventActionStatus.  # noqa: E501


        :return: The modified_at of this EventActionStatus.  # noqa: E501
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this EventActionStatus.


        :param modified_at: The modified_at of this EventActionStatus.  # noqa: E501
        :type: str
        """

        self._modified_at = modified_at

    @property
    def modified_by(self):
        """Gets the modified_by of this EventActionStatus.  # noqa: E501


        :return: The modified_by of this EventActionStatus.  # noqa: E501
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """Sets the modified_by of this EventActionStatus.


        :param modified_by: The modified_by of this EventActionStatus.  # noqa: E501
        :type: str
        """

        self._modified_by = modified_by

    @property
    def event(self):
        """Gets the event of this EventActionStatus.  # noqa: E501


        :return: The event of this EventActionStatus.  # noqa: E501
        :rtype: Event
        """
        return self._event

    @event.setter
    def event(self, event):
        """Sets the event of this EventActionStatus.


        :param event: The event of this EventActionStatus.  # noqa: E501
        :type: Event
        """

        self._event = event

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EventActionStatus, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventActionStatus):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
