# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class DataExportConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'traversal_source': 'str',
        'graphson_v1': 'bool',
        'user': 'str',
        'key': 'str',
        'endpoint': 'str',
        'port': 'str',
        'path': 'str',
        'writes_per_second': 'int'
    }

    attribute_map = {
        'traversal_source': 'traversal_source',
        'graphson_v1': 'graphson_v1',
        'user': 'user',
        'key': 'key',
        'endpoint': 'endpoint',
        'port': 'port',
        'path': 'path',
        'writes_per_second': 'writes_per_second'
    }

    def __init__(self, traversal_source=None, graphson_v1=None, user=None, key=None, endpoint=None, port=None, path=None, writes_per_second=None):  # noqa: E501
        """DataExportConfig - a model defined in Swagger"""  # noqa: E501
        self._traversal_source = None
        self._graphson_v1 = None
        self._user = None
        self._key = None
        self._endpoint = None
        self._port = None
        self._path = None
        self._writes_per_second = None
        self.discriminator = None
        self.traversal_source = traversal_source
        self.graphson_v1 = graphson_v1
        self.user = user
        self.key = key
        self.endpoint = endpoint
        self.port = port
        self.path = path
        self.writes_per_second = writes_per_second

    @property
    def traversal_source(self):
        """Gets the traversal_source of this DataExportConfig.  # noqa: E501


        :return: The traversal_source of this DataExportConfig.  # noqa: E501
        :rtype: str
        """
        return self._traversal_source

    @traversal_source.setter
    def traversal_source(self, traversal_source):
        """Sets the traversal_source of this DataExportConfig.


        :param traversal_source: The traversal_source of this DataExportConfig.  # noqa: E501
        :type: str
        """
        if traversal_source is None:
            raise ValueError("Invalid value for `traversal_source`, must not be `None`")  # noqa: E501

        self._traversal_source = traversal_source

    @property
    def graphson_v1(self):
        """Gets the graphson_v1 of this DataExportConfig.  # noqa: E501


        :return: The graphson_v1 of this DataExportConfig.  # noqa: E501
        :rtype: bool
        """
        return self._graphson_v1

    @graphson_v1.setter
    def graphson_v1(self, graphson_v1):
        """Sets the graphson_v1 of this DataExportConfig.


        :param graphson_v1: The graphson_v1 of this DataExportConfig.  # noqa: E501
        :type: bool
        """
        if graphson_v1 is None:
            raise ValueError("Invalid value for `graphson_v1`, must not be `None`")  # noqa: E501

        self._graphson_v1 = graphson_v1

    @property
    def user(self):
        """Gets the user of this DataExportConfig.  # noqa: E501


        :return: The user of this DataExportConfig.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this DataExportConfig.


        :param user: The user of this DataExportConfig.  # noqa: E501
        :type: str
        """
        if user is None:
            raise ValueError("Invalid value for `user`, must not be `None`")  # noqa: E501

        self._user = user

    @property
    def key(self):
        """Gets the key of this DataExportConfig.  # noqa: E501


        :return: The key of this DataExportConfig.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this DataExportConfig.


        :param key: The key of this DataExportConfig.  # noqa: E501
        :type: str
        """
        if key is None:
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501

        self._key = key

    @property
    def endpoint(self):
        """Gets the endpoint of this DataExportConfig.  # noqa: E501


        :return: The endpoint of this DataExportConfig.  # noqa: E501
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """Sets the endpoint of this DataExportConfig.


        :param endpoint: The endpoint of this DataExportConfig.  # noqa: E501
        :type: str
        """
        if endpoint is None:
            raise ValueError("Invalid value for `endpoint`, must not be `None`")  # noqa: E501

        self._endpoint = endpoint

    @property
    def port(self):
        """Gets the port of this DataExportConfig.  # noqa: E501


        :return: The port of this DataExportConfig.  # noqa: E501
        :rtype: str
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this DataExportConfig.


        :param port: The port of this DataExportConfig.  # noqa: E501
        :type: str
        """
        if port is None:
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501

        self._port = port

    @property
    def path(self):
        """Gets the path of this DataExportConfig.  # noqa: E501


        :return: The path of this DataExportConfig.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this DataExportConfig.


        :param path: The path of this DataExportConfig.  # noqa: E501
        :type: str
        """
        if path is None:
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501

        self._path = path

    @property
    def writes_per_second(self):
        """Gets the writes_per_second of this DataExportConfig.  # noqa: E501


        :return: The writes_per_second of this DataExportConfig.  # noqa: E501
        :rtype: int
        """
        return self._writes_per_second

    @writes_per_second.setter
    def writes_per_second(self, writes_per_second):
        """Sets the writes_per_second of this DataExportConfig.


        :param writes_per_second: The writes_per_second of this DataExportConfig.  # noqa: E501
        :type: int
        """
        if writes_per_second is None:
            raise ValueError("Invalid value for `writes_per_second`, must not be `None`")  # noqa: E501

        self._writes_per_second = writes_per_second

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DataExportConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DataExportConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
