/*
 * Decompiled with CFR 0.152.
 */
package tdb2.xloader;

import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.tdb2.xloader.BulkLoaderX;
import org.apache.jena.tdb2.xloader.ProcNodeTableBuilderX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tdb2.xloader.AbstractCmdxLoad;

public class CmdxBuildNodeTable
extends AbstractCmdxLoad {
    public static void main(String ... args) {
        new CmdxBuildNodeTable(args).mainRun();
    }

    protected CmdxBuildNodeTable(String[] argv) {
        super("Nodes", argv);
    }

    @Override
    protected void setCmdArgs() {
        super.add(argLocation, "--loc=", "Database location");
        super.add(argTmpdir, "--tmpdir=", "Temporary directory (defaults to --loc)");
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " " + this.getArgsSummary();
    }

    @Override
    protected void subCheckArgs() {
        if (this.location == null) {
            throw new CmdException("Required : --loc");
        }
        if (this.filenames.isEmpty()) {
            throw new CmdException("No files to load");
        }
    }

    @Override
    protected String getCommandName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    protected void exec() {
        FileOps.ensureDir(this.location);
        FileOps.clearAll(this.location);
        Timer timer = new Timer();
        timer.startTimer();
        FmtLog.info(LOG, "Build node table", new Object[0]);
        FmtLog.info(LOG, "  Database   = %s", this.location);
        FmtLog.info(LOG, "  TMPDIR     = %s", this.tmpdir == null ? "unset" : this.tmpdir);
        FmtLog.info(LOG, "  Data files = %s", StrUtils.strjoin(this.filenames, " "));
        if (this.tmpdir == null) {
            this.tmpdir = this.location;
        }
        Logger LOG1 = LOG;
        Logger LOG2 = LoggerFactory.getLogger("Terms");
        Pair<Long, Long> buildCounts = ProcNodeTableBuilderX.exec(LOG1, LOG2, this.location, this.loaderFiles, this.filenames, this.sortNodeTableArgs);
        long timeMillis = timer.endTimer();
        long items = buildCounts.getLeft();
        double xSec = (double)timeMillis / 1000.0;
        double rate = (double)items / xSec;
        String elapsedStr = BulkLoaderX.milliToHMS(timeMillis);
        String rateStr = BulkLoaderX.rateStr(items, timeMillis);
        FmtLog.info(LOG, "NodeTable - %s seconds - %s at %s terms per second", Timer.timeStr(timeMillis), elapsedStr, rateStr);
    }
}

