/*
 * Decompiled with CFR 0.152.
 */
package tdb.xloader;

import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.store.xloader.ProcRewriteIndex;

public class CmdRewriteIndex {
    public static void main(String ... argv) {
        if (argv.length != 3) {
            System.err.println("Usage: " + Lib.classShortName(CmdRewriteIndex.class) + " SrcLocation DstLocation IndexName");
            System.exit(1);
        }
        Location srcLoc = Location.create(argv[0]);
        Location dstLoc = Location.create(argv[1]);
        String indexName = argv[2];
        if (!FileOps.exists(argv[1])) {
            System.err.println("Destination directory does not exist");
            System.exit(1);
        }
        if (FileOps.exists(dstLoc.getPath(indexName, "idn"))) {
            System.err.println("Destination contains an index of that name");
            System.exit(1);
        }
        ProcRewriteIndex.exec(srcLoc, dstLoc, indexName);
    }

    static {
        LogCtl.setLogging();
        JenaSystem.init();
    }
}

