/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.cache.CacheManagerAware;
import org.apache.shiro.event.EventBus;
import org.apache.shiro.event.EventBusAware;
import org.apache.shiro.mgt.AuthorizingSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.util.LifecycleUtils;

public abstract class SessionsSecurityManager
extends AuthorizingSecurityManager {
    private SessionManager sessionManager = new DefaultSessionManager();

    public SessionsSecurityManager() {
        this.applyCacheManagerToSessionManager();
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.afterSessionManagerSet();
    }

    protected void afterSessionManagerSet() {
        this.applyCacheManagerToSessionManager();
        this.applyEventBusToSessionManager();
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    protected void afterCacheManagerSet() {
        super.afterCacheManagerSet();
        this.applyCacheManagerToSessionManager();
    }

    @Override
    protected void afterEventBusSet() {
        super.afterEventBusSet();
        this.applyEventBusToSessionManager();
    }

    protected void applyCacheManagerToSessionManager() {
        if (this.sessionManager instanceof CacheManagerAware) {
            ((CacheManagerAware)((Object)this.sessionManager)).setCacheManager(this.getCacheManager());
        }
    }

    protected void applyEventBusToSessionManager() {
        EventBus eventBus = this.getEventBus();
        if (eventBus != null && this.sessionManager instanceof EventBusAware) {
            ((EventBusAware)((Object)this.sessionManager)).setEventBus(eventBus);
        }
    }

    @Override
    public Session start(SessionContext context2) throws AuthorizationException {
        return this.sessionManager.start(context2);
    }

    @Override
    public Session getSession(SessionKey key) throws SessionException {
        return this.sessionManager.getSession(key);
    }

    @Override
    public void destroy() {
        LifecycleUtils.destroy(this.getSessionManager());
        this.sessionManager = null;
        super.destroy();
    }
}

