/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LetterTokenizer;

public final class StopAnalyzer
extends StopwordAnalyzerBase {
    public StopAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public StopAnalyzer(Path stopwordsFile) throws IOException {
        this(StopAnalyzer.loadStopwordSet(stopwordsFile));
    }

    public StopAnalyzer(Reader stopwords) throws IOException {
        this(StopAnalyzer.loadStopwordSet(stopwords));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        LetterTokenizer source = new LetterTokenizer();
        return new Analyzer.TokenStreamComponents(source, (TokenStream)new StopFilter(new LowerCaseFilter(source), this.stopwords));
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }
}

