/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ttl;

import java.io.File;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIException;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.ttl.JenaURIException;

@Deprecated
public class N3IRIResolver {
    private static String globalBase;
    static final IRI cwd;
    static final IRIFactory factory;
    private final IRI base;
    private static boolean showExceptions;

    private static String cwdURL() {
        return "file://" + new File("").toURI().toString().substring(5);
    }

    public static String resolveFileURL(String filename) throws IRIException {
        IRI r = cwd.resolve(filename);
        if (!r.getScheme().equalsIgnoreCase("file")) {
            return N3IRIResolver.resolveFileURL("./" + filename);
        }
        return r.toString();
    }

    public static String resolve(String relStr, String baseStr) throws JenaURIException {
        return N3IRIResolver.exceptions(N3IRIResolver.resolveIRI(relStr, baseStr)).toString();
    }

    private static IRI resolveIRI(String relStr, String baseStr) {
        IRI i = factory.create(relStr);
        if (i.isAbsolute()) {
            return cwd.create(i);
        }
        IRI base = factory.create(baseStr);
        if ("file".equalsIgnoreCase(base.getScheme())) {
            return cwd.create(base).create(i);
        }
        return base.create(i);
    }

    public N3IRIResolver() {
        this(null);
    }

    public N3IRIResolver(String baseS) {
        if (baseS == null) {
            baseS = N3IRIResolver.chooseBaseURI();
        }
        this.base = N3IRIResolver.exceptions(cwd.create(baseS));
    }

    public String getBaseIRI() {
        return this.base.toString();
    }

    public String resolve(String relURI) {
        return N3IRIResolver.exceptions(this.base.resolve(relURI)).toString();
    }

    private static IRI exceptions(IRI iri2) {
        if (showExceptions && iri2.hasViolation(false)) {
            try {
                cwd.construct(iri2);
            }
            catch (IRIException e2) {
                throw new JenaURIException(e2);
            }
        }
        return iri2;
    }

    public static void suppressExceptions() {
        N3IRIResolver.setShowExceptions(false);
    }

    public static void setShowExceptions(boolean state) {
        showExceptions = state;
    }

    public static String resolveGlobal(String str2) {
        return N3IRIResolver.exceptions(cwd.resolve(str2)).toString();
    }

    public static String chooseBaseURI() {
        return N3IRIResolver.chooseBaseURI(null);
    }

    public static String chooseBaseURI(String baseURI) {
        if (baseURI == null) {
            baseURI = "file:.";
        }
        return N3IRIResolver.resolveGlobal(baseURI);
    }

    static {
        IRI cwdx;
        globalBase = "http://localhost/LocalHostBase/";
        try {
            globalBase = N3IRIResolver.cwdURL();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        factory = new IRIFactory(IRIFactory.jenaImplementation());
        factory.shouldViolation(false, false);
        factory.securityViolation(false, false);
        factory.setIsWarning(44, false);
        factory.setIsError(44, false);
        factory.setSameSchemeRelativeReferences("file");
        try {
            cwdx = factory.construct(globalBase);
        }
        catch (IRIException e2) {
            System.err.println("Unexpected IRIException in initializer: " + e2.getMessage());
            cwdx = factory.create("file:///");
        }
        cwd = cwdx;
        showExceptions = true;
    }
}

