/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetStream;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemLocation;
import org.apache.jena.sparql.sse.builders.BuilderBinding;
import org.apache.jena.sparql.sse.builders.BuilderLib;
import org.apache.jena.sparql.sse.builders.BuilderNode;
import org.apache.jena.sparql.sse.builders.BuilderTable;

public class BuilderRowSet {
    public static RowSet build(Item item) {
        if (item.isTagged("table")) {
            return BuilderTable.build(item).toRowSet();
        }
        if (!item.isTagged("resultset") && !item.isTagged("rowset")) {
            BuilderLib.broken((ItemLocation)item, "Expected (resultset ...) or (rowset ...)", item);
        }
        return BuilderRowSet.buildRowSet(item);
    }

    static RowSet buildRowSet(Item item) {
        ItemList list = item.getList();
        List<Var> vars = BuilderNode.buildVarList(list.get(1));
        int start = 2;
        ArrayList<Binding> bindings2 = new ArrayList<Binding>();
        for (int i = start; i < list.size(); ++i) {
            Item itemRow = list.get(i);
            Binding b = BuilderBinding.build(itemRow);
            bindings2.add(b);
        }
        return new RowSetStream(vars, bindings2.iterator());
    }
}

