/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.ArrayList;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.path.PathVisitorBase;

public class TransformPathFlatternStd
extends TransformCopy {
    static VarAlloc varAlloc = new VarAlloc("?Q");

    @Override
    public Op transform(OpPath opPath) {
        TriplePath tp = opPath.getTriplePath();
        Op op = TransformPathFlatternStd.transformPath(opPath, tp.getSubject(), tp.getPath(), tp.getObject());
        return op;
    }

    static Op transformPath(OpPath op, Node subject, Path path, Node object) {
        PathTransform transform = new PathTransform(subject, object);
        path.visit(transform);
        Op r = transform.getResult();
        if (r == null) {
            if (op == null) {
                op = TransformPathFlatternStd.make(subject, path, object);
            }
            return op;
        }
        return r;
    }

    static OpPath make(Node subject, Path path, Node object) {
        TriplePath tp = new TriplePath(subject, path, object);
        return new OpPath(tp);
    }

    private static Op join(Op op1, Op op2) {
        return OpJoin.create(op1, op2);
    }

    private static Op union(Op left, Op right) {
        return new OpUnion(left, right);
    }

    static class PathTransform
    extends PathVisitorBase {
        private final Node subject;
        private final Node object;
        private Op result = null;

        Op getResult() {
            return this.result;
        }

        public PathTransform(Node subject, Node object) {
            this.subject = subject;
            this.object = object;
            this.result = null;
        }

        @Override
        public void visit(P_Link pathNode) {
            OpTriple op = new OpTriple(new Triple(this.subject, pathNode.getNode(), this.object));
            this.result = op;
        }

        @Override
        public void visit(P_ReverseLink pathNode) {
            OpTriple op = new OpTriple(new Triple(this.object, pathNode.getNode(), this.subject));
            this.result = op;
        }

        @Override
        public void visit(P_NegPropSet pathNotOneOf) {
            OpPath opFwd = null;
            OpPath opBwd = null;
            ArrayList<P_Path0> forwards = new ArrayList<P_Path0>();
            ArrayList<P_Path0> backwards = new ArrayList<P_Path0>();
            for (P_Path0 p : pathNotOneOf.getNodes()) {
                if (p.isForward()) {
                    forwards.add(p);
                    continue;
                }
                backwards.add(p);
            }
            if (!forwards.isEmpty()) {
                P_NegPropSet pFwd = new P_NegPropSet();
                for (P_Path0 p : forwards) {
                    pFwd.add(p);
                }
                opFwd = TransformPathFlatternStd.make(this.subject, pFwd, this.object);
            }
            if (!backwards.isEmpty()) {
                P_NegPropSet pBwd = new P_NegPropSet();
                for (P_Path0 p : backwards) {
                    pBwd.add(p);
                }
                opBwd = TransformPathFlatternStd.make(this.subject, pBwd, this.object);
            }
            if (opFwd == null && opBwd == null) {
                this.result = TransformPathFlatternStd.make(this.subject, pathNotOneOf, this.object);
                return;
            }
            this.result = TransformPathFlatternStd.union(opFwd, opBwd);
        }

        @Override
        public void visit(P_Inverse inversePath) {
            PathTransform pt = new PathTransform(this.object, this.subject);
            inversePath.getSubPath().visit(pt);
            this.result = pt.getResult();
        }

        @Override
        public void visit(P_Mod pathMod) {
            if (pathMod.getMin() > pathMod.getMax()) {
                throw new ARQException("Bad path: " + pathMod);
            }
            Op op = null;
            for (long i = pathMod.getMin(); i <= pathMod.getMax(); ++i) {
                Path p = PathFactory.pathFixedLength(pathMod.getSubPath(), i);
                Op sub = TransformPathFlatternStd.transformPath(null, this.subject, p, this.object);
                op = TransformPathFlatternStd.union(op, sub);
            }
            this.result = op;
        }

        @Override
        public void visit(P_FixedLength pFixedLength) {
            Op op = null;
            Node v1 = null;
            int i = 0;
            while ((long)i < pFixedLength.getCount()) {
                Var v2 = varAlloc.allocVar();
                Node s = v1 == null ? this.subject : v1;
                Node o = (long)i == pFixedLength.getCount() - 1L ? this.object : v2;
                Op op1 = TransformPathFlatternStd.transformPath(null, s, pFixedLength.getSubPath(), o);
                op = TransformPathFlatternStd.join(op, op1);
                v1 = v2;
                ++i;
            }
            this.result = op;
        }

        @Override
        public void visit(P_Alt pathAlt) {
            Op op1 = TransformPathFlatternStd.transformPath(null, this.subject, pathAlt.getLeft(), this.object);
            Op op2 = TransformPathFlatternStd.transformPath(null, this.subject, pathAlt.getRight(), this.object);
            this.result = TransformPathFlatternStd.union(op1, op2);
        }

        @Override
        public void visit(P_Seq pathSeq) {
            Var v = varAlloc.allocVar();
            Op op1 = TransformPathFlatternStd.transformPath(null, this.subject, pathSeq.getLeft(), v);
            Op op2 = TransformPathFlatternStd.transformPath(null, v, pathSeq.getRight(), this.object);
            this.result = TransformPathFlatternStd.join(op1, op2);
        }
    }
}

