/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.function.Function;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.NodeVisitor;
import org.apache.jena.graph.Node_ANY;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sys.Serializer;

public abstract class Node
implements Serializable {
    protected final Object label;
    static final int THRESHOLD = 10000;
    public static final Node ANY = new Node_ANY();
    static final String RDFprefix = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    public abstract Object visitWith(NodeVisitor var1);

    public abstract boolean isConcrete();

    public boolean isLiteral() {
        return false;
    }

    public boolean isBlank() {
        return false;
    }

    public boolean isURI() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isNodeTriple() {
        return false;
    }

    public boolean isNodeGraph() {
        return false;
    }

    public boolean isExt() {
        return false;
    }

    public BlankNodeId getBlankNodeId() {
        throw new UnsupportedOperationException(this + " is not a blank node");
    }

    public String getBlankNodeLabel() {
        return this.getBlankNodeId().getLabelString();
    }

    public LiteralLabel getLiteral() {
        throw new UnsupportedOperationException(this + " is not a literal node");
    }

    public Object getLiteralValue() {
        throw new NotLiteral(this);
    }

    public String getLiteralLexicalForm() {
        throw new NotLiteral(this);
    }

    public String getLiteralLanguage() {
        throw new NotLiteral(this);
    }

    public String getLiteralDatatypeURI() {
        throw new NotLiteral(this);
    }

    public RDFDatatype getLiteralDatatype() {
        throw new NotLiteral(this);
    }

    public boolean getLiteralIsXML() {
        throw new NotLiteral(this);
    }

    public Object getIndexingValue() {
        return this;
    }

    public String getURI() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getNameSpace() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getLocalName() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getName() {
        throw new UnsupportedOperationException("this (" + this.getClass() + ") is not a variable node");
    }

    public Triple getTriple() {
        throw new UnsupportedOperationException("this (" + this.getClass() + ") is not a embedded triple node");
    }

    public Graph getGraph() {
        throw new UnsupportedOperationException("this (" + this.getClass() + ") is not a graph-valued node");
    }

    public boolean hasURI(String uri) {
        return false;
    }

    Node(Object label) {
        this.label = label;
    }

    public abstract boolean equals(Object var1);

    public boolean sameValueAs(Object o) {
        return this.equals(o);
    }

    public int hashCode() {
        return this.label.hashCode() * 31;
    }

    public boolean matches(Node other) {
        return this.equals(other);
    }

    protected Object writeReplace() throws ObjectStreamException {
        Function<Node, Object> function = Serializer.getNodeSerializer();
        if (function == null) {
            throw new IllegalStateException("Function for Node.writeReplace not set");
        }
        return function.apply(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new IllegalStateException();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(boolean quoting) {
        return this.toString(null, quoting);
    }

    public String toString(PrefixMapping pm) {
        return this.toString(pm, true);
    }

    public String toString(PrefixMapping pm, boolean quoting) {
        return this.label.toString();
    }

    public static class NotLiteral
    extends JenaException {
        public NotLiteral(Node it) {
            super(it + " is not a literal node");
        }
    }
}

