/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.jetty;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.web.HttpSC;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class FusekiErrorHandler
extends ErrorHandler {
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String message;
        String method = request.getMethod();
        if (!(method.equals(HttpMethod.GET.asString()) || method.equals(HttpMethod.POST.asString()) || method.equals(HttpMethod.HEAD.asString()))) {
            return;
        }
        ServletOps.setNoCache(response);
        int code = response.getStatus();
        String string = message = response instanceof Response ? ((Response)response).getReason() : HttpSC.getMessage(code);
        if (message == null) {
            message = HttpSC.getMessage(code);
        }
        String msg = String.format("Error %d: %s\n", code, message);
        ServletOps.writeMessagePlainTextError(response, msg);
    }
}

