/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinatorState;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.TransactionInfo;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.dboe.transaction.txn.TxnState;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.Transactional;

public class TransactionalBase
implements TransactionalSystem {
    private final String label;
    protected boolean isShutdown = false;
    protected final TransactionCoordinator txnMgr;
    private final ThreadLocal<Transaction> theTxn = new ThreadLocal();
    private static final boolean trackAttachDetach = false;

    public TransactionalBase(String label, TransactionCoordinator txnMgr) {
        this.label = label;
        this.txnMgr = txnMgr;
    }

    public TransactionalBase(TransactionCoordinator txnMgr) {
        this(null, txnMgr);
    }

    @Override
    public TransactionCoordinator getTxnMgr() {
        return this.txnMgr;
    }

    @Override
    public TransactionCoordinatorState detach() {
        this.checkRunning();
        Transaction txn = this.theTxn.get();
        TransactionCoordinatorState coordinatorState = null;
        if (txn != null) {
            coordinatorState = this.txnMgr.detach(txn);
        }
        this.theTxn.remove();
        if (coordinatorState == null) {
            throw new TransactionException("Not attached");
        }
        return coordinatorState;
    }

    @Override
    public void attach(TransactionCoordinatorState coordinatorState) {
        Objects.nonNull(coordinatorState);
        this.checkRunning();
        this.checkNotActive();
        TxnState txnState = coordinatorState.transaction.getState();
        if (txnState != TxnState.DETACHED) {
            throw new TransactionException("Not a detached transaction");
        }
        this.txnMgr.attach(coordinatorState);
        this.theTxn.set(coordinatorState.transaction);
    }

    @Override
    public final void begin(ReadWrite readWrite) {
        this.begin(TxnType.convert(readWrite));
    }

    @Override
    public final void begin(TxnType txnType) {
        Objects.nonNull((Object)txnType);
        this.checkRunning();
        this.checkNotActive();
        Transaction transaction = this.txnMgr.begin(txnType);
        this.theTxn.set(transaction);
    }

    @Override
    public final boolean promote() {
        this.checkActive();
        return TransactionalSystem.super.promote();
    }

    @Override
    public final boolean promote(Transactional.Promote promoteMode) {
        this.checkActive();
        boolean readCommitted = promoteMode == Transactional.Promote.READ_COMMITTED;
        Transaction txn = this.getValidTransaction();
        return txn.promote(readCommitted);
    }

    @Override
    public final void commit() {
        this.checkRunning();
        TransactionalSystem.super.commit();
    }

    @Override
    public void commitPrepare() {
        Transaction txn = this.getValidTransaction();
        txn.prepare();
    }

    @Override
    public void commitExec() {
        Transaction txn = this.getValidTransaction();
        try {
            txn.commit();
        }
        finally {
            this._end();
        }
    }

    @Override
    public final void abort() {
        this.checkRunning();
        this.checkActive();
        Transaction txn = this.getValidTransaction();
        try {
            txn.abort();
        }
        finally {
            this._end();
        }
    }

    @Override
    public final void end() {
        this.checkRunning();
        this._end();
    }

    @Override
    public ReadWrite transactionMode() {
        this.checkRunning();
        Transaction txn = Lib.readThreadLocal(this.theTxn);
        if (txn != null) {
            return txn.getMode();
        }
        return null;
    }

    @Override
    public TxnType transactionType() {
        this.checkRunning();
        Transaction txn = Lib.readThreadLocal(this.theTxn);
        if (txn != null) {
            return txn.getTxnType();
        }
        return null;
    }

    @Override
    public boolean isInTransaction() {
        return Lib.readThreadLocal(this.theTxn) != null;
    }

    @Override
    public final TransactionInfo getTransactionInfo() {
        return this.getThreadTransaction();
    }

    @Override
    public final Transaction getThreadTransaction() {
        return Lib.readThreadLocal(this.theTxn);
    }

    private Transaction getValidTransaction() {
        Transaction txn = this.theTxn.get();
        if (txn == null) {
            throw new TransactionException("Not in a transaction");
        }
        return txn;
    }

    private void checkRunning() {
        if (this.isShutdown) {
            throw new TransactionException("Shutdown");
        }
    }

    public void shutdown() {
        this.txnMgr.shutdown();
        this.isShutdown = true;
    }

    protected String label(String msg) {
        if (this.label == null) {
            return msg;
        }
        return this.label + ": " + msg;
    }

    protected final void checkActive() {
        this.checkNotShutdown();
        if (!this.isInTransaction()) {
            throw new TransactionException(this.label("Not in an active transaction"));
        }
    }

    protected final void checkNotActive() {
        this.checkNotShutdown();
        if (this.isInTransaction()) {
            throw new TransactionException(this.label("Currently in an active transaction"));
        }
    }

    protected final void checkNotShutdown() {
        if (this.isShutdown) {
            throw new TransactionException(this.label("Already shutdown"));
        }
    }

    private final void _end() {
        Transaction txn = this.theTxn.get();
        if (txn != null) {
            try {
                txn.end();
            }
            finally {
                this.theTxn.set(null);
                this.theTxn.remove();
            }
        }
    }
}

